/**
 * This file is part of Totara Enterprise Extensions.
 *
 * Copyright (C) 2021 onwards Totara Learning Solutions LTD
 *
 * Totara Enterprise Extensions is provided only to Totara
 * Learning Solutions LTD's customers and partners, pursuant to
 * the terms and conditions of a separate agreement with Totara
 * Learning Solutions LTD or its affiliate.
 *
 * If you do not have an agreement with Totara Learning Solutions
 * LTD, you may not access, use, modify, or distribute this software.
 * Please contact [licensing@totaralearning.com] for more information.
 *
 * @author Simon Tegg <simon.tegg@totaralearning.com
 * @module tui_xstate
 */

import tui from 'tui/tui';
import vueXstatePlugin from '../vue_xstate_plugin';
import { inspect } from '@xstate/inspect';
import { config } from 'tui/config';

tui.useVuePlugin(vueXstatePlugin);

if (
  process.env.NODE_ENV !== 'production' &&
  (config.xstateInspect || window.location.href.includes('xstate_inspect=1'))
) {
  inspect({ iframe: false });
}
