/* eslint-disable */

const fs = require('fs');
const path = require('path');

module.exports = {
  plugins: ['promise'],
  env: {
    browser: true,
    es2020: true,
    amd: true,
  },
  globals: {
    M: true,
    Y: true,
  },
  rules: {
    // See http://eslint.org/docs/rules/ for all rules and explanations of all
    // rules.

    // === Possible Errors ===
    'comma-dangle': 'off',
    'no-compare-neg-zero': 'error',
    'no-cond-assign': 'error',
    'no-console': 'error',
    'no-constant-condition': 'error',
    'no-control-regex': 'error',
    'no-debugger': 'error',
    'no-dupe-args': 'error',
    'no-dupe-keys': 'error',
    'no-duplicate-case': 'error',
    'no-empty': 'warn',
    'no-empty-character-class': 'error',
    'no-ex-assign': 'error',
    'no-extra-boolean-cast': 'error',
    'no-extra-parens': 'off',
    'no-extra-semi': 'error',
    'no-func-assign': 'error',
    'no-inner-declarations': 'error',
    'no-invalid-regexp': 'error',
    'no-irregular-whitespace': 'error',
    'no-obj-calls': 'error',
    'no-prototype-builtins': 'off',
    'no-regex-spaces': 'error',
    'no-sparse-arrays': 'error',
    'no-unexpected-multiline': 'error',
    'no-unreachable': 'warn',
    'no-unsafe-finally': 'error',
    'no-unsafe-negation': 'error',
    'use-isnan': 'error',
    'valid-jsdoc': [
      'warn',
      {
        requireReturn: false,
        requireParamDescription: false,
        requireReturnDescription: false,
      },
    ],
    'valid-typeof': 'error',

    // === Best Practices ===
    // (these mostly match our jshint config)
    'array-callback-return': 'warn',
    'block-scoped-var': 'warn',
    complexity: 'warn',
    'consistent-return': 'warn',
    curly: 'error',
    'dot-notation': 'warn',
    'no-alert': 'warn',
    'no-caller': 'error',
    'no-case-declarations': 'error',
    'no-div-regex': 'error',
    'no-empty-pattern': 'error',
    'no-empty-function': 'warn',
    'no-eq-null': 'error',
    'no-eval': 'error',
    'no-extend-native': 'error',
    'no-extra-bind': 'warn',
    'no-fallthrough': 'error',
    'no-floating-decimal': 'warn',
    'no-global-assign': 'warn',
    'no-implied-eval': 'error',
    'no-invalid-this': 'error',
    'no-iterator': 'error',
    'no-labels': 'error',
    'no-loop-func': 'error',
    'no-multi-spaces': 'warn',
    'no-multi-str': 'error',
    'no-new-func': 'error',
    'no-new-wrappers': 'error',
    'no-octal': 'error',
    'no-octal-escape': 'error',
    'no-proto': 'error',
    'no-redeclare': 'warn',
    'no-return-assign': 'error',
    'no-script-url': 'error',
    'no-self-assign': 'error',
    'no-self-compare': 'error',
    'no-sequences': 'warn',
    'no-throw-literal': 'warn',
    'no-unmodified-loop-condition': 'error',
    'no-unused-expressions': 'error',
    'no-unused-labels': 'error',
    'no-useless-call': 'warn',
    'no-useless-escape': 'warn',
    'no-with': 'error',
    'wrap-iife': ['error', 'any'],

    // === Variables ===
    'no-delete-var': 'error',
    'no-undef': 'error',
    'no-undef-init': 'error',
    'no-unused-vars': ['warn', { caughtErrors: 'none' }],

    // === Stylistic Issues ===
    'array-bracket-spacing': 'warn',
    'block-spacing': 'warn',
    'brace-style': ['warn', '1tbs'],
    camelcase: 'warn',
    'comma-spacing': ['warn', { before: false, after: true }],
    'comma-style': ['warn', 'last'],
    'computed-property-spacing': 'error',
    'consistent-this': 'off',
    'eol-last': 'off',
    'func-call-spacing': ['warn', 'never'],
    'func-names': 'off',
    'func-style': 'off',
    // indent currently not doing well with our wrapping style, so disabled.
    indent: ['off', 4, { SwitchCase: 1 }],
    'key-spacing': [
      'warn',
      { beforeColon: false, afterColon: true, mode: 'minimum' },
    ],
    'keyword-spacing': 'warn',
    'linebreak-style': ['error', 'unix'],
    'lines-around-comment': 'off',
    'max-len': ['warn', 180], // TOTARA: changed from 132 to 180.
    'max-lines': 'off',
    'max-depth': 'warn',
    'max-nested-callbacks': ['warn', 5],
    'max-params': 'off',
    'max-statements': 'off',
    'max-statements-per-line': ['warn', { max: 2 }],
    'new-cap': ['warn', { properties: false }],
    'new-parens': 'warn',
    'newline-after-var': 'off',
    'newline-before-return': 'off',
    'newline-per-chained-call': 'off',
    'no-array-constructor': 'off',
    'no-bitwise': 'error',
    'no-continue': 'off',
    'no-inline-comments': 'off',
    'no-lonely-if': 'off',
    'no-mixed-operators': 'off',
    'no-mixed-spaces-and-tabs': 'error',
    'no-multiple-empty-lines': 'warn',
    'no-negated-condition': 'off',
    'no-nested-ternary': 'warn',
    'no-new-object': 'off',
    'no-plusplus': 'off',
    'no-tabs': 'error',
    'no-ternary': 'off',
    'no-trailing-spaces': 'error',
    'no-underscore-dangle': 'off',
    'no-unneeded-ternary': 'off',
    'no-whitespace-before-property': 'warn',
    'object-curly-newline': 'off',
    'object-curly-spacing': 'warn',
    'object-property-newline': 'off',
    'one-var': 'off',
    'one-var-declaration-per-line': ['warn', 'initializations'],
    'operator-assignment': 'off',
    'operator-linebreak': 'off',
    'padded-blocks': 'off',
    'quote-props': [
      'warn',
      'as-needed',
      { unnecessary: false, keywords: true, numbers: true },
    ],
    quotes: 'off',
    'require-jsdoc': 'warn',
    semi: 'error',
    'semi-spacing': ['warn', { before: false, after: true }],
    'sort-vars': 'off',
    'space-before-blocks': 'warn',
    'space-before-function-paren': ['warn', 'never'],
    'space-in-parens': 'warn',
    'space-infix-ops': 'warn',
    'space-unary-ops': 'warn',
    'spaced-comment': 'warn',
    'unicode-bom': 'error',
    'wrap-regex': 'off',

    // === Promises ===
    'promise/param-names': 'warn',
    'promise/catch-or-return': [
      'warn',
      { terminationMethod: ['catch', 'fail'] },
    ],
    'promise/no-promise-in-callback': 'warn',
    'promise/no-callback-in-promise': 'warn',

    // === Deprecations ===
    'no-restricted-properties': [
      'warn',
      {
        object: 'M',
        property: 'str',
        message: 'Use AMD module "core/str" or M.util.get_string()',
      },
    ],
  },
  overrides: [
    {
      files: ['**/yui/src/**/*.js'],
      // Disable some rules which we can't safely define for YUI rollups.
      rules: {
        'no-undef': 'off',
        'no-unused-vars': 'off',
        'no-unused-expressions': 'off',
      },
    },
    {
      files: ['**/amd/src/*.js'],
      // Check AMD with some slightly stricter rules.
      rules: {
        // There are instances where paremeters have been deprecated (and therefore should not be removed)
        'no-unused-vars': 'warn',
        'no-implicit-globals': 'error',
      },
    },
    {
      files: ['**/webapi/ajax/*.graphql'],
      parser: '@graphql-eslint/eslint-plugin',
      plugins: ['@graphql-eslint', 'totara'],
      rules: {
        'totara/avoid-clobber': 'error',
      },
      parserOptions: {
        schema: getSchemaFiles('ajax'),
        skipGraphQLConfig: true,
      },
    },
  ],
};

/**
 * Get all GraphQL schema files.
 *
 * @param {string} additonalSubdir additonal /webapi/ subdirs to check
 * @returns string[]
 */
function getSchemaFiles(additonalSubdir = null) {
  const gqlLocations = require(path.join(
    __dirname,
    '../graphql_locations.json'
  ));

  const dirPatterns = [];

  // add versions for general /webapi/ and additional subdir
  for (const dirPattern of Object.values(gqlLocations.locations)) {
    if (dirPattern.endsWith('/webapi/ajax/')) {
      const baseWebapiDir = dirPattern.replace(/ajax\//, '');
      dirPatterns.push(baseWebapiDir, baseWebapiDir + additonalSubdir + '/');
    }
  }

  // expand {$1} tokens to possibilities
  const potentialSchemaDirs = [];
  for (let pattern of dirPatterns) {
    pattern = pattern.slice(pattern.indexOf('/') + 1); // we went up one dir, so remove it
    if (pattern.includes('{$1}')) {
      const [pre, post] = pattern.split('{$1}');
      let listing;
      try {
        listing = fs.readdirSync(pre);
      } catch (e) {
        continue;
      }
      for (const subdir of listing) {
        potentialSchemaDirs.push(pre + subdir + post);
      }
    } else {
      potentialSchemaDirs.push(pattern);
    }
  }

  // search for .graphqls files in the directories
  const schemaFiles = [];
  for (let dir of potentialSchemaDirs) {
    let listing;
    try {
      listing = fs.readdirSync(dir);
    } catch (e) {
      continue;
    }
    for (const file of listing) {
      if (file.endsWith('.graphqls')) {
        schemaFiles.push(dir + file);
      }
    }
  }

  return schemaFiles;
}
