!function(r,o){"function"==typeof define&&define.amd?define(["jquery","./popper"],function(t,e){return r.Tour=o(t,e)}):"object"==typeof module&&module.exports?module.exports=o(require("jquery"),require("popper.js")):r.Tour=o(r.$,r.Popper)}(this,function(l,s){"use strict";var o="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t};function t(t){this.init(t)}return t.prototype.init=function(t){this.eventHandlers={},this.reset(),this.originalConfiguration=t||{},this.configure.apply(this,arguments);try{this.storage=window.sessionStorage,this.storageKey="tourstate_"+this.tourName}catch(t){this.storage=!1,this.storageKey=""}return this},t.prototype.reset=function(){return this.hide(),this.eventHandlers=[],this.resetStepListeners(),this.originalConfiguration={},this.steps=[],this.currentStepNumber=0,this},t.prototype.configure=function(t){var e=this;if("object"===(void 0===t?"undefined":o(t))){if(void 0!==t.tourName&&(this.tourName=t.tourName),t.eventHandlers){var r=void 0;for(r in t.eventHandlers)t.eventHandlers[r].forEach(function(t){this.addEventHandler(r,t)},e)}this.resetStepDefaults(!0),"object"===o(t.steps)&&(this.steps=t.steps),void 0!==t.template&&(this.templateContent=t.template)}return this.checkMinimumRequirements(),this},t.prototype.checkMinimumRequirements=function(){if(!this.tourName)throw new Error("Tour Name required");if(!this.steps||!this.steps.length)throw new Error("Steps must be specified")},t.prototype.resetStepDefaults=function(t){return void 0===t&&(t=!0),this.stepDefaults={},t&&void 0!==this.originalConfiguration.stepDefaults?this.setStepDefaults(this.originalConfiguration.stepDefaults):this.setStepDefaults({}),this},t.prototype.setStepDefaults=function(t){return this.stepDefaults||(this.stepDefaults={}),l.extend(this.stepDefaults,{element:"",placement:"top",delay:0,moveOnClick:!1,moveAfterTime:0,orphan:!1,direction:1},t),this},t.prototype.getCurrentStepNumber=function(){return parseInt(this.currentStepNumber,10)},t.prototype.setCurrentStepNumber=function(t){if(this.currentStepNumber=t,this.storage)try{this.storage.setItem(this.storageKey,t)}catch(t){t.code===DOMException.QUOTA_EXCEEDED_ERR&&this.storage.removeItem(this.storageKey)}},t.prototype.getNextStepNumber=function(t){for(var e=(t=void 0===t?this.getCurrentStepNumber():t)+1;e<=this.steps.length;){if(this.isStepPotentiallyVisible(this.getStepConfig(e)))return e;e++}return null},t.prototype.getPreviousStepNumber=function(t){for(var e=(t=void 0===t?this.getCurrentStepNumber():t)-1;0<=e;){if(this.isStepPotentiallyVisible(this.getStepConfig(e)))return e;e--}return null},t.prototype.isLastStep=function(t){return null===this.getNextStepNumber(t)},t.prototype.isFirstStep=function(t){return null===this.getPreviousStepNumber(t)},t.prototype.isStepPotentiallyVisible=function(t){return!!(t&&(this.isStepActuallyVisible(t)||void 0!==t.orphan&&t.orphan||void 0!==t.delay&&t.delay))},t.prototype.isStepActuallyVisible=function(t){return!!t&&!!((t=this.getStepTarget(t))&&t.length&&t.is(":visible"))&&!!t.length},t.prototype.next=function(){return this.gotoStep(this.getNextStepNumber())},t.prototype.previous=function(){return this.gotoStep(this.getPreviousStepNumber(),-1)},t.prototype.gotoStep=function(t,e){return t<0||null===(t=this.getStepConfig(t))?this.endTour():this._gotoStep(t,e)},t.prototype._gotoStep=function(t,e){if(!t)return this.endTour();if(void 0!==t.delay&&t.delay&&!t.delayed)t.delayed=!0,window.setTimeout(this._gotoStep.bind(this),t.delay,t,e);else{if(!t.orphan&&!this.isStepActuallyVisible(t))return this.gotoStep(this[-1==e?"getPreviousStepNumber":"getNextStepNumber"](t.stepNumber),e);this.hide(),this.fireEventHandlers("beforeRender",t),this.renderStep(t),this.fireEventHandlers("afterRender",t)}return this},t.prototype.getStepConfig=function(t){var e;return null===t||t<0||t>=this.steps.length?null:(e=this.normalizeStepConfig(this.steps[t]),l.extend(e,{stepNumber:t}))},t.prototype.normalizeStepConfig=function(t){return void 0!==t.reflex&&void 0===t.moveAfterClick&&(t.moveAfterClick=t.reflex),void 0!==t.element&&void 0===t.target&&(t.target=t.element),void 0!==t.content&&void 0===t.body&&(t.body=t.content),t=l.extend({},this.stepDefaults,t),(t=l.extend({},{attachTo:t.target,attachPoint:"after"},t)).attachTo&&(t.attachTo=l(t.attachTo).first()),t},t.prototype.getStepTarget=function(t){return t.target?l(t.target):null},t.prototype.fireEventHandlers=function(t,e){return void 0!==this.eventHandlers[t]&&this.eventHandlers[t].forEach(function(t){t.call(this,e)},this),this},t.prototype.addEventHandler=function(t,e){return void 0===this.eventHandlers[t]&&(this.eventHandlers[t]=[]),this.eventHandlers[t].push(e),this},t.prototype.processStepListeners=function(t){return this.listeners.push({node:this.currentStepNode,args:["click",'[data-role="next"]',l.proxy(this.next,this)]},{node:this.currentStepNode,args:["click",'[data-role="previous"]',l.proxy(this.previous,this)]},{node:this.currentStepNode,args:["click",'[data-role="end"]',l.proxy(this.endTour,this)]},{node:l('[data-flexitour="backdrop"]'),args:["click",l.proxy(this.hide,this)]},{node:l("body"),args:["keydown",l.proxy(this.handleKeyDown,this)]}),t.moveOnClick&&(t=this.getStepTarget(t),this.listeners.push({node:t,args:["click",l.proxy(function(t){0===l(t.target).parents('[data-flexitour="container"]').length&&window.setTimeout(l.proxy(this.next,this),500)},this)]})),this.listeners.forEach(function(t){t.node.on.apply(t.node,t.args)}),this},t.prototype.resetStepListeners=function(){return this.listeners&&this.listeners.forEach(function(t){t.node.off.apply(t.node,t.args)}),this.listeners=[],this},t.prototype.renderStep=function(t){this.currentStepConfig=t,this.setCurrentStepNumber(t.stepNumber);var e=l(this.getTemplateContent());return e.find('[data-placeholder="title"]').html(t.title),e.find('[data-placeholder="body"]').html(t.body),this.isFirstStep(t.stepNumber)?e.find('[data-role="previous"]').prop("disabled",!0):e.find('[data-role="previous"]').prop("disabled",!1),this.isLastStep(t.stepNumber)?e.find('[data-role="next"]').prop("disabled",!0):e.find('[data-role="next"]').prop("disabled",!1),e.find('[data-role="previous"]').attr("role","button"),e.find('[data-role="next"]').attr("role","button"),e.find('[data-role="end"]').attr("role","button"),t.template=e,this.addStepToPage(t),this.processStepListeners(t),this},t.prototype.getTemplateContent=function(){return l(this.templateContent).clone()},t.prototype.addStepToPage=function(t){t.template;var e,r=l('<span data-flexitour="container"></span>').html(t.template).hide(),o=l("body, html").stop(!0,!0);return this.isStepActuallyVisible(t)?((e=this.getStepTarget(t)).data("flexitour","target"),(e=this.calculateZIndex(e))&&(t.zIndex=e+1),t.zIndex&&r.css("zIndex",t.zIndex+1),this.positionBackdrop(t),l(document.body).append(r),this.currentStepNode=r,this.currentStepNode.css({top:0,left:0}),o.animate({scrollTop:this.calculateScrollTop(t)}).promise().then(function(){this.positionStep(t),this.revealStep(t)}.bind(this))):t.orphan&&(t.isOrphan=!0,t.attachTo=l("body").first(),t.attachPoint="append",this.positionBackdrop(t),r.addClass("orphan"),l(document.body).append(r),this.currentStepNode=r,this.currentStepNode.offset(this.calculateStepPositionInPage()),this.currentStepNode.css("position","fixed"),this.currentStepPopper=new s(l("body"),this.currentStepNode[0],{removeOnDestroy:!0,placement:t.placement+"-start",arrowElement:'[data-role="arrow"]',modifiers:{hide:{enabled:!1},applyStyle:{onLoad:null,enabled:!1}}}),this.revealStep(t)),this},t.prototype.revealStep=function(t){return this.currentStepNode.fadeIn("",l.proxy(function(){this.currentStepNode&&(this.announceStep(t),this.currentStepNode.focus(),window.setTimeout(l.proxy(function(){this.currentStepNode&&this.currentStepNode.focus()},this),100))},this)),this},t.prototype.announceStep=function(t){var e="tour-step-"+this.tourName+"-"+t.stepNumber,r=(this.currentStepNode.attr("id",e),this.currentStepNode.find('[data-placeholder="body"]').first()),r=(r.attr("id",e+"-body"),r.attr("role","document"),this.currentStepNode.find('[data-placeholder="title"]').first()),r=(r.attr("id",e+"-title"),r.attr("aria-labelledby",e+"-body"),this.currentStepNode.attr("role","dialog"),this.currentStepNode.attr("tabindex",0),this.currentStepNode.attr("aria-labelledby",e+"-title"),this.currentStepNode.attr("aria-describedby",e+"-body"),this.getStepTarget(t));return r&&(r.attr("tabindex")||r.attr("tabindex",0),r.data("original-describedby",r.attr("aria-describedby")).attr("aria-describedby",e+"-body")),this.accessibilityShow(t),this},t.prototype.handleKeyDown=function(d){var u="a[href], link[href], [draggable=true], [contenteditable=true], :input:enabled, [tabindex], button:enabled";switch(d.keyCode){case 27:this.endTour();break;case 9:!function(){if(this.currentStepConfig.hasBackdrop){var r=l(document.activeElement),o=this.getStepTarget(this.currentStepConfig),t=l(u),i=l('span[data-flexitour="container"]'),n=void 0,e=((t=o?t.filter(function(t,e){return null!=o&&(o.has(e).length||i.has(e).length||o.is(e)||i.is(e))}):t).each(function(t,e){if(r.is(e))return n=t,!1}),void 0),s=void 0,a=void 0;if(null!=n){var p=1;for(d.shiftKey&&(p=-1),e=n;(s=l(t[e+=p])).length&&s.is(":disabled")||s.is(":hidden"););a=!!s.length&&((a=s.closest(o).length)||s.closest(this.currentStepNode).length)}(a?s:d.shiftKey?this.currentStepNode.find(u).last():this.currentStepConfig.isOrphan?this.currentStepNode:o).focus(),d.preventDefault()}}.call(this)}},t.prototype.startTour=function(t){var e;return void 0===(t=this.storage&&void 0===t&&(e=this.storage.getItem(this.storageKey))&&(e=parseInt(e,10))<=this.steps.length?e:t)&&(t=this.getCurrentStepNumber()),this.fireEventHandlers("beforeStart",t),this.gotoStep(t),this.fireEventHandlers("afterStart",t),this},t.prototype.restartTour=function(){return this.startTour(0)},t.prototype.endTour=function(){var t;return this.fireEventHandlers("beforeEnd"),this.currentStepConfig&&(t=this.getStepTarget(this.currentStepConfig))&&(t.attr("tabindex")||t.attr("tabindex","-1"),t.focus()),this.hide(!0),this.fireEventHandlers("afterEnd"),this},t.prototype.hide=function(t){this.fireEventHandlers("beforeHide"),this.currentStepNode&&this.currentStepNode.length&&(this.currentStepNode.hide(),this.currentStepPopper)&&this.currentStepPopper.destroy(),this.currentStepConfig&&((e=this.getStepTarget(this.currentStepConfig))&&(e.data("original-labelledby")&&e.attr("aria-labelledby",e.data("original-labelledby")),e.data("original-describedby")&&e.attr("aria-describedby",e.data("original-describedby")),e.data("original-tabindex"))&&e.attr("tabindex",e.data("tabindex")),this.currentStepConfig=null);var e=0;return t&&(e=400),l('[data-flexitour="step-background"]').remove(),l('[data-flexitour="step-backdrop"]').removeAttr("data-flexitour"),l('[data-flexitour="backdrop"]').fadeOut(e,function(){l(this).remove()}),this.currentStepNode&&this.currentStepNode.length&&(t=this.currentStepNode.attr("id"))&&(l(e='[aria-describedby="'+t+'-body"]').removeAttr("tabindex"),l(e).removeAttr("aria-describedby")),this.resetStepListeners(),this.accessibilityHide(),this.fireEventHandlers("afterHide"),this.currentStepNode=null,this.currentStepPopper=null,this},t.prototype.show=function(){var t=this.getCurrentStepNumber();return this.gotoStep(t)},t.prototype.getStepContainer=function(){return l(this.currentStepNode)},t.prototype.calculateScrollTop=function(t){var e=l(window).scrollTop(),r=l(window).height(),o=this.getStepTarget(t),e="top"===t.placement?o.offset().top-r/2:"bottom"===t.placement?o.offset().top+o.height()-r/2:o.height()<=.8*r?o.offset().top-(r-o.height())/2:o.offset().top-.2*r;return e=Math.max(0,e),e=Math.min(l(document).height()-r,e),Math.ceil(e)},t.prototype.calculateStepPositionInPage=function(){var t=l(window).height(),e=this.currentStepNode.height(),r=l(window).width(),o=this.currentStepNode.width();return{top:Math.ceil((t-e)/2),left:Math.ceil((r-o)/2)}},t.prototype.positionStep=function(t){var e=this.currentStepNode;if(e&&e.length){var r=void 0;switch(t.placement){case"left":r=["left","right","top","bottom"];break;case"right":r=["right","left","top","bottom"];break;case"top":r=["top","bottom","right","left"];break;case"bottom":r=["bottom","top","right","left"];break;default:r="flip"}var o=this.getStepTarget(t),t={placement:t.placement+"-start",removeOnDestroy:!0,modifiers:{flip:{behaviour:r},arrow:{element:'[data-role="arrow"]'},preventOverflow:{boundariesElement:"window"}},onCreate:function(t){i(t)},onUpdate:function(t){i(t)}},i=function(t){var e,r,o,i,n,s,a=t.placement.split("-")[0],a=-1!==["left","right"].indexOf(a),p=t.instance.popper.querySelector('[data-role="arrow"]'),d=l(t.instance.popper.querySelector('[data-role="flexitour-step"]'));right_to_left()&&l(p).css("right","unset"),a?(a=parseFloat(window.getComputedStyle(p).height),e=parseFloat(window.getComputedStyle(p).top),r=parseFloat(window.getComputedStyle(t.instance.popper).height),i=(s=parseFloat(window.getComputedStyle(t.instance.popper).top))+(o=parseFloat(d.css("borderTopWidth")))+(n=2*parseFloat(d.css("borderTopLeftRadius"))),((s=r+s-o-n)<=(o=e+a/2)||o<=i)&&(n=0,n=r/2<o?s-a:i+a,l(p).css("top",n))):(e=parseFloat(window.getComputedStyle(p).width),r=parseFloat(window.getComputedStyle(p).left),o=parseFloat(window.getComputedStyle(t.instance.popper).width),n=(s=parseFloat(window.getComputedStyle(t.instance.popper).left))+(i=parseFloat(d.css("borderTopWidth")))+(a=2*parseFloat(d.css("borderTopLeftRadius"))),((t=o+s-i-a)<=(d=r+e/2)||d<=n)&&(s=0,s=o/2<d?t-e:n+e,l(p).css("left",s)))},n=l('[data-flexitour="step-background"]');n.length&&(o=n),this.currentStepPopper=new s(o,e[0],t)}return this},t.prototype.positionBackdrop=function(t){if(t.backdrop){this.currentStepConfig.hasBackdrop=!0;var e=l('<div data-flexitour="backdrop"></div>');if(t.zIndex?"append"===t.attachPoint?t.attachTo.append(e):e.insertAfter(t.attachTo):l("body").append(e),this.isStepActuallyVisible(t)){var r=l('<div data-flexitour="step-background"></div>'),o=this.getStepTarget(t),i=o,i=l("body"),i=(r.css({width:o.outerWidth()+10+10,height:o.outerHeight()+10+10,left:o.offset().left-10,top:o.offset().top-10,backgroundColor:this.calculateInherittedBackgroundColor(i)}),o.offset().left<10&&r.css({width:o.outerWidth()+o.offset().left+10,left:o.offset().left}),o.offset().top<10&&r.css({height:o.outerHeight()+o.offset().top+10,top:o.offset().top}),o.css("borderRadius")),i=(i&&i!==l("body").css("borderRadius")&&r.css("borderRadius",i),this.calculatePosition(o));if("fixed"===i){let t=0,e=0;var n=this.nonStaticParent;n&&n.offset()&&(t=o.offset().top-10-n.offset().top,e=o.offset().left-10-n.offset().left),r.css("left",e),r.css("top",t)}else"absolute"===i&&r.css("position","fixed");n=r.clone();n.css({backgroundColor:e.css("backgroundColor"),opacity:e.css("opacity")}),n.attr("data-flexitour","step-background-fader"),t.zIndex?"append"===t.attachPoint?t.attachTo.append(r):(n.insertAfter(t.attachTo),r.insertAfter(t.attachTo)):(l("body").append(n),l("body").append(r)),o.attr("data-flexitour","step-backdrop"),t.zIndex&&(e.css("zIndex",t.zIndex),r.css("zIndex",t.zIndex+1),o.css("zIndex",t.zIndex+2)),n.fadeOut("2000",function(){l(this).remove()})}}return this},t.prototype.calculateZIndex=function(t){for(t=l(t);t.length&&t[0]!==document;){var e=t.css("position");if("absolute"===e||"relative"===e||"fixed"===e){var r,e=parseInt(t.css("zIndex"),10);if(!isNaN(e)&&0!==e)return r=window.getComputedStyle(document.body).getPropertyValue("--zindex-navbar"),Math.max(e,r)}t=t.parent()}return 0},t.prototype.calculateInherittedBackgroundColor=function(t){var e=l("<div>").hide(),r=(l("body").append(e),e.css("backgroundColor"));for(e.remove(),t=l(t);t.length&&t[0]!==document;){var o=t.css("backgroundColor");if(o!==r)return o;t=t.parent()}return null},t.prototype.calculatePosition=function(t){for(t=l(t);t.length&&t[0]!==document;){var e=t.css("position");if("static"!==e)return this.nonStaticParent=t,e;t=t.parent()}return null},t.prototype.accessibilityShow=function(){function r(t){var e=t.data("flexitour");if(e)switch(e){case"container":case"target":return}t.attr(i)||(t.attr(o,!0),t.attr(i,!0))}var o="data-has-hidden",i="aria-hidden";this.currentStepNode.siblings().each(function(t,e){r(l(e))}),this.currentStepNode.parentsUntil("body").siblings().each(function(t,e){r(l(e))})},t.prototype.accessibilityHide=function(){var r="data-has-hidden";l("["+r+"]").each(function(t,e){void 0!==(e=l(e)).attr(r)&&(e.removeAttr(r),e.removeAttr("aria-hidden"))})},"object"===("undefined"==typeof exports?"undefined":o(exports))&&(module.exports=t),t});