@core @core_auth @javascript
Feature: Authentication
  In order to validate my credentials in the system
  As a user
  I need to log into the system

# Totara: our theme does not include login info in footer

  Scenario: Log in with the predefined admin user
    Given I log in as "admin"
    Then I should see "Admin User" in the ".usermenu .usertext" "css_element"

  Scenario: Log in as an existing admin user filling the form
    Given the following "users" exist:
      | username | password | firstname | lastname | email |
      | testuser | testuser | Test | User | moodle@example.com |
    And I am on site homepage
    When I follow "Sign in"
    And I set the field "Username" to "testuser"
    And I set the field "Password" to "testuser"
    And I press "Sign in"
    Then I should see "Test User" in the ".usermenu .usertext" "css_element"

  Scenario: Log in as an unexisting user filling the form
    Given the following "users" exist:
      | username | password | firstname | lastname | email |
      | testuser | testuser | Test | User | moodle@example.com |
    And I am on site homepage
    When I follow "Sign in"
    And I set the field "Username" to "testuser"
    And I set the field "Password" to "unexisting"
    And I press "Sign in"
    Then I should see "Invalid login, please try again"

  Scenario: Log out
    Given I log in as "admin"
    When I log out
    Then I should see "You are not logged in" in the ".login" "css_element"

  Scenario: Test regular user can log in with username and password containing trailing space
    Given I am on a totara site
    And the following "users" exist:
      | username | password | firstname | lastname | email          |
      | user1    | pass1    | Prvni     | Uzivatel | u1@example.com |

    When I use magic for persistent login to open the login page
    And I should not see "You are not logged in"
    And I should not see "You are logged in"
    And I set the field "Username" to "user1"
    And I set the field "Password" to "pass1 "
    And I press "Sign in"
    Then I should see "Prvni Uzivatel"

  @javascript @accessibility
  Scenario: Login page must be accessible
    When I am on site homepage
    # The following tests are all provided to ensure that the accessibility tests themselves are tested.
    # In normal tests only one of the following is required.
    Then the page should meet accessibility standards
    And the page should meet "wcag131, wcag412" accessibility standards
    And the page should meet accessibility standards with "wcag131, wcag412" extra tests

    And I follow "Sign in"
    And the page should meet accessibility standards
    And the page should meet "wcag131, wcag412" accessibility standards
    And the page should meet accessibility standards with "wcag131, wcag412" extra tests