<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Matthias Bonk <matthias.bonk@totara.com>
 * @package core_badges
 */

namespace core_badges\userdata;

use context;
use core_badges\entity\badge_email_verify;
use totara_userdata\userdata\item;
use totara_userdata\userdata\target_user;

defined('MOODLE_INTERNAL') || die();

/**
 * Handles a user's email verification data in table badge_email_verify.
 *
 * @package core_badges
 */
class email_verification extends item {

    /**
     * @inheritDoc
     */
    public static function is_purgeable(int $userstatus) {
        return true;
    }

    /**
     * @inheritDoc
     */
    protected static function purge(target_user $user, context $context) {
        badge_email_verify::repository()
            ->where('user_id', $user->id)
            ->delete();

        return item::RESULT_STATUS_SUCCESS;
    }

    /**
     * We don't export this data. It contains secrets.
     *
     * @return bool
     */
    public static function is_exportable() {
        return false;
    }

    /**
     * There can be one or zero records for one user, so it's countable.
     *
     * @return bool
     */
    public static function is_countable() {
        return true;
    }

    /**
     * @inheritDoc
     */
    protected static function count(target_user $user, context $context) {
        return badge_email_verify::repository()
            ->where('user_id', $user->id)
            ->count();
    }
}
