<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Kunle Odusan <kunle.odusan@totara.com>
 * @package core_ai
 */

namespace core_ai\configuration;

use admin_setting;

/**
 * Wrapper class for Totara admin settings.
 *
 * Allows settings to be flagged as secure so they are not exported or written to logs.
 */
class option {
    private admin_setting $admin_setting;

    private bool $secure;

    public function __construct(admin_setting $admin_setting, bool $secure = false) {
        $this->admin_setting = $admin_setting;
        $this->secure = $secure;
    }

    /**
     * Get the underlying admin_setting instance for this option.
     *
     * @return admin_setting
     */
    public function get_admin_setting(): admin_setting {
        return $this->admin_setting;
    }

    /**
     * Discover whether this option is secure -- that is, not written to interaction logs.
     *
     * @return bool
     */
    public function is_secure(): bool {
        return $this->secure;
    }
}
