<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    bi
 * @subpackage intellidata
 * @copyright  2021
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


use bi_intellidata\helpers\StorageHelper;
use bi_intellidata\testing\setup_helper;
use bi_intellidata\testing\test_helper;
use core_phpunit\testcase;

/**
 * Cohort migration test case.
 * @group bi_intellidata
 *
 * @package    bi
 * @subpackage intellidata
 * @copyright  2021
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or late
 */
class bi_intellidata_cohortmember_tracking_test extends testcase {

    public function setUp():void {
        self::setAdminUser();

        setup_helper::setup_tests_config();
    }

    /**
     * @covers \bi_intellidata\entities\cohortmembers\cohortmember
     * @covers \bi_intellidata\entities\cohortmembers\migration
     * @covers \bi_intellidata\entities\cohortmembers\observer::cohort_member_added
     */
    public function test_create() {
        $userdata = [
            'firstname' => 'ibuser1',
            'username' => 'ibuser1',
            'password' => 'Ibuser1!',
        ];

        $gen = self::getDataGenerator();
        $user = $gen->create_user($userdata);

        $cohortdata = [
            'name' => 'ibcohort1',
            'contextid' => '1',
        ];

        $cohort = $gen->create_cohort($cohortdata);

        $data = [
            'cohortid' => $cohort->id,
            'userid' => $user->id,
        ];

        // Create cohortmember.
        cohort_add_member($data['cohortid'], $data['userid']);

        $entity = new \bi_intellidata\entities\cohortmembers\cohortmember((object)$data);
        $entitydata = $entity->export();
        $entitydata = test_helper::filter_fields($entitydata, $data);

        $storage = StorageHelper::get_storage_service(['name' => 'cohortmembers']);

        $datarecord = $storage->get_log_entity_data('c', $data);
        $this->assertNotEmpty($datarecord);

        $datarecorddata = test_helper::filter_fields(json_decode($datarecord->data), $data);
        $this->assertEquals($entitydata, $datarecorddata);
    }

    /**
     * @covers \bi_intellidata\entities\cohortmembers\cohortmember
     * @covers \bi_intellidata\entities\cohortmembers\migration
     * @covers \bi_intellidata\entities\cohortmembers\observer::cohort_member_removed
     */
    public function test_delete() {
        global $DB;

        $this->test_create();

        $userdata = [
            'firstname' => 'ibuser1',
            'username' => 'ibuser1',
        ];

        $user = $DB->get_record('user', $userdata);

        $cohortdata = [
            'name' => 'ibcohort1',
            'contextid' => '1',
        ];

        $cohort = $DB->get_record('cohort', $cohortdata);

        $data = [
            'cohortid' => $cohort->id,
            'userid' => $user->id,
        ];

        cohort_remove_member($cohort->id, $user->id);

        $entity = new \bi_intellidata\entities\cohortmembers\cohortmember((object)$data);
        $entitydata = $entity->export();

        $storage = StorageHelper::get_storage_service(['name' => 'cohortmembers']);

        $datarecord = $storage->get_log_entity_data('d', $data);
        $this->assertNotEmpty($datarecord);

        $datarecorddata = json_decode($datarecord->data);
        $this->assertEquals($entitydata->cohortid, $datarecorddata->cohortid);
        $this->assertEquals($entitydata->userid, $datarecorddata->userid);
    }
}