<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @note Automatically cleaned: 2024-09-24
 * @package   core
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accessdenied'] = 'Access denied';
$string['accounts'] = 'Accounts';
$string['activeusercount'] = 'Number of active users';
$string['activeusercount3mth'] = 'Number of active users in last three months';
$string['addcategory'] = 'Add a category';
$string['additionalhtml'] = 'Additional HTML';
$string['additionalhtml_desc'] = 'These settings allow you to specify HTML that you want added to every page. You can set HTML that will be added within the HEAD tag for the page, immediately after the BODY tag has been opened, or immediately before the body tag is closed.<br />Doing this allows you to add custom headers or footers on every page, or add support for services like Google Analytics very easily, independent of your chosen theme.';
$string['additionalhtml_heading'] = 'Additional HTML to be added to every page.';
$string['additionalhtmlfooter'] = 'Before BODY is closed';
$string['additionalhtmlfooter_desc'] = 'Content here will be added in to every page right before the body tag is closed.';
$string['additionalhtmlhead'] = 'Within HEAD';
$string['additionalhtmlhead_desc'] = 'Content here will be added to the bottom of the HEAD tag for every page.';
$string['additionalhtmltopofbody'] = 'When BODY is opened';
$string['additionalhtmltopofbody_desc'] = 'Content here will be added in to every page immediately after the opening body tag.';
$string['addons'] = 'Add-ons';
$string['admincategory'] = 'Category: {$a}';
$string['adminseesall'] = 'Admins see all';
$string['adminseesallevents'] = 'Administrators see all events';
$string['adminseesownevents'] = 'Administrators are just like other users';
$string['advancedfeatures'] = 'Advanced features';
$string['allcountrycodes'] = 'All country codes';
$string['allowattachments'] = 'Allow attachments';
$string['allowbeforeblock'] = 'Allowed list will be processed first';
$string['allowbeforeblockdesc'] = 'By default, entries in the blocked IPs list are matched first. If this option is enabled, entries in the allowed IPs list are processed before the blocked list.';
$string['allowblockstodock'] = 'Allow blocks to use the dock';
$string['allowcategorythemes'] = 'Allow category themes';
$string['allowcoursethemes'] = 'Allow course themes';
$string['allowediplist'] = 'Allowed IP list';
$string['allowemailaddresses'] = 'Allowed email domains';
$string['allowframembedding'] = 'Allow frame embedding';
$string['allowframembedding_help'] = 'If enabled, this site may be embedded in a frame in a remote system, as recommended when using the **Publish as LTI tool** enrolment plugin. Otherwise, it is recommended to leave frame embedding disabled for security reasons.';
$string['allowguestmymoodle'] = 'Allow guest access to Dashboard';
$string['allow_http_cache'] = 'Allow page caching';
$string['allow_http_cache_desc'] = 'When enabled, pages without a specific cacheable or non-cacheable flag will allow browsers to cache content for use when the back button is pressed. When disabled, browser caching is completely prevented for all pages, regardless of whether individual pages specify they can be cached or not.';
$string['allowthemechangeonurl'] = 'Allow theme changes in the URL';
$string['allowunsafemarkup'] = 'Allow unsafe markup to user menu';
$string['allowunsafemarkupdescription'] = 'If enabled all users authorised to add or update user menu items will be able to add unsafe markup to user item.
For security reasons, it is strongly recommended to disable this option.';
$string['allowuserblockhiding'] = 'Allow users to hide blocks';
$string['allowusermailcharset'] = 'Allow user to select character set';
$string['allowuserswitchrolestheycantassign'] = 'Allow users without the assign roles capability to switch roles';
$string['allowuserthemes'] = 'Allow user themes';
$string['alternativefullnameformat'] = 'Alternative full name format';
$string['alternativefullnameformat_desc'] = 'This defines how names are shown to users with the viewfullnames capability (by default users with the role of manager, trainer or non-editing trainer). Placeholders that can be used are as for the "Full name format" setting.';
$string['always'] = 'Always';
$string['appearance'] = 'Appearance';
$string['aspellpath'] = 'Path to aspell';
$string['assessorroleid'] = 'Role for assessor';
$string['assessorroleid_help'] = 'The role is used for assessors.';
$string['authentication'] = 'Authentication';
$string['authpreventaccountcreation'] = 'Prevent account creation when authenticating';
$string['authpreventaccountcreation_help'] = 'When a user authenticates, an account on the site is automatically created if it doesn\'t yet exist. If an external database, such as LDAP, is used for authentication, but you wish to restrict access to the site to users with an existing account only, then this option should be enabled. New accounts will need to be created manually or via the upload users feature.';
$string['authsettings'] = 'Manage authentication';
$string['autolang'] = 'Language autodetect';
$string['autologinguests'] = 'Auto-login guests';
$string['availablelicenses'] = 'Available licences';
$string['availableto'] = 'Available to';
$string['backgroundcolour'] = 'Transparent colour';
$string['backups'] = 'Backups';
$string['badgesnumber'] = 'Number of badges';
$string['badwordsconfig'] = 'Enter your list of bad words separated by commas.';
$string['badwordsdefault'] = 'If the custom list is empty, a default list from the language pack will be used.';
$string['badwordslist'] = 'Custom bad words list';
$string['blockediplist'] = 'Blocked IP List';
$string['blockinstances'] = 'Instances';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protect instances';
$string['blockprotect_help'] = 'If you lock a particular type of block, then no-one will be able to add or delete instances. (You can, of course, unlock again if you need to edit instances.)

This is intended to protect blocks like the navigation and settings which are very hard to get back if accidentally deleted.';
$string['blocksettings'] = 'Manage blocks';
$string['blockunprotect'] = 'Unprotect';
$string['bloglevel'] = 'Blog visibility';
$string['bookmarkadded'] = 'Bookmark added.';
$string['bookmarkalreadyexists'] = 'You have already bookmarked this page.';
$string['bookmarkdeleted'] = 'Bookmark deleted.';
$string['bookmarkthispage'] = 'Bookmark this page';
$string['cacheapplication'] = 'Application cache';
$string['cacheapplicationhelp'] = ' Cached items are shared amoung all users and expire by a determined time to live (ttl).';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javascript caching and compression greatly improves page loading performance. It is strongly recommended for production sites. Developers will probably want to disable this feature.';
$string['cacherequest'] = 'Request cache';
$string['cacherequesthelp'] = 'User specific cache that expires when the request is complete. Designed to replace areas where we are using the static stores.';
$string['cachesession'] = 'Session cache';
$string['cachesessionhelp'] = 'User specific cache that expires when the user\'s session ends. Designed to alleviate session bloat/strain.';
$string['cachesettings'] = 'Cache settings';
$string['caching'] = 'Caching';
$string['calendar_weekend'] = 'Weekend days';
$string['calendarexportsalt'] = 'Calendar export salt';
$string['calendarsettings'] = 'Calendar';
$string['calendartype'] = 'Calendar type';
$string['calendartype_desc'] = 'Choose a default calendar type for the whole site. This setting can be overridden in the course settings or by users in their personal profile.';
$string['cannotdeletemodfilter'] = 'You cannot uninstall the \'{$a->filter}\' because it is part of the \'{$a->module}\' module.';
$string['cannotuninstall'] = '{$a} can not be uninstalled.';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = 'You have defined $CFG->wwwroot incorrectly in your config.php file. You have included a \'/\' character at the end. Please remove it, or you will experience strange bugs like <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'You have defined $CFG->wwwroot incorrectly in your config.php file. It does not match the URL you are using to access this page. Please correct it, or you will experience strange bugs like <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'change';
$string['check_allowhttpcache_details'] = '<p>When enabled, pages without a specific cacheable or non-cacheable flag will allow browsers to cache content for use when the back button is pressed.</p><p>When disabled, browser caching is completely prevented for all pages, regardless of whether individual pages specify they can be cached or not.</p>';
$string['check_allowhttpcache_name'] = 'Allow page caching';
$string['check_allowhttpcache_ok'] = 'Page caching is disabled.';
$string['check_allowhttpcache_warning'] = 'Page caching is enabled, which means some pages can be cached and may reveal sensitive information even after logout.';
$string['check_allowinlineuploadedhtml_details'] = '<p>We do not recommend turning the "Allow inline uploaded HTML" setting on.</p><p>When turned on it allows HTML files to be rendered in-browser, which can be used for cross-site scripting purposes.</p><p>This setting can only be set via the <code>$CFG->allow_inline_uploaded_html</code> option in your config file.</code></p>';
$string['check_allowinlineuploadedhtml_name'] = 'Allow inline uploaded HTML';
$string['check_allowinlineuploadedhtml_ok'] = 'The "Allow inline uploaded HTML" setting is turned off.';
$string['check_allowinlineuploadedhtml_serious'] = 'The "Allow inline uploaded HTML" setting is turned on.';
$string['check_antivirus_details'] = 'This status checks whether or not there has been a recent error detected based on the threshold set in the main antivirus settings.';
$string['check_antivirus_error'] = '{$a->errors} errors have been detected within the last {$a->lookback}';
$string['check_antivirus_info'] = 'No antivirus scanners are currently enabled';
$string['check_antivirus_logstore_not_supported'] = 'Unable to verify state of antivirus scanners due to the type of log store chosen';
$string['check_antivirus_name'] = 'Antivirus';
$string['check_antivirus_ok'] = '{$a->scanners} antivirus scanner(s) enabled, no issues have been detected in the last {$a->lookback}';
$string['check_backup'] = 'Automated backup';
$string['check_backup_comment_disable'] = 'Performance may be affected during the backup process. If enabled, backups should be scheduled for off-peak times.';
$string['check_backup_comment_enable'] = 'Performance may be affected during the backup process. Backups should be scheduled for off-peak times.';
$string['check_backup_details'] = 'Enabling automated backup will automatically create archives of all the courses on the server at the time you specified.<p>During this process, it will consume more server resources and may affect performance.</p>';
$string['check_cachejs_comment_disable'] = 'If enabled, page loading performance is improved.';
$string['check_cachejs_comment_enable'] = 'If disabled, page might load slow.';
$string['check_cachejs_details'] = 'Javascript caching and compression greatly improves page loading performance. It is strongly recommended for production sites.';
$string['check_configrw_details'] = '<p>It is recommended that the file permissions of config.php are changed after installation so that the file cannot be modified by the web server.
Please note that this measure does not improve security of the server significantly, though it may slow down or limit general exploits.</p>';
$string['check_configrw_name'] = 'Writable config.php';
$string['check_configrw_ok'] = 'config.php can not be modified by PHP scripts.';
$string['check_configrw_warning'] = 'PHP scripts may modify config.php.';
$string['check_cookiehttponly_details'] = '<p>It is recommended that HTTP only cookies is enabled to prevent client side scripts from accessing cookies set by the server, helping to mitigate the risk of XSS attacks.</p><p>The HTTP only flag is supported by all modern browsers but please be aware that older browsers may not support this flag and therefore should be considered less secure.</p>';
$string['check_cookiehttponly_error'] = 'Please enable HTTP only cookies.';
$string['check_cookiehttponly_name'] = 'HTTP only cookies';
$string['check_cookiehttponly_ok'] = 'HTTP only cookies enabled.';
$string['check_cookiesecure_details'] = '<p>If you enable https communication it is strongly recommended that you also enable secure cookies. You should also add permanent redirection from http to https. Ideally also serve HSTS headers well.</p>';
$string['check_cookiesecure_error'] = 'Please enable secure cookies';
$string['check_cookiesecure_http'] = 'You must turn on https in order to use secure cookies';
$string['check_cookiesecure_name'] = 'Secure cookies';
$string['check_cookiesecure_ok'] = 'Secure cookies enabled.';
$string['check_curlsecurityblockedhosts_details'] = '<p>We strongly advise blocking access to private addresses like localhost via cURL to prevent accessing any internal resources that should not be accessed. The following are a good starting place: {$a}</p>';
$string['check_curlsecurityblockedhosts_name'] = 'cURL blocks common private addresses';
$string['check_curlsecurityblockedhosts_ok'] = 'Common private addresses are blocked.';
$string['check_curlsecurityblockedhosts_warning'] = 'cURL is able to access common private addresses.';
$string['check_csv_export_details'] = '<p>The csv export module has security issues and will be deprecated. Please switch to CSV export (optimised for Excel) instead.</p>';
$string['check_csv_export_name'] = 'CSV export';
$string['check_csv_export_ok'] = 'CSV export is disabled.';
$string['check_csv_export_override_setting_warning'] = 'The csv export was enabled in the override report setting.';
$string['check_csv_export_setting_warning'] = 'The csv export was enabled in the general report setting.';
$string['check_csv_export_schedule_warning'] = 'The csv export was enabled in the schedule report.';
$string['check_dbschema_errors'] = 'The site database does not match the expected schema, please review for further details.';
$string['check_dbschema_name'] = 'Database Schema';
$string['check_dbschema_ok'] = 'Database schema is correct';
$string['check_debugmsg_comment_developer'] = 'If set other then DEVELOPER, performance may be improved slightly.';
$string['check_debugmsg_comment_nodeveloper'] = 'If set to DEVELOPER, performance may be affected slightly.';
$string['check_debugmsg_details'] = 'There is rarely any advantage in going to Developer level, unless you are a developer, in which case it is strongly recommended.<p>Once you have got the error message, and copied and pasted it somewhere. HIGHLY RECOMMENDED to turn Debug back to NONE. Debug messages can give clues to a hacker as to the setup of your site and may affect performance.</p>';
$string['check_defaultuserrole_details'] = '<p>All logged in users are given capabilities of the default user role. Please make sure no risky capabilities are allowed in this role.</p>
<p>The only supported legacy type for the default user role is <em>Authenticated user</em>. The course view capability must not be enabled.</p>';
$string['check_defaultuserrole_error'] = 'The default user role "{$a}" is incorrectly defined!';
$string['check_defaultuserrole_name'] = 'Default role for all users';
$string['check_defaultuserrole_notset'] = 'Default role is not set.';
$string['check_defaultuserrole_ok'] = 'Default role for all users definition is OK.';
$string['check_devgraphql_details'] = '<p>When implementing new code programmers may enable development mode for GraphQL based APIs by defining GRAPHQL_DEVELOPMENT_MODE constant in config.php. This mode must not be enabled on production servers for security and performance reasons.</p>';
$string['check_devgraphql_error'] = 'GraphQL development mode is active';
$string['check_devgraphql_name'] = 'GraphQL development mode';
$string['check_devgraphql_ok'] = 'GraphQL development mode is disabled';
$string['check_dirindex_info'] = 'Directory index should not be enabled';
$string['check_disableconsistentcleaning_details'] = '<p>We do not recommend turning on the "Disable consistent cleaning" setting</p><p>When turned on content created by trainers and other privileged users will not be consistently sanitized. HTML tags and attributes that can be used to execute security attacks will not be removed from areas such course descriptions, activity introductions and questions.</p>';
$string['check_disableconsistentcleaning_name'] = 'Disable consistent cleaning';
$string['check_disableconsistentcleaning_ok'] = 'The "Disable consistent cleaning" setting is turned off.';
$string['check_disableconsistentcleaning_serious'] = 'The "Disable consistent cleaning" setting is turned on.';
$string['check_displayerrors_details'] = '<p>Enabling the PHP setting <code>display_errors</code> is not recommended on production sites because error messages can reveal sensitive information about your server.</p>';
$string['check_displayerrors_error'] = 'The PHP setting to display errors is enabled. It is recommended that this is disabled.';
$string['check_displayerrors_name'] = 'Displaying of PHP errors';
$string['check_displayerrors_ok'] = 'Displaying of PHP errors disabled.';
$string['check_dotfiles_info'] = 'All dotfiles except /.well-known/* should not be public';
$string['check_emailchangeconfirmation_details'] = '<p>It is recommended that an email confirmation step is required when users change their email address in their profile. If disabled, spammers may try to exploit the server to send spam.</p>
<p>Email field may be also locked from authentication plugins, this possibility is not considered here.</p>';
$string['check_emailchangeconfirmation_error'] = 'Users may enter any email address.';
$string['check_emailchangeconfirmation_info'] = 'Users may enter email addresses from allowed domains only.';
$string['check_emailchangeconfirmation_name'] = 'Email change confirmation';
$string['check_emailchangeconfirmation_ok'] = 'Confirmation of change of email address in user profile.';
$string['check_embed_details'] = '<p>Unlimited object embedding is very dangerous - any registered user may launch an XSS attack against other server users. This setting should be disabled on production servers.</p>';
$string['check_embed_error'] = 'Unlimited object embedding enabled - this is very dangerous for the majority of servers.';
$string['check_embed_name'] = 'Allow EMBED and OBJECT';
$string['check_embed_ok'] = 'Unlimited object embedding is not allowed.';
$string['check_enablestats_comment_disable'] = 'Performance may be affected by statistics processing. If enabled, statistics settings should be set with caution.';
$string['check_enablestats_comment_enable'] = 'Performance may be affected by statistics processing. Statistics settings should be set with caution.';
$string['check_enablestats_details'] = 'Enabling this will process the logs in cronjob and gather some statistics. Depending on the amount of traffic on your site, this can take awhile.<p>During this process, it will consume more server resources and may affect performance.</p>';
$string['check_enablestats_name'] = 'Stats processing';
$string['check_frontpagerole_details'] = '<p>The default frontpage role is given to all registered users for frontpage activities. Please make sure no risky capabilities are allowed for this role.</p>
<p>It is recommended that a special role is created for this purpose and a legacy type role is not used.</p>';
$string['check_frontpagerole_error'] = 'Incorrectly defined frontpage role "{$a}" detected!';
$string['check_frontpagerole_name'] = 'Frontpage role';
$string['check_frontpagerole_notset'] = 'Frontpage role is not set.';
$string['check_frontpagerole_ok'] = 'Frontpage role definition is OK.';
$string['check_google_details'] = '<p>The Open to Google setting enables search engines to enter courses with guest access. There is no point in enabling this setting if guest login is not allowed.</p>';
$string['check_google_error'] = 'Search engine access is allowed but guest access is disabled.';
$string['check_google_info'] = 'Search engines may enter as guests.';
$string['check_google_name'] = 'Open to Google';
$string['check_google_ok'] = 'Search engine access is not enabled.';
$string['check_guest_details'] = '<p>It is recommended to prevent log in without user account. Please consider disabling the "Guest login" setting.</p>';
$string['check_guest_name'] = 'Guest access';
$string['check_guest_ok'] = 'Users must log in with their account.';
$string['check_guest_warning'] = 'Users may access this server as guests without password.';
$string['check_guestrole_details'] = '<p>The guest role is used for guests, not logged in users and temporary guest course access. Please make sure no risky capabilities are allowed in this role.</p>
<p>The only supported legacy type for guest role is <em>Guest</em>.</p>';
$string['check_guestrole_error'] = 'The guest role "{$a}" is incorrectly defined!';
$string['check_guestrole_name'] = 'Guest role';
$string['check_guestrole_notset'] = 'Guest role is not set.';
$string['check_guestrole_ok'] = 'Guest role definition is OK.';
$string['check_https_details'] = '<p>HTTP protocol is easily exploitable, it is strongly recommended to use HTTPS protocol on all production servers.</p>';
$string['check_https_name'] = 'HTTPS protocol';
$string['check_https_ok'] = 'HTTPS protocol is used.';
$string['check_https_warning'] = 'HTTPS protocol is not used.';
$string['check_logincsrf_details'] = '<p>It is strongly recommended to keep the CSRF protection enabled on all production sites. However it is not compatible with deprecated alternate login pages and it may interfere with some custom authentication plugins. See config.example.php for more details.</p>';
$string['check_logincsrf_error'] = 'CSRF protection is disabled on login page';
$string['check_logincsrf_name'] = 'CSRF protection on login page';
$string['check_logincsrf_ok'] = 'CSRF protection is active on login page';
$string['check_noauth_details'] = '<p>The <em>No authentication</em> plugin is not intended for production sites. Please disable it unless this is a development test site.</p>';
$string['check_noauth_error'] = 'The "No authentication" plugin cannot be used on production sites.';
$string['check_noauth_name'] = 'Auth noauth disabled';
$string['check_noauth_ok'] = 'The "No authentication" plugin is disabled.';
$string['check_nodemodules_details'] = '<p>The directory <em>{$a->path}</em> contains Node.js modules and their dependencies, typically installed by the NPM utility. These modules may be required for Totara development. They are not needed to run a Totara site and they can contain potentially dangerous code exposing your site to remote attacks.</p><p>It is strongly recommended to remove the directory if the site is available via a public URL, or at least prohibit web access to it.</p>';
$string['check_nodemodules_info'] = 'The node_modules directory should not be present on production sites.';
$string['check_nodemodules_name'] = 'Node.js modules directory';
$string['check_nodemodules_warning'] = 'The node_modules directory should no be present on a production site. These libraries are only required for development and may present a security risk.';
$string['check_oauth2verify_details'] = '<p>If OAuth 2 automatic account linking is enabled then it is recommended that all OAuth 2 providers are configured to enforce user email account verification by enabling <code>Require email verification</code> on the OAuth 2 issuers configuration page.</p><p>A possibility exists for a user to compromise the Totara account of another user with the same email address when logging in via an OAuth 2 provider.</p>';
$string['check_oauth2verify_info_confirmationrequired'] = 'All OAuth 2 login issuers require email account confirmation for account linking and creation';
$string['check_oauth2verify_info_nolinking'] = 'OAuth 2 automatic account linking is disabled';
$string['check_oauth2verify_info_serious'] = 'At least one OAuth 2 login issuer is not configured to confirm user email addresses';
$string['check_oauth2verify_name'] = 'OAuth 2 email verification';
$string['check_openprofiles_details'] = 'Open user profiles can be abused by spammers. It is recommended that either <code>Force users to log in for profiles</code> or <code>Force users to log in</code> are enabled.';
$string['check_openprofiles_error'] = 'Anyone can may view user profiles without logging in.';
$string['check_openprofiles_name'] = 'Open user profiles';
$string['check_openprofiles_ok'] = 'Login is required before viewing user profiles.';
$string['check_passwordpolicy_details'] = '<p>It is recommended that a password policy is set, since password guessing is very often the easiest way to gain unauthorised access.
Do not make the requirements too strict though, as this can result in users not being able to remember their passwords and either forgetting them or writing them down.</p>';
$string['check_passwordpolicy_error'] = 'Password policy not set.';
$string['check_passwordpolicy_name'] = 'Password policy';
$string['check_passwordpolicy_ok'] = 'Password policy enabled.';
$string['check_persistentlogin_details'] = '<p>If enabled persistent logins ignore standard session timeouts and set a permanent browser cookie. This cookie is later used to automatically re-login user after browser restart or session timeout.</p>';
$string['check_persistentlogin_name'] = 'Persistent login';
$string['check_persistentlogin_ok'] = 'Persistent login is disabled.';
$string['check_persistentlogin_warning'] = 'Persistent logins may be considered to be a security risk.';
$string['check_preventexecpath_details'] = '<p>Allowing executable paths to be set via the Admin GUI is a vector for privilege escalation.</p>';
$string['check_preventexecpath_name'] = 'Executable paths';
$string['check_preventexecpath_ok'] = 'Executable paths only settable in config.php.';
$string['check_preventexecpath_warning'] = 'Executable paths can be set in the Admin GUI.';
$string['check_publicpaths_403'] = ' (Returned a 403, ideally should be 404)';
$string['check_publicpaths_generic'] = '{$a} files should not be public';
$string['check_publicpaths_generic_unable'] = '{$a} files could not be checked';
$string['check_prohibit_flag_details'] = 'The use of the prohibit flag is known to have an impact on site performance as permission checks required advanced calculation. This is due to the prohibit flag not conforming to hierarchical norms.';
$string['check_prohibit_flag_name'] = 'Roles with prohibited capabilities';
$string['check_prohibit_flag_status_ok'] = 'No roles block permission using the prohibit flag.';
$string['check_prohibit_flag_status_warning'] = 'The prohibit flag has been used a total {$a} time(s).';
$string['check_publicpaths_name'] = 'Check all public / private paths';
$string['check_publicpaths_ok'] = 'All internal paths are not publicly accessible';
$string['check_publicpaths_unable'] = 'Some internal paths could not be checked ({$a} failed)';
$string['check_publicpaths_unknown'] = 'unknown';
$string['check_publicpaths_warning'] = 'Some internal paths are publicly accessible ({$a} errors)';
$string['check_resourcesallowxss_details'] = '<p>Users that may add or update course resources must be fully trusted because they may
use unsafe markup and files in following resource types: {$a}</p><p>It is recommended to disable all "Allow unsafe markup and files" setting.</p>';
$string['check_resourcesallowxss_name'] = 'Unsafe markup and files in course resources';
$string['check_resourcesallowxss_ok'] = 'All "Allow unsafe markup and files" resource settings are disabled.';
$string['check_resourcesallowxss_warning'] = 'Users editing course resources may use unsafe markup and files.';
$string['check_riskadmin_detailsok'] = '<p>Please verify the following list of system administrators:</p>{$a}';
$string['check_riskadmin_detailswarning'] = '<p>Please verify the following list of system administrators:</p>{$a->admins}
<p>It is recommended to assign administrator role in the system context only. The following users have (unsupported) admin role assignments in other contexts:</p>{$a->unsupported}';
$string['check_riskadmin_name'] = 'Administrators';
$string['check_riskadmin_ok'] = 'Found {$a} server administrator(s).';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) review role assignment</a>';
$string['check_riskadmin_warning'] = 'Found {$a->admincount} server administrators and {$a->unsupcount} unsupported admin role assignments.';
$string['check_riskallowxss_details'] = '<p>RISK_ALLOWXSS denotes all dangerous capabilities that only trusted users may use.</p>
<p>Please verify the following list of users and make sure that you trust them completely on this server:</p><p>{$a}</p>';
$string['check_riskallowxss_name'] = 'XSS trusted users';
$string['check_riskallowxss_warning'] = 'RISK_ALLOWXSS - found {$a} users that have to be trusted.';
$string['check_riskbackup_details_overriddenroles'] = '<p>These active overrides give users the ability to include user data in backups. Please make sure this permission is necessary.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>The following system roles currently allow users to include user data in backups.  Please make sure this permission is necessary.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Because of the above roles or local overrides, the following user accounts currently have permission to make backups containing private data from any users enrolled in their course.  Make sure they are (a) trusted and (b) protected by strong passwords:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'No roles explicitly allow backup of user data.  However, note that admins with the "doanything" capability are still likely to be able to do this.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} in {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Backup of user data';
$string['check_riskbackup_ok'] = 'No roles explicitly allow backup of user data';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) in {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Found {$a->rolecount} roles, {$a->overridecount} overrides and {$a->usercount} users with the ability to backup user data.';
$string['check_riskxss_details'] = '<p>RISK_XSS denotes all dangerous capabilities that only trusted users may use.</p>
<p>Please verify the following list of users and make sure that you trust them completely on this server:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS trusted users';
$string['check_riskxss_warning'] = 'RISK_XSS - found {$a} users that have to be trusted.';
$string['check_themedesignermode_comment_disable'] = 'If enabled, images and style sheets will not be cached, resulting in significant performance degradation.';
$string['check_themedesignermode_comment_enable'] = 'If disabled, images and style sheets are cached, resulting in significant performance improvements.';
$string['check_themedesignermode_details'] = 'This is often the cause of slow Totara sites. <p>On average it might take at least twice the amount of CPU to run a Totara site with theme designer mode enabled.</p>';
$string['check_unsecuredataroot_details'] = '<p>The dataroot directory must not be accessible via web. The best way to make sure the directory is not accessible is to use a directory outside the public web directory.</p>
<p>If you move the directory, you need to update the <code>$CFG->dataroot</code> setting in <code>config.php</code> accordingly.</p>';
$string['check_unsecuredataroot_error'] = 'Your dataroot directory <code>{$a}</code> is in the wrong location and is exposed to the web!';
$string['check_unsecuredataroot_name'] = 'Insecure dataroot';
$string['check_unsecuredataroot_ok'] = 'Dataroot directory must not be accessible via the web.';
$string['check_unsecuredataroot_warning'] = 'Your dataroot directory <code>{$a}</code> is in the wrong location and might be exposed to the web.';
$string['check_usernameenumeration_details'] = '<p>When a user\'s credentials are incorrect Totara is careful to be vague about the reason why so as to not let the user know whether the username or the password is incorrect. This means would be attackers must guess both the username and the password.</p>
<p>With Self registration turned on would be attackers can use the signup form to enumerate usernames and work out which are valid. Once a valid username has been identified they only need to guess the password.<br />To prevent this turn off Self registration.</p>
<p>With Protect usernames turned off would be attackers can use the forgotten password form to enumerate usernames and work out which are valid. Once a valid username has been identified they only need to guess the password.<br />To prevent this turn on Protect usernames.</p>';
$string['check_usernameenumeration_name'] = 'Username enumeration';
$string['check_usernameenumeration_ok'] = 'Protect usernames is enabled and Self registration is not enabled';
$string['check_usernameenumeration_warning'] = 'With Self registration turned on or Protect usernames turned off unauthenticated users may be able to guess existing usernames';
$string['check_vendordir_details'] = '<p>The directory <code>{$a->path}</code> contains various third-party libraries and their dependencies, typically installed by the PHP Composer. These libraries may be needed for local Totara development, such as for installing the PHPUnit framework. They are not needed to run a Totara site in production and they can contain potentially dangerous code exposing your site to remote attacks.</p><p>It is strongly recommended to remove the directory if the site is available via a public URL, or at least prohibit web access to it in your webserver configuration.</p>';
$string['check_vendordir_info'] = 'The vendor directory should not be present on public sites.';
$string['check_vendordir_name'] = 'Vendor directory';
$string['check_webcron_details'] = '<p>Running the cron from a web browser can expose privileged information to anonymous users. It is recommended to only run the cron from the command line or set a cron password for remote access.</p>';
$string['check_webcron_name'] = 'Web cron';
$string['check_webcron_ok'] = 'Anonymous users can not access cron.';
$string['check_webcron_warning'] = 'Anonymous users can access cron.';
$string['check_wkhtmltopdf_details'] = '<p>The PDF library wkhtmltopdf is no longer supported. If you have the binary service installed, we strongly recommend it gets removed as it is no longer maintained.</p>';
$string['check_wkhtmltopdf_name'] = 'PDF library wkhtmltopdf is not configured';
$string['check_wkhtmltopdf_ok'] = 'Library not configured or detected.';
$string['check_wkhtmltopdf_error'] = 'The setting wktohtmlpdf was detected. This library is not supported and has known security problems. Please remove both the service and the configuration in Totara.';
$string['check_xxe_risk_critical'] = 'External entities are loaded into XML by default.';
$string['check_xxe_risk_details'] = 'Some versions of LibXML and PHP potentially loaded external entities into XML by default, meaning contents of local files could be obtained by a malicious user. Ensure that you are using up-to-date versions of LibXML and PHP to help prevent against this vulnerability.';
$string['check_xxe_risk_name'] = 'XXE risk';
$string['check_xxe_risk_ok'] = 'External entities are not loaded into XML by default.';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Yes';
$string['checkephemeralconfig'] = 'Ephemeral configuration';
$string['checkephemeralconfig_details'] = '<p>From time to time, Totara bug fixes will include settings that allow system administrators to temporarily revert to previous behaviour until the next major release.</p><p>This check attempts to detect any use of those settings in config.php.</p>';
$string['checkephemeralconfig_details_found'] = '<p>The following temporary config.php settings were found:</p><ul>{$a}</ul>';
$string['checkephemeralconfig_ok'] = 'No temporary config.php settings found.';
$string['checkephemeralconfig_warning'] = 'There are config.php settings in use that will not be supported in a future version of Totara.';
$string['checkephemeralconfig_critical'] = 'There are config.php settings in use that are no longer supported in this version of Totara.';
$string['checksum'] = 'Checksum';
$string['checkupgradepending'] = 'Upgrade';
$string['choosefiletoedit'] = 'Choose file to edit';
$string['cleanup'] = 'Cleanup';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = 'Error, incorrect value "{$a->value}" for "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Incorrect value, please retry';
$string['clistatusdisabled'] = 'Status: disabled';
$string['clistatusenabled'] = 'Status: enabled';
$string['clistatusenabledlater'] = 'status: CLI maintenance mode will be enabled on {$a}';
$string['clitypevalue'] = 'type value';
$string['clitypevaluedefault'] = 'type value, press Enter to use default value ({$a})';
$string['cliunknowoption'] = 'Unrecognised options:
  {$a}
Please use --help option.';
$string['cliupgradefinished'] = 'Command line upgrade completed successfully.';
$string['cliupgradenoneed'] = 'No upgrade needed for the installed version {$a}.';
$string['cliupgradepending'] = 'An upgrade is pending';
$string['cliyesnoprompt'] = 'type y (means yes) or n (means no)';
$string['commentsmonitoring'] = 'Comments monitoring';
$string['commentsperpage'] = 'Comments displayed per page';
$string['commonactivitysettings'] = 'Common activity settings';
$string['commonfiltersettings'] = 'Common filter settings';
$string['commonsettings'] = 'Common settings';
$string['componentinstalled'] = 'Component installed';
$string['componentusage'] = 'Component usage';
$string['computedfromlogs'] = 'Computed from logs since {$a}.';
$string['condifmodeditdefaults'] = 'Default values are used in the settings form when creating a new activity or resource.';
$string['confeditorhidebuttons'] = 'Select the buttons that should be hidden in the HTML editor.';
$string['configallcountrycodes'] = 'This is the list of countries that may be selected in various places, for example in a user\'s profile. If blank (the default) the list in countries.php in the standard English language pack is used. That is the list from ISO 3166-1. Otherwise, you can specify a comma-separated list of codes, for example \'GB,FR,ES\'. If you add new, non-standard codes here, you will need to add them to countries.php in \'en\' and your language pack.';
$string['configallowassign'] = 'You can allow people who have the roles on the left side to assign some of the column roles to other people';
$string['configallowattachments'] = 'If enabled, emails sent from the site can have attachments, such as badges.';
$string['configallowblockstodock'] = 'If enabled and supported by the selected theme users can choose to move blocks to a special dock.';
$string['configallowcategorythemes'] = 'If you enable this, then themes can be set at the category level. This will affect all child categories and courses unless they have specifically set their own theme. WARNING: Enabling category themes may affect performance.';
$string['configallowcoursethemes'] = 'If you enable this, then courses will be allowed to set their own themes.  Course themes override all other theme choices (site, user, or session themes)';
$string['configallowemailaddresses'] = 'To restrict new email addresses to particular domains, list them here separated by spaces. All other domains will be rejected. To allow subdomains, add the domain with a preceding \'.\'. To allow a root domain together with its subdomains, add the domain twice - once with a preceding \'.\' and once without e.g. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowguestmymoodle'] = 'If enabled guests can access My learning, otherwise guests are redirected to the site front page.';
$string['configallowoverride'] = 'You can allow people with the roles on the left side to override some of the column roles';
$string['configallowoverride2'] = 'Select which role(s) can be overridden by each role in the left column.<br />Note that these settings only apply to users who have either the capability moodle/role:override or the capability moodle/role:safeoverride allowed.';
$string['configallowswitch'] = 'Select which roles a user may switch to, based on which roles they already have. In addition to an entry in this table, a user must also have the moodle/role:switchroles capability to be able to switch.<br />Note that it is only possible to switch to roles that have the moodle/course:view capability, and that do not have the moodle/site:doanything capability, so some columns in this table are disabled.';
$string['configallowthemechangeonurl'] = 'If enabled, the theme can be changed by adding either:<br />?theme=themename to any Totara URL (eg: mytotarasite.com/?theme=afterburner ) or <br />&theme=themename to any internal Totara URL (eg: mytotarasite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Do you want to allow users to hide/show side blocks throughout this site?  This feature uses Javascript and cookies to remember the state of each collapsible block, and only affects the user\'s own view.';
$string['configallowusermailcharset'] = 'If enabled, users can choose an email charset in their messaging preferences.';
$string['configallowuserswitchrolestheycantassign'] = 'By default, moodle/role:assign is required for users to switch roles. Enabling this setting removes this requirement, and results in the roles available in the "Switch role to" dropdown menu being determined by settings in the "Allow role assignments" table only.
It is recommended that the settings in the "Allow role assignments" table do not allow users to switch to a role with more capabilities than their existing role.';
$string['configallowuserthemes'] = 'If you enable this, then users will be allowed to set their own themes.  User themes override site themes (but not course themes)';
$string['configallusersaresitestudents'] = 'For activities on the front page of the site, should ALL users be considered as learners?  If you answer "Yes", then any confirmed user account will be allowed to participate as a learner in those activities.  If you answer "No", then only users who are already a participant in at least one course will be able to take part in those front page activities. Only admins and specially assigned trainers can act as trainers for these front page activities.';
$string['configauthenticationplugins'] = 'Please choose the authentication plugins you wish to use and arrange them in order of failthrough.';
$string['configautolang'] = 'Detect default language from browser setting, if disabled site default is used.';
$string['configautologinguests'] = 'Should visitors be logged in as guests automatically?';
$string['configbloglevel'] = 'This setting allows you to restrict the level to which user blogs can be viewed on this site.  Note that they specify the maximum context of the VIEWER not the poster or the types of blog posts.  Blogs can also be disabled completely if you don\'t want them at all.';
$string['configcalendarcustomexport'] = 'Enable custom date range export of calendar';
$string['configcalendarexportsalt'] = 'This random text is used for improving of security of authentication tokens used for exporting of calendars. A unique random value is generated during installation. If security is a concern we recommend changing this value after installation. Please note that all current tokens are invalidated if you change this value. You can disable calendar export by turning off the enablecalendarexport.';
$string['configcookiehttponly'] = 'Enables new PHP 5.2.0 feature - browsers are instructed to send cookie with real http requests only, cookies should not be accessible by scripting languages. This is not supported in all browsers and it may not be fully compatible with current code. It helps to prevent some types of XSS attacks.';
$string['configcookiesecure'] = 'If server is accepting only https connections it is recommended to enable sending of secure cookies. If enabled please make sure that web server is not accepting http:// or set up permanent redirection to https:// address and ideally send HSTS headers. When <em>wwwroot</em> address does not start with https:// this setting is ignored.';
$string['configcountry'] = 'If you set a country here, then this country will be selected by default on new user accounts.  To force users to choose a country, just leave this unset.';
$string['configcourseoverviewfilesext'] = 'A comma-separated list of allowed course summary files extensions.';
$string['configcourseoverviewfileslimit'] = 'The maximum number of files that can be attached to a course summary.';
$string['configcourserequestnotify'] = 'Type username of user to be notified when new course requested.';
$string['configcourserequestnotify2'] = 'Users who will be notified when a course is requested. Only users who can approve course requests are listed here.';
$string['configcoursesperpage'] = 'Enter the number of courses to be displayed per page in a course listing.';
$string['configcoursesperpageenhcatenabled'] = 'Report-based catalogue is enabled. To change the number of records displayed, edit the report, go to the "General" tab, and change the "Number of records per page".';
$string['configcourseswithsummarieslimit'] = 'The maximum number of courses to display in a course listing including summaries before falling back to a simpler listing.';
$string['configcronclionly'] = 'Running the cron from a web browser can expose privileged information to anonymous users. Thus it is recommended to only run the cron from the command line or set a cron password for remote access.';
$string['configcronremotepassword'] = 'This means that the cron.php script cannot be run from a web browser without supplying the password using the following form of URL:<pre>
    http://site.example.com/admin/cron.php?password=opensesame
</pre>If this is left empty, no password is required.';
$string['configcurlcache'] = 'Time-to-live for cURL cache, in seconds.';
$string['configcustomusermenuitems'] = 'You can configure the contents of the user menu (with the exception of the log out link, which is automatically added). Each line is separated by | characters and consists of 1) a string in "langstringname, componentname" form or as plain text, 2) a URL, and 3) an icon either as a pix icon or as a URL. Dividers can be used by adding a line of one or more # characters where desired.';
$string['configdbsessions'] = 'If enabled, this setting will use the database to store information about current sessions. Note that changing this setting now will log out all current users (including you). If you are using MySQL please make sure that \'max_allowed_packet\' in my.cnf (or my.ini) is at least 4M. Other session drivers can be configured directly in config.php, see config.example.php for more information. This option disappears if you specify session driver in config.php file.';
$string['configdebug'] = 'If you turn this on, then PHP\'s error_reporting will be increased so that more warnings are printed.  This is only useful for developers.';
$string['configdebugdisplay'] = 'Set to on, the error reporting will go to the HTML page. This is practical, but breaks XHTML, JS, cookies and HTTP headers in general. Set to off, it will send the output to your server logs, allowing better debugging. The PHP setting error_log controls which log this goes to.';
$string['configdebugpageinfo'] = 'Enable if you want page information printed in page footer.';
$string['configdebugsmtp'] = 'Enable verbose debug information during sending of email messages to SMTP server.';
$string['configdebugvalidators'] = 'Enable if you want to have links to external validator servers in page footer. You may need to create new user with username <em>w3cvalidator</em>, and enable guest access. These changes may allow unauthorized access to server, do not enable on production sites!';
$string['configdefaulthomepage'] = 'This determines the home page for logged in users';
$string['configdefaultrequestcategory'] = 'Courses requested by users will be automatically placed in this category.';
$string['configdefaultrequestedcategory'] = 'Default category to put courses that were requested into, if they\'re approved.';
$string['configdefaultuserroleid'] = 'All logged in users will be given the capabilities of the role you specify here, at the site level, in ADDITION to any other roles they may have been given.  The default is the Authenticated user role.  Note that this will not conflict with other roles they have unless you prohibit capabilities, it just ensures that all users have capabilities that are not assignable at the course level (eg post blog entries, manage own calendar, etc).';
$string['configdeleteincompleteusers'] = 'After this period, old not fully setup accounts are deleted.';
$string['configdeleteunconfirmed'] = 'For certain authentication methods, such as email-based self-registration, users must confirm their account within a certain time. After this period, any old unconfirmed accounts are deleted.';
$string['configdenyemailaddresses'] = 'To deny email addresses from particular domains list them here in the same way.  All other domains will be accepted. To deny subdomains add the domain with a preceding \'.\'. eg <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Disable the ability for users to change user profile images.';
$string['configdisplayloginfailures'] = 'This will display information to users about previous failed logins.';
$string['configdndallowtextandlinks'] = 'Enable or disable the dragging and dropping of text and links onto a course page, alongside the dragging and dropping of files. Note that the dragging of text into Firefox or between different browsers is unreliable and may result in no data being uploaded, or corrupted text being uploaded.';
$string['configdoclang'] = 'This language will be used in links for the documentation pages.';
$string['configdocroot'] = 'Defines the path for providing context-specific documentation. If the field is left blank, links will not be displayed.';
$string['configdoctonewwindow'] = 'If you enable this, then links to Docs will be shown in a new window.';
$string['configeditordictionary'] = 'This value will be used if aspell doesn\'t have dictionary for users own language.';
$string['configeditorfontlist'] = 'Select the fonts that should appear in the editor\'s drop-down list.';
$string['configemailchangeconfirmation'] = 'Require an email confirmation step when users change their email address in their profile.';
$string['configemailfromvia'] = 'Add via information in the "From" section of outgoing email. This informs the recipient from where this email came from and also helps combat recipients accidentally replying to no-reply email addresses.';
$string['configenableactivitychooser'] = 'The activity chooser is a dialog box with a short description of each activity and resource. If disabled, separate resource and activity dropdown menus are provided instead.';
$string['configenableblogs'] = 'Enable users to create their own blog.';
$string['configenablecalendarexport'] = 'When enabled users will be able to export their calendar entries and configure external calendar applications to consume calendar events directly from Totara. To facilitate this a token is calculated for each user and included in the subscription URL. For this reason users should be informed to keep their calendar exports private and not to share them with others.';
$string['configenablecomments'] = 'Enable comments';
$string['configenablecourserequests'] = 'This will allow any user to request a course be created.';
$string['configenabledevicedetection'] = 'Enables detection of mobiles, smartphones, tablets or default devices (desktop PCs, laptops, etc) for the application of themes and other features.';
$string['configenablerssfeeds'] = 'When enabled, RSS feeds will be generated by various features across the site, such as blogs, forums, database activities and glossaries. Note that RSS feeds also need to be enabled for the particular activity modules.';
$string['configenablerssfeedsdisabled'] = 'It is not available because RSS feeds are disabled in all the Site. To enable them, go to the Variables settings under Admin Configuration.';
$string['configenablerssfeedsdisabled2'] = 'RSS feeds are currently disabled at site level. They may be enabled in Configure features in Site administration.';
$string['configenablesafebrowserintegration'] = 'This adds the choice \'Require Safe Exam Browser\' to the \'Browser security\' field on the quiz settings form. See http://www.safeexambrowser.org/ for more information.';
$string['configenablestats'] = 'Enable statistics to see graphs and statistics about each of your courses or on a sitewide bases. Note: Totara\'s cronjob will process the logs and gather statistics. This can take a significant amount of time if your site is heavily used.';
$string['configenablewebservices'] = 'Allow external systems to connect to your Totara site to access data and perform operations. Web services will eventually be deprecated and it\'s recommended that you use the API instead.';
$string['configenablewsdocumentation'] = 'Enable auto-generation of web services documentation. A user can access their own documentation on their security keys page {$a}. It displays the documentation for the enabled protocols only.';
$string['configengagesettings'] = 'Engage settings';
$string['configerrorlevel'] = 'Choose the amount of PHP warnings that you want to be displayed.  Normal is usually the best choice.';
$string['configexportlookahead'] = 'Days to look ahead during export';
$string['configexportlookback'] = 'Days to look back during export';
$string['configextendedusernamechars'] = 'Enable this setting to allow learners to use any characters in their usernames (note this does not affect their actual names).  The default is "false" which restricts usernames to be alphanumeric lowercase characters, underscore (_), hyphen (-), period (.) or at symbol (@).';
$string['configextramemorylimit'] = 'Some scripts like search, backup/restore or cron require more memory. Set higher values for large sites.';
$string['configfeatures'] = 'Configure features';
$string['configfilterall'] = 'Filter all strings, including headings, titles, navigation bar and so on.  This is mostly useful when using the multilang filter, otherwise it will just create extra load on your site for little gain.';
$string['configfiltermatchoneperpage'] = 'Automatic linking filters will only generate a single link for the first matching text instance found on the complete page. All others are ignored.';
$string['configfiltermatchonepertext'] = 'Automatic linking filters will only generate a single link for the first matching text instance found in each item of text (e.g., resource, block) on the page. All others are ignored. This setting is ignored if the one per page setting is <i>yes</i>.';
$string['configfilteruploadedfiles'] = 'Process all uploaded HTML and text files with the filters before displaying them, only uploaded HTML files or none at all.';
$string['configforcelogin'] = 'Normally, the front page of the site and the course listings (but not courses) can be read by people without logging in to the site.  If you want to force people to log in before they do ANYTHING on the site, then you should enable this setting.';
$string['configforceloginforprofiles'] = 'This setting forces people to log in as a real (non-guest) account before viewing any user\'s profile. If you disabled this setting, you may find that some users post advertising (spam) or other inappropriate content in their profiles, which is then visible to the whole world.';
$string['configfullnamedisplay'] = 'This defines how names are shown when they are displayed in full. The default value, "language", leaves it to the string "fullnamedisplay" in the current language pack to decide. Some languages have different name display conventions.

For most mono-lingual sites the most efficient setting is "firstname lastname", but you may choose to hide surnames altogether. Placeholders that can be used are: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'Location of GeoLite2 City binary data file. This file is not part of Totara distribution and must be obtained separately from <a href="http://www.maxmind.com/">MaxMind</a>. You can either buy a commercial version or use the free version. Simply download <a href="http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a> and extract it into "{$a}" directory on your server.';
$string['configgetremoteaddrconf'] = 'If your server is behind a reverse proxy, you can use this setting to specify which HTTP headers can be trusted to contain the remote IP address. The headers are read in order, using the first one that is available.';
$string['configgradebookroles'] = 'This setting allows you to control who appears on the gradebook.  Users need to have at least one of these roles in a course to be shown in the gradebook for that course.';
$string['configgradeexport'] = 'Choose which gradebook export formats are your primary methods for exporting grades.  Chosen plugins will then set and use a "last exported" field for every grade.  For example, this might result in exported records being identified as being "new" or "updated".  If you are not sure about this then leave everything unchecked.';
$string['configguesthomepage'] = 'For any dashboard you wish to include you must change its default setting to allow guest access (see Dashboard settings)';
$string['confighiddenuserfields'] = 'Select which user information fields you wish to hide from other users other than course trainers/admins. This will increase learner privacy. Hold CTRL key to select multiple fields.';
$string['configidnumber'] = 'This option specifies whether (a) Users are not be asked for an ID number at all, (b) Users are asked for an ID number but can leave it blank or (c) Users are asked for an ID Number and cannot leave it blank. If given the User\'s ID number is displayed in their Profile.';
$string['configintcachemax'] = 'For internal cache only. Maximum number of records to keep in the cache. Recommended value: 50. Use lower values to reduce memory usage.';
$string['configintro'] = 'On this page you can specify a number of configuration variables that help make Totara work properly on your server.  Don\'t worry too much about it - the defaults will usually work fine and you can always come back to this page later and change these settings.';
$string['configintroadmin'] = 'On this page you should configure your main administrator account which will have complete control over the site. Make sure you give it a secure username and password as well as a valid email address.  You can create more admin accounts later on.';
$string['configintrosite'] = 'This page allows you to configure the front page and name of this new site.  You can come back here later to change these settings any time using the Administration menus.';
$string['configiplookup'] = 'When you click on an IP address (such as 34.12.222.93), such as in the logs, you are shown a map with a best guess of where that IP is located.  There are different plugins for this that you can choose from, each has benefits and disadvantages.';
$string['configkeeptagnamecase'] = 'Check this if you want tag names to keep the original casing as entered by users who created them';
$string['configlang'] = 'Choose a default language for the whole site. Users can override this setting using the language menu or the setting in their personal profile.';
$string['configlanglist'] = 'Leave this blank to allow users to choose from any language you have in this installation of Totara.  However, you can shorten the language menu by entering a comma-separated list of language codes that you want.  For example:  en,es_es,fr,it';
$string['configlangmenu'] = 'Choose whether or not you want to display the general-purpose language menu on the home page, login page etc.  This does not affect the user\'s ability to set the preferred language in their own profile.';
$string['configlangstringcache'] = 'Caches all the language strings into compiled files in the data directory.  If you are translating Totara or changing strings in the Totara source code then you may want to switch this off.  Otherwise leave it on to see performance benefits.';
$string['configlatinexcelexport'] = 'Choose the encoding for Excel exports.';
$string['configlearnsettings'] = 'Learn settings';
$string['configlocale'] = 'Choose a sitewide locale - this will override the format and language of dates for all language packs (though names of days in calendar are not affected). You need to have this locale data installed on your operating system (eg for linux en_US.UTF-8 or es_ES.UTF-8). In most cases this field should be left blank.';
$string['configloglifetime'] = 'This specifies the length of time you want to keep logs about user activity.  Logs that are older than this age are automatically deleted.  It is best to keep logs as long as possible, in case you need them, but if you have a very busy server and are experiencing performance problems, then you may want to lower the log lifetime. Values lower than 30 are not recommended because statistics may not work properly.';
$string['configlookahead'] = 'Days to look ahead';
$string['configmailnewline'] = 'Newline characters used in mail messages. CRLF is required according to RFC 822bis, some mail servers do automatic conversion from LF to CRLF, other mail servers do incorrect conversion from CRLF to CRCRLF, yet others reject mails with bare LF (qmail for example). Try changing this setting if you are having problems with undelivered emails or double newlines.';
$string['configmaxbytes'] = 'This specifies a maximum size for files uploaded to the site. This setting is limited by the PHP settings post_max_size and upload_max_filesize, as well as the Apache setting LimitRequestBody. In turn, maxbytes limits the range of sizes that can be chosen at course or activity level. If \'Site upload limit\' is chosen, the maximum size allowed by the server will be used.';
$string['configmaxbytesextracted'] = 'This specifies a maximum size for the collective files contained in an archive file.';
$string['configmaxconsecutiveidentchars'] = 'Passwords must not have more than this number of consecutive identical characters. Use 0 to disable this check.';
$string['configmaxeditingtime'] = 'This specifies the amount of time people have to re-edit forum postings, glossary comments etc.  Usually 30 minutes is a good value.';
$string['configmaxevents'] = 'Events to Lookahead';
$string['configmaxusersperpage'] = 'Maximum number of users displayed within user selector in course, group, audience, webservice etc.';
$string['configmessaging'] = 'Enable the messaging system between site users. Note: alerts, tasks and their associated emails depend on this setting.';
$string['configmessaging_v2'] = 'Enable the messaging system between site users.';
$string['configmessagingallowemailoverride'] = 'Allow users to have notifications sent to an email address that is not the email address in their profile.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Read notifications can be deleted to save space. Set the timeframe for deleting a notification after it has been read.';
$string['configmessaginghidereadnotifications'] = 'Hide read notifications of events like forum posts when viewing messaging history';
$string['configminpassworddigits'] = 'Passwords must have at least these many digits.';
$string['configminpasswordlength'] = 'Passwords must be at least these many characters long.';
$string['configminpasswordlower'] = 'Passwords must have at least these many lower case letters.';
$string['configminpasswordnonalphanum'] = 'Passwords must have at least these many non-alphanumeric characters.';
$string['configminpasswordupper'] = 'Passwords must have at least these many upper case letters.';
$string['configmodchooserdefault'] = 'Should the activity chooser be presented to users by default?';
$string['configmycoursesperpage'] = 'Maximum number of courses to display in any list of a user\'s own courses';
$string['configmymoodleredirect'] = 'This setting forces redirects to /my on login for non-admins and replaces the top level site navigation with /my';
$string['configmypagelocked'] = 'This setting prevents the default page from being edited by any non-admins';
$string['confignavcourselimit'] = 'Limits the number of courses shown to the user in the navigation.';
$string['confignavshowallcourses'] = 'This setting determines whether users who are enrolled in courses can see Courses (listing all courses) in the navigation, in addition to My Courses (listing courses in which they are enrolled).';
$string['confignavshowcategories'] = 'Show course categories in the navigation bar and navigation blocks. This does not occur with courses the user is currently enrolled in, they will still be listed under mycourses without categories.';
$string['confignoreplyaddress'] = 'Enter email address to be used in the "From" field of all outgoing emails. This email address should usually match the user account for SMTP authentication. If this setting is empty or incorrect then outgoing emails are likely to get marked as spam or are not delivered at all.';
$string['confignotificationsettings'] = 'Messaging and notification settings';
$string['confignotifyloginfailures'] = 'Send login failure notification messages to these selected users. This requires an internal logstore (eg Standard Logstore) to be enabled.';
$string['confignotifyloginthreshold'] = 'If notifications about failed logins are active, how many failed login attempts by one user or one IP address is it worth notifying about?';
$string['confignotloggedinroleid'] = 'Users who are not logged in to the site will be treated as if they have this role granted to them at the site context.  Guest is almost always what you want here, but you might want to create roles that are less or more restrictive.  Things like creating posts still require the user to log in properly.';
$string['configopentogoogle'] = 'If you enable this setting, then Google will be allowed to enter your site as a Guest.  In addition, people coming in to your site via a Google search will automatically be logged in as a Guest.  Note that this only provides transparent access to courses that already allow guest access.';
$string['configoverride'] = 'This setting can only be changed in config.php where it has been defined.';
$string['configpasswordpolicy'] = 'Turning this on will make Totara check user passwords against a valid password policy. Use the settings below to specify your policy (they will be ignored if you set this to \'No\').';
$string['configpasswordresettime'] = 'This specifies the amount of time people have to validate a password reset request before it expires. Usually 30 minutes is a good value.';
$string['configpathtodu'] = 'Path to du. Probably something like /usr/bin/du. If you enter this, pages that display directory contents will run much faster for directories with a lot of files.';
$string['configperfdebug'] = 'If you turn this on, performance info will be printed in the footer of the standard theme';
$string['configperformsettings'] = 'Perform settings';
$string['configprofileroles'] = 'List of roles that are visible on user profiles and participation page.';
$string['configprofilesforenrolledusersonly'] = 'To prevent misuse by spammers, profile descriptions of users who are not yet enrolled in any course are hidden. New users must enrol in at least one course before they can add a profile description.';
$string['configprotectusernames'] = 'By default forget_password.php does not display any hints that would allow guessing of usernames or email addresses.';
$string['configproxybypass'] = 'Comma separated list of (partial) hostnames or IPs that should bypass proxy (e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'If this <b>server</b> needs to use a proxy computer (eg a firewall) to access the Internet, then provide the proxy hostname here.  Otherwise leave it blank.';
$string['configproxypassword'] = 'Password needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configproxyport'] = 'If this server needs to use a proxy computer, then provide the proxy port here.';
$string['configproxytype'] = 'Type of web proxy (PHP5 and cURL extension required for SOCKS5 support).';
$string['configproxyuser'] = 'Username needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configrecaptchaprivatekey'] = 'String of characters (private key) used to communicate between your Totara server and the recaptcha server. ReCAPTCHA keys can be obtained from <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'String of characters (public key) used to display the reCAPTCHA element in the signup form. ReCAPTCHA keys can be obtained from <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Allow the selection of a category when requesting a course.';
$string['configrequestedstudentname'] = 'Word for learner used in requested courses';
$string['configrequestedstudentsname'] = 'Word for learners used in requested courses';
$string['configrequestedteachername'] = 'Word for trainer used in requested courses';
$string['configrequestedteachersname'] = 'Word for trainers used in requested courses';
$string['configreverseproxyignore'] = 'If your server is behind multiple reverse proxies that append to the X-Forwarded-For header then you will need to specify a comma separated list of ip addresses or subnets of the reverse proxies to be ignored in order to find the users correct IP address.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Maintenance';
$string['configsectionmisc'] = 'Miscellaneous';
$string['configsectionoperatingsystem'] = 'Operating system';
$string['configsectionpermissions'] = 'Permissions';
$string['configsectionrequestedcourse'] = 'Course requests';
$string['configsectionsecurity'] = 'Security';
$string['configsectionstats'] = 'Statistics';
$string['configsectionuser'] = 'User';
$string['configsecureforms'] = 'Totara can use an additional level of security when accepting data from web forms. If this is enabled, then the browser\'s HTTP_REFERER variable is checked against the current form address.  In a very few cases this can cause problems if the user is using a firewall (eg Zonealarm) configured to strip HTTP_REFERER from their web traffic.  Symptoms are getting \'stuck\' on a form. If your users are having problems with the login page (for example) you might want to disable this setting, although it might leave your site more open to brute-force password attacks.  If in doubt, leave this set to \'Yes\'.';
$string['configsessioncookie'] = 'This setting customises the name of the cookie used for Totara sessions.  This is optional, and only useful to avoid cookies being confused when there is more than one copy of Totara running within the same web site.';
$string['configsessioncookiedomain'] = 'This allows you to change the domain that the Totara cookies are available from. This is useful for Totara customisations (e.g. authentication or enrolment plugins) that need to share Totara session information with a web application on another subdomain. <strong>WARNING: it is strongly recommended to leave this setting at the default (empty) - an incorrect value will prevent all logins to the site.</strong>';
$string['configsessioncookiepath'] = 'If you need to change where browsers send the Totara cookies, you can change this setting to specify a subdirectory of your web site.  Otherwise the default \'/\' should be fine.';
$string['configsessiontimeout'] = 'If people logged in to this site are idle for a long time (without loading pages) then they are automatically logged out (their session is ended).  This variable specifies how long this time should be.';
$string['configsharedservicesettings'] = 'Shared services settings';
$string['configshowcommentscount'] = 'Show comments count, it will cost one more query when display comments link';
$string['configshowicalsource'] = 'Show source information for iCal events';
$string['configshowsiteparticipantslist'] = 'All of these site learners and site trainers will be listed on the site participants list. Who shall be allowed to see this site participants list?';
$string['configsitedefaultlicense'] = 'Default site licence';
$string['configsitedefaultlicensehelp'] = 'The default licence for publishing content on this site';
$string['configsitemailcharset'] = 'This setting specifies the default charset for all emails sent from the site.';
$string['configsmartpix'] = 'With this on, icons are served through a PHP script that searches the current theme, then all parent themes, then the Totara /pix folder. This reduces the need to duplicate image files within themes, but has a slight performance cost.';
$string['configsmtpauthtype'] = 'This sets the authentication type to use on smtp server.';
$string['configsmtphosts'] = 'Give the full name of one or more local SMTP servers that Totara should use to send mail (eg \'mail.a.com\' or \'mail.a.com;mail.b.com\'). To specify a non-default port (i.e other than port 25), you can use the [server]:[port] syntax (eg \'mail.a.com:587\'). For secure connections, port 465 is usually used with SSL, port 587 is usually used with TLS, specify security protocol below if required. If you leave this field blank, Totara will use the PHP default method of sending mail.';
$string['configsmtpmaxbulk'] = 'Maximum number of messages sent per SMTP session. Grouping messages may speed up the sending of emails. Values lower than 2 force creation of new SMTP session for each email.';
$string['configsmtpsecure'] = 'If SMTP server requires secure connection, specify the correct protocol type.';
$string['configsmtpuser'] = 'If you have specified an SMTP server above, and the server requires authentication, then enter the username and password here.';
$string['configstartwday'] = 'Start of week';
$string['configstatsfirstrun'] = 'This specifies how far back the logs should be processed <b>the first time</b> the cronjob wants to process statistics. If you have a lot of traffic and are on shared hosting, it\'s probably not a good idea to go too far back, as it could take a long time to run and be quite resource intensive. (Note that for this setting, 1 month = 28 days. In the graphs and reports generated, 1 month = 1 calendar month.)';
$string['configstatsmaxruntime'] = 'Stats processing can be quite intensive, so use a combination of this field and the next one to specify when it will run and how long for.';
$string['configstatsmaxruntime2'] = 'Stats processing can be quite intensive, specify maximum time allowed for gathering of one day of statistics. Maximum number of days processed in one cron execution is 31.';
$string['configstatsmaxruntime3'] = 'This specifies the maximum time allowed to calculate the statistics for one day, bearing in mind that statistics processing can put a big load on the server. The maximum number of days processed in one cron can be specified below.';
$string['configstatsruntimedays'] = 'This specifies the maximum number of days processed in each statistics execution. Once the statistics are up-to-date, only one day will be processed, so adjust this value depending of your server load, reducing it if shorter cron executions are needed.';
$string['configstatsruntimestart'] = 'What time should the cronjob that does the statistics processing start? Specifying different times is recommended if there are multiple Totara sites on one server.';
$string['configstatsuserthreshold'] = 'This setting specifies the minimum number of enrolled users for a course to be included in statistics calculations.';
$string['configstrictformsrequired'] = 'If enabled, users are prevented from entering a space or line break only in required fields in forms.';
$string['configstripalltitletags'] = 'Uncheck this setting to allow HTML tags in activity and resource names.';
$string['configsupportemail'] = 'This email address will be published to users of this site as the one to email when they need general help (for example, when new users create their own accounts).  If this email is left blank then no such helpful email address is supplied.';
$string['configsupportname'] = 'This is the name of a person or other entity offering general help via the support email or web address.';
$string['configsupportpage'] = 'This web address will be published to users of this site as the one to go to when they need general help (for example, when new users create their own accounts).  If this address is left blank then no link will be supplied.';
$string['configtempdatafoldercleanup'] = 'Remove temporary data files from the data folder that are older than the selected time.';
$string['configthemedesignermode'] = 'Normally all theme images and style sheets are cached in browsers and on the server for a very long time, for performance. If you are designing themes or developing code then you probably want to turn this mode on so that you are not served cached versions.  Warning: this will make your site slower for all users!  Alternatively, you can also reset the theme caches manually from the Theme selection page.';
$string['configthemelist'] = 'Leave this blank to allow any valid theme to be used.  If you want to shorten the theme menu, you can specify a comma-separated list of names here (Don\'t use spaces!).
For example:  standard,orangewhite.';
$string['configtimezone'] = 'This is the default timezone for displaying dates - each user can override this setting in their profile. Cron tasks and other server settings are specified in this timezone. You should change the setting if it shows as "Invalid timezone"';
$string['configuseblogassociations'] = 'Should users be able to organize their blog by associating entries with courses and course modules?';
$string['configuseexternalyui'] = 'Instead of using local files, use online files available on Yahoo&#145;s servers. WARNING: This requires an internet connection, or no AJAX will work on your site. This setting is not compatible with sites using https.';
$string['configuserquota'] = 'The maximum number of bytes that a user can store in their own private file area. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'If enabled the site\'s shortname will be used for the site pages node in the navigation rather than the string \'Site pages\'';
$string['configusetags'] = 'Enable tags functionality accross the site.';
$string['configvariables'] = 'Variables';
$string['configverifychangedemail'] = 'Enables verification of changed email addresses using allowed and denied email domains settings. If this setting is disabled the domains are enforced only when creating new users.';
$string['configvisiblecourses'] = 'Display courses in hidden categories normally';
$string['configwarning'] = 'Be careful modifying these settings - strange values could cause problems.';
$string['configyuicomboloading'] = 'This options enables combined file loading optimisation for YUI libraries. This setting should be enabled on production sites for performance reasons.';
$string['confirmation'] = 'Confirmation';
$string['confirmdeletecomments'] = 'You are about to delete comments, are you sure?';
$string['confirmed'] = 'Confirmed';
$string['cookiehttponly'] = 'Only http cookies';
$string['cookiesecure'] = 'Secure cookies only';
$string['country'] = 'Default country';
$string['course_heading_visible'] = 'Show course heading';
$string['course_heading_visible_desc'] = 'Show top-level heading on course pages';
$string['coursecontact'] = 'Course contacts';
$string['coursecontact_desc'] = 'This setting allows you to control who appears on the course description. Users need to have at least one of these roles in a course to be shown on the course description for that course.';
$string['coursecount'] = 'Number of site courses';
$string['courselistshortnames'] = 'Display extended course names';
$string['courselistshortnames_desc'] = 'If enabled, course short names will be displayed in addition to full names in course lists. If required, extended course names may be customised by editing the \'courseextendednamedisplay\' language string using the language customisation feature.';
$string['coursemgmt'] = 'Courses and categories';
$string['courseoverview'] = 'Course overview';
$string['courserequestnotify'] = 'Course request notification';
$string['courserequestnotifyemail'] = 'User {$a->user} requested a new course at {$a->link}';
$string['courserequests'] = 'Course requests';
$string['courserequestspending'] = 'Pending course requests';
$string['courses'] = 'Courses';
$string['coursesettings'] = 'Course settings';
$string['coursesperpage'] = 'Courses per page';
$string['courseswithsummarieslimit'] = 'Courses with summaries limit';
$string['creatornewroleid'] = 'Creators\' role in new courses';
$string['creatornewroleid_help'] = 'If the user does not already have the permission to manage the new course, the user is automatically enrolled using this role.';
$string['cron'] = 'Cron';
$string['cron_help'] = 'The cron.php maintenance script assists some of Totara\'s modules to perform tasks on a scheduled basis, such as mailing out copies of new forum posts. A mechanism is required to run the script regularly e.g. every 5 minutes.';
$string['cron_link'] = 'Scheduled Tasks';
$string['cronclionly'] = 'Cron execution via command line only';
$string['cronerrorclionly'] = 'Sorry, internet access to this page has been disabled by the administrator.';
$string['cronerrorpassword'] = 'Sorry, you have not provided a valid password to access this page';
$string['croninfrequent'] = 'The time between the last two runs of the cron maintenance script was over {$a} seconds. We recommend configuring it to run more frequently.';
$string['cronremotepassword'] = 'Cron password for remote access';
$string['cronwarning'] = 'The <a href="{$a}">cron.php maintenance script</a> has not been run for at least 24 hours.';
$string['cronwarningcli'] = 'The cli/cron.php maintenance script has not been run for at least 24 hours.';
$string['ctyperequired'] = 'The ctype PHP extension is now required by Totara, in order to improve site performance and to offer multilingual compatibility.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlphpextensionnotinstalled'] = 'cURL PHP extension is not installed';
$string['curlrequired'] = 'The cURL PHP extension is now required by Totara, in order to communicate with Totara repositories.';
$string['curlsecurityallowedport'] = 'cURL allowed ports list';
$string['curlsecurityallowedportsyntax'] = 'List of port numbers that cURL can connect to. Valid entries are integer numbers only. Put each entry on a new line. If left empty, then all ports are allowed. If set, in almost all cases, both 443 and 80 should be specified for cURL to connect to standard HTTPS and HTTP ports.';
$string['curlsecurityblockedhosts'] = 'cURL blocked hosts list';
$string['curlsecurityblockedhostssyntax'] = 'Put each entry on a new line. Valid entries are either full IPv4 or IPv6 addresses (such as 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) which match a single host; or CIDR notation (such as 231.54.211.0/20 or fe80::/64); or a range of IP addresses (such as 231.3.56.10-20 or fe80::1111-bbbb) where the range applies to the last group of the address; or domain names (such as localhost or example.com); or wildcard domain names (such as *.example.com or *.sub.example.com). Blank lines are not allowed.';
$string['curlsecurityurlblocked'] = 'The URL is blocked.';
$string['curltimeoutkbitrate'] = 'Bitrate to use when calculating cURL timeouts (Kbps)';
$string['curltimeoutkbitrate_help'] = 'This setting is used to calculate an appropriate timeout during large cURL requests. As part of this calculation an HTTP HEAD request is made to determine the size of the content. Setting this to 0 disables this request from being made.';
$string['currenttheme'] = 'Current theme';
$string['customcheck'] = 'Other checks';
$string['customusermenuitems'] = 'User menu items';
$string['datarootsecurityerror'] = '<p><strong>SECURITY WARNING!</strong></p><p>Your dataroot directory is in the wrong location and is exposed to the web. This means that all your private files are available to anyone in the world, and some of them could be used by a cracker to obtain unauthorised administrative access to your site!</p>
<p>You <em>must</em> move dataroot directory ({$a}) to a new location that is not within your public web directory, and update the <code>$CFG->dataroot</code> setting in your config.php accordingly.</p>';
$string['datarootsecuritywarning'] = 'Your site configuration might not be secure. Please make sure that your dataroot directory ({$a}) is not directly accessible via web.';
$string['dbsessions'] = 'Use database for session information';
$string['dbtype'] = 'Database type';
$string['debug'] = 'Debug messages';
$string['debugall'] = 'ALL: Show all reasonable PHP debug messages';
$string['debugdeveloper'] = 'DEVELOPER: extra debug messages for developers';
$string['debugdisplay'] = 'Display debug messages';
$string['debugflexicons'] = 'Log missing flexible icons';
$string['debugflexicons_help'] = 'When flex icons are enabled log missing pix_icon to flex_icon translations.';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMAL: Show only fatal errors';
$string['debugnone'] = 'NONE: Do not show any errors or warnings';
$string['debugnormal'] = 'NORMAL: Show errors, warnings and notices';
$string['debugpageinfo'] = 'Show page information';
$string['debugsmtp'] = 'Debug email sending';
$string['debugstringids'] = 'Show origin of languages strings';
$string['debugstringids_desc'] = 'If enabled, language string components and identifiers are displayed when ?strings=1 or &strings=1 is appended to the page URL.';
$string['debugvalidators'] = 'Show validator links';
$string['defaultcity'] = 'Default city';
$string['defaultcity_help'] = 'A city entered here will be the default city when creating new user accounts.';
$string['defaultformatnotset'] = 'Error determining default course format. Please check site settings.';
$string['defaulthomepage'] = 'Default home page for users';
$string['defaultrequestcategory'] = 'Default category for course requests';
$string['defaultsettinginfo'] = 'Default: {$a}';
$string['defaultuserroleid'] = 'Default role for all users';
$string['deleteincompleteusers'] = 'Delete incomplete users after';
$string['deleteunconfirmed'] = 'Delete not fully setup users after';
$string['deleteuser'] = 'Delete user';
$string['density'] = 'Density';
$string['denyemailaddresses'] = 'Denied email domains';
$string['development'] = 'Development';
$string['devicedetectregex'] = 'Device detection regular expressions';
$string['devicedetectregex_desc'] = '<p>By default, Totara can detect devices of the type default (desktop PCs, laptops, etc), mobile (phones and small hand held devices), tablet (iPads, Android tablets) and legacy (Internet Explorer 6 users).  The theme selector can be used to apply separate themes to all of these.  This setting allows regular expressions that allow the detection of extra device types (these take precedence over the default types).</p>
<p>For example, you could enter the regular expression \'/(MIDP-1.0|Maemo|Windows CE)/\' to detect some commonly used feature phones add the return value \'featurephone\'.  This adds \'featurephone\' on the theme selector that would allow you to add a theme that would be used on these devices.  Other phones would still use the theme selected for the mobile device type.</p>';
$string['devicedetectregexexpression'] = 'Regular expression';
$string['devicedetectregexvalue'] = 'Return value';
$string['devicetype'] = 'Device type';
$string['devlibdirpresent'] = 'Directories with development libraries such as <em>vendor</em> or <em>node_modules</em> should not be present on public sites. See the <a href="{$a->moreinfourl}">security overview report</a> for more details.';
$string['disableconsistentcleaning'] = 'Disable consistent cleaning';
$string['disableconsistentcleaning_help'] = 'Prior to Totara 13 some areas of the product, such as course summaries and activity introductions, were not properly sanitised before being displayed to the user.
Turning this setting on will return Totara to this behaviour, allowing privileged users to use advanced HTML in areas such as the above, re-introducing security risks at the same time.
We strongly recommend it is left off, and only turned on if you have upgrade
d and have content that relies upon this functionality, and are happy to accept the security risks.';
$string['disableuserimages'] = 'Disable user profile images';
$string['displayerrorsset'] = 'This site is configured to display errors occurrences. <br />This setting is not recommended on production sites. <br />Uncheck <em>Display debug messages</em> in the <a href="{$a->link}">Server/Debugging</a> section of the site admin settings block.';
$string['displayerrorswarning'] = 'Enabling the PHP setting <em>display_errors</em> is not recommended on production sites. <br />This setting can be changed in your php settings.';
$string['displayloginfailures'] = 'Display login failures';
$string['dndallowtextandlinks'] = 'Drag and drop upload of text/links';
$string['doclang'] = 'Language for docs';
$string['docroot'] = 'Docs document root';
$string['doctonewwindow'] = 'Open in new window';
$string['doesnotfit'] = 'Email display settings';
$string['doesnotfitdetail'] = 'Display settings for email leaving Totara.';
$string['domdocumentnotfound'] = 'DOMDocument class not found. Cannot perform security check regarding XML loading external entities by default.';
$string['download'] = 'Download';
$string['durationunits'] = 'duration units';
$string['edithelpdocs'] = 'Edit help documents';
$string['editlang'] = '<b>Edit</b>';
$string['editorbackgroundcolor'] = 'Background colour';
$string['editordictionary'] = 'Editor dictionary';
$string['editorfontfamily'] = 'Font family';
$string['editorfontlist'] = 'Font list';
$string['editorfontsize'] = 'Font size';
$string['editorhidebuttons'] = 'Hidden buttons';
$string['editorkillword'] = 'Word format filter';
$string['editorspelling'] = 'Editor spelling';
$string['editorspellinghelp'] = 'Enable or disable spell-checking. When enabled, <strong>aspell</strong> must be installed on the server.';
$string['editstrings'] = 'Edit words or phrases';
$string['emailchangeconfirmation'] = 'Email change confirmation';
$string['emailfromvia'] = 'Email via information';
$string['emoticonalt'] = 'Alternative text';
$string['emoticonaltcomponent'] = 'Alt component';
$string['emoticoncomponent'] = 'Image component';
$string['emoticonimagename'] = 'Image name';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'This form defines the emoticons (or smileys) used at your site. To remove a row from the table, save the form with an empty value in any of the required fields. To register a new emoticon, fill the fields in the last blank row. To reset all the fields into default values, follow the link above.

* Text (required) - This text will be replaced with the emoticon image. It must be at least two characters long.
* Image name (required) - The emoticon image file name without the extension, relative to the component pix folder.
* Image component (required) - The component providing the icon.
* Alternative text (optional) - String identifier and component of the alternative text of the emoticon.';
$string['emoticonsreset'] = 'Reset emoticons setting to default values';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Empty';
$string['enableactivitychooser'] = 'Enable activity chooser';
$string['enableblogs'] = 'Enable legacy blogs';
$string['enablecalendarexport'] = 'Enable calendar export';
$string['enablecomments'] = 'Enable comments';
$string['enablecomments_description'] = 'Enable comments on course activities and learning plans. Note that you can\'t disable comments on resources and playlists.';
$string['enablecourserequests'] = 'Enable course requests';
$string['enabled'] = 'Enabled';
$string['enabledevicedetection'] = 'Enable device detection';
$string['enableglobalsearch'] = 'Enable global search';
$string['enableglobalsearch_desc'] = 'If enabled, data will be indexed and syncronised by a scheduled task.';
$string['enablegravatar'] = 'Enable Gravatar';
$string['enablegravatar_help'] = 'When enabled Totara will attempt to fetch a user profile picture from Gravatar if the user has not uploaded an image.';
$string['enablerecordcache'] = 'Enable record cache';
$string['enablerssfeeds'] = 'Enable RSS feeds';
$string['enablesafebrowserintegration'] = 'Enable Safe Exam Browser integration';
$string['enablesearchareas'] = 'Enable search areas';
$string['enablestats'] = 'Enable statistics';
$string['enablewebservices'] = 'Enable legacy web services';
$string['enablewsdocumentation'] = 'Web services documentation';
$string['enrolinstancedefaults'] = 'Enrolment instance defaults';
$string['enrolinstancedefaults_desc'] = 'Default enrolment settings in new courses.';
$string['enrolmultipleusers'] = 'Enrol the users';
$string['environment'] = 'Environment';
$string['environmenterrortodo'] = 'You must solve all the environmental problems (errors) found above before proceeding to install this Totara version!';
$string['environmenterrorupgrade'] = 'Warning: you should solve all the environmental problems (errors) found above before proceeding to upgrade this Totara version!  Upgrading without fixing these requirements could cause problems such as data loss.  Are you sure you want to continue with the upgrade?';
$string['environmentmustfixsetting'] = 'PHP setting must be changed.';
$string['environmentok'] = 'Your server environment meets all minimum requirements.';
$string['environmentrecommendcustomcheck'] = 'if this test fails, it indicates a potential problem';
$string['environmentrecommendinstall'] = 'should be installed and enabled for best results';
$string['environmentrecommendversion'] = 'version {$a->needed} is recommended and you are running {$a->current}';
$string['environmentrequirecustomcheck'] = 'this test must pass';
$string['environmentrequireinstall'] = 'must be installed and enabled';
$string['environmentrequireversion'] = 'version {$a->needed} is required and you are running {$a->current}';
$string['environmentsettingok'] = 'recommended setting detected';
$string['environmentshouldfixsetting'] = 'PHP setting should be changed.';
$string['environmentxmlerror'] = 'Error reading environment data ({$a->error_code})';
$string['error:cannot_enable_prohibited_activity_module'] = 'Cannot enable the activity module \'{$a->mod}\'. {$a->reason}';
$string['error:cannot_enable_prohibited_course_format_plugin'] = 'Cannot enable the course format plugin \'{$a->format}\'. {$a->reason}';
$string['errordeletingconfig'] = 'An error occurred while deleting the configuration records for plugin \'{$a}\'.';
$string['errordurationminonehour'] = 'Duration has to be at least one hour.';
$string['errornonnumeric'] = 'The value has to be a number.';
$string['errorsetting'] = 'Could not save setting:';
$string['errorwithsettings'] = 'Some settings were not changed due to an error.';
$string['eventadminclideletescriptexec'] = 'Admin CLI script execution, records deleted';
$string['eventadminsettingchanged'] = 'Admin settings changed';
$string['eventshandlersinuse'] = 'The following plugins in your system are using Events 1 API deprecated handlers: \'{$a}\'. Please, update them to use Events 2 API. See https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Everyone who can \'{$a}\'';
$string['exceptions'] = 'exceptions';
$string['execpathnotallowed'] = 'Setting executable and local paths disabled in config.php';
$string['exifrecommended'] = 'Installing the optional EXIF extension is recommended. It will enable Totara to automatically adjust images taken by digital devices.';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Experimental settings';
$string['extendedusernamechars'] = 'Allow extended characters in usernames';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalsessionautostart'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Totara requires that administrator changes PHP settings.</p><p><code>session.auto_start</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['filecreated'] = 'New file created';
$string['filestoredin'] = 'Save file into folder :';
$string['filestoredinhelp'] = 'Where the file will be stored';
$string['filterall'] = 'Filter all strings';
$string['filtermatchoneperpage'] = 'Filter match once per page';
$string['filtermatchonepertext'] = 'Filter match once per text';
$string['filters'] = 'Filters';
$string['filtersettings'] = 'Manage filters';
$string['filtersettingsgeneral'] = 'General filter settings';
$string['filteruploadedfiles'] = 'Filter uploaded files';
$string['flavour'] = 'Flavour';
$string['forcelogin'] = 'Force users to log in';
$string['forceloginforprofileimage'] = 'Force users to log in to view user pictures';
$string['forceloginforprofileimage_help'] = 'If enabled, users must log in in order to view user profile pictures and the default user picture will be used in all notification emails.';
$string['forceloginforprofiles'] = 'Force users to log in for profiles';
$string['forcetimezone'] = 'Force timezone';
$string['formatuninstallwithcourses'] = 'There are {$a->count} courses using {$a->format}. Their format will be changed to {$a->defaultformat} (default format for this site). Some format-specific data may be lost. Are you sure you want to proceed?';
$string['frontpage'] = 'Front page';
$string['frontpageaddcoursebutton'] = 'Display an add course button';
$string['frontpageaddcoursebutton_help'] = 'If the user has permission to add courses then when editing is turned on and the user is on the front page an "Add course" button will be displayed on the page.';
$string['frontpagebackup'] = 'Front page backup';
$string['frontpagedefaultrole'] = 'Default frontpage role';
$string['frontpagefilters'] = 'Front page filters';
$string['frontpageoverrides'] = 'Front page permission overrides';
$string['frontpagequestions'] = 'Front page questions';
$string['frontpagerestore'] = 'Front page restore';
$string['frontpageroles'] = 'Front page roles';
$string['frontpagesettings'] = 'Front page settings';
$string['fullnamedisplay'] = 'Full name format';
$string['fullnamedisplayprivate'] = 'Full name format - private';
$string['fulltestsearchsupportwarning'] = 'Full text search support ({$a})';
$string['gdrequired'] = 'The GD extension is now required by Totara for image conversion.';
$string['generalsettings'] = 'General settings';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Logged IP address source';
$string['globalsearch'] = 'Global search';
$string['globalsearchmanage'] = 'Manage global search';
$string['gmapsdefaultzoomlevel'] = 'Default zoom level';
$string['gmapsdefaultzoomlevel_help'] = 'Sets the initial zoom level of the map. Accepted values range from 0 (the whole world) to 21 (individual buildings). The upper limit can vary depending on the map data available at the selected location.';
$string['gmapsforcemaplanguage'] = 'Force map language';
$string['gmapsforcemaplanguage_help'] = 'If empty, map text will be displayed using the user\'s browser\'s language. Set this setting to force all users to see map text in the specified language. Visit <a href="https://developers.google.com/maps/faq#languagesupport" target="_blank">this page</a> for a list of supported languages.';
$string['gmapsregionbias'] = 'Region bias';
$string['gmapsregionbias_help'] = 'Google Maps address returns results influenced by your region/country. For example, searches for \'San Francisco\' may return different results if sent from a domain within the United States than one sent from Spain. This should be the <a href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements" target="_blank">ISO 3166-1</a> code for the appropriate region/country.';
$string['googlemapkey3'] = 'Google Maps JavaScript API key';
$string['googlemapkey3_help'] = 'If you use Google Map features within Totara we strongly recommend that you read and agree to the Google Maps JavaScript API Terms of Service and generate a Google Maps JavaScript API key for use within your site.

Information on obtaining a key can be found at <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">https://developers.google.com/maps/documentation/javascript/get-api-key</a>

Please refer to the <a href="https://developers.google.com/maps/terms" target="_blank">Google Maps JavaScript API Terms of Service</a> for permitted use.
For help understanding the Terms of Service refer to the <a href="https://developers.google.com/maps/faq#understanding-terms-of-service" target="_blank">Terms of Service FAQ\'s</a>

If you have purchased a Premium Plan then please put your Client ID into the API key setting, Totara will recognise this as Client ID and treat it as such.

Totara currently uses the Google Maps JavaScript API in the following locations:

* Location custom fields.
* IP Address lookup visualisation within the site log reports.';
$string['googlemaps'] = 'Google Maps';
$string['gotofirst'] = 'Go to first missing string';
$string['gradebook'] = 'Gradebook';
$string['gradebookroles'] = 'Graded roles';
$string['gradeexport'] = 'Primary grade export methods';
$string['gravatardefaulturl'] = 'Gravatar default image URL';
$string['gravatardefaulturl_help'] = 'Gravatar needs a default image to display if it is unable to find a picture for a given user. Provide a full URL for an image. If you leave this setting empty, Totara will attempt to use the most appropriate default image for the page you are viewing. Note also that Gravatar has a number of codes which can be used to <a href="https://en.gravatar.com/site/implement/images/#default-image">generate default images</a>.';
$string['groupenrolmentkeypolicy'] = 'Group enrolment key policy';
$string['groupenrolmentkeypolicy_desc'] = 'Turning this on will make Totara check group enrolment keys against a valid password policy.';
$string['guesthomepage'] = 'Home page for guests';
$string['guestroleid'] = 'Role for guest';
$string['guestroleid_help'] = 'This role is automatically assigned to the guest user. It is also temporarily assigned to not enrolled users that enter the course via guest enrolment plugin.';
$string['helpadminseesall'] = 'Do admins see all calendar events or just those that apply to themselves?';
$string['helpcalendarcustomexport'] = 'Enable custom date range export option in calendar exports. Calendar exports must be enabled before this is effective.';
$string['helpcalendarsettings'] = 'Configure various calendar and date/time-related aspects of Totara';
$string['helpexportlookahead'] = 'How many days in the future does the calendar look for events during export for the custom export option?';
$string['helpexportlookback'] = 'How many days in the past does the calendar look for events during export for the custom export option?';
$string['helpforcetimezone'] = 'You can allow users to individually select their timezone, or force a timezone for everyone.';
$string['helpshowicalsource'] = 'If enabled, the subscription name and link will be shown for iCal-imported events.';
$string['helpsitemaintenance'] = 'For upgrades and other work';
$string['helpstartofweek'] = 'Which day starts the week in the calendar?';
$string['helpupcominglookahead'] = 'How many days in the future does the calendar look for upcoming events by default?';
$string['helpupcomingmaxevents'] = 'How many (maximum) upcoming events are shown to users by default?';
$string['helpweekenddays'] = 'Which days of the week are treated as "weekend" and shown with a different colour?';
$string['hiddenuserfields'] = 'Hide user fields';
$string['hidedetails'] = 'Hide details';
$string['hidefromall'] = 'Hide from all users';
$string['hidefromnone'] = 'Hide from nobody';
$string['hidefromstudents'] = 'Hide from learners';
$string['htmleditor'] = 'HTML editor';
$string['htmleditorsettings'] = 'HTML editor settings';
$string['htmlsettings'] = 'HTML settings';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP security';
$string['iconvrequired'] = 'Installing ICONV extension is required.';
$string['icuminimumversionwarning'] = 'International Components for Unicode (ICU) - 57.1 or later is recommended';
$string['ignore'] = 'Ignore';
$string['includemoduleuserdata'] = 'Include module user data';
$string['incompatibleblocks'] = 'Incompatible blocks';
$string['incompleteunicodesupport'] = 'The current setup of MySQL or MariaDB is using \'utf8\'. This character set does not support four byte characters which include some emoji. Trying to use these characters will result in an error when updating a record, and any information being sent to the database will be lost. Please consider changing your settings to \'utf8mb4\'. See the documentation for full details.';
$string['indexdata'] = 'Index data';
$string['indexinginfo'] = 'The recommended way to index your site\'s contents is by using the \'Global search indexing\' scheduled task.';
$string['installedlangs'] = 'Installed language packs';
$string['installhijacked'] = 'Installation must be finished from the original IP address, sorry.';
$string['installsessionerror'] = 'Can not initialise PHP session, please verify that your browser accepts cookies.';
$string['intlrecommended'] = 'Intl extension is used to improve internationalization support, such as locale aware sorting.';
$string['invalidsection'] = 'Invalid section.';
$string['invalidssltlsconfiguration'] = 'Invalid SSL/TLS configuration';
$string['invaliduserchangeme'] = 'Username "changeme" is reserved -- you cannot create an account with it.';
$string['ipblocked'] = 'This site is not available currently.';
$string['ipblocker'] = 'IP blocker';
$string['ipblockersyntax'] = 'Put every entry on one line. Valid entries are either full IP address (such as <b>192.168.10.1</b>) which matches a single host; or partial address (such as <b>192.168</b>) which matches any address starting with those numbers; or CIDR notation (such as <b>231.54.211.0/20</b>); or a range of IP addresses (such as <b>231.3.56.10-20</b>) where the range applies to the last part of the address. Text domain names (like \'example.com\') are not supported. Blank lines are ignored.';
$string['iplookup'] = 'IP address lookup';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">geoPlugin</a> service is currently being used to look up geographical information. For more accurate results we recommend installing a local copy of the MaxMind GeoLite database.';
$string['iplookupinfo'] = 'By default Totara uses the free online NetGeo (The Internet Geographic Database) server to lookup location of IP addresses, unfortunately this database is not maintained anymore and may return <em>wildly incorrect</em> data.
It is recommended to install local copy of free GeoLite2 City database from MaxMind.<br />
IP address location is displayed on simple map or using Google Maps. Please note that you need to have a Google account and apply for free Google Maps API key to enable interactive maps.';
$string['iplookupmaxmindnote'] = 'This product includes GeoLite2 data created by MaxMind, available from <a href="http://www.maxmind.com">http://www.maxmind.com</a>.';
$string['iplookupnolocal'] = 'IP address lookup is only available if you have configured the local version of the GeoLite2 database, available from <a href="http://www.maxmind.com">http://www.maxmind.com</a>.';
$string['ishttpswarning'] = 'It has been detected that your site is not secured using HTTPS. For increased security and improved integration with other systems, it is highly recommended that you migrate your site to HTTPS.';
$string['issuedbadgesnumber'] = 'Number of issued badges';
$string['keeptagnamecase'] = 'Keep tag name casing';
$string['lang'] = 'Default language';
$string['langcache'] = 'Cache language menu';
$string['langcache_desc'] = 'Cache the language menu. If enabled, the list of available translations is cached. The cache is automatically refreshed when you install or delete a language pack via the in-built language packs management tool. If you install a new language pack manually, you have to use Purge all caches feature to refresh the cached list.';
$string['langlist'] = 'Languages on language menu';
$string['langmenu'] = 'Display language menu';
$string['langpackwillbeupdated'] = 'NOTE: Totara will try to download updates for your language packs during the upgrade.';
$string['langstringcache'] = 'Cache all language strings';
$string['language'] = 'Language';
$string['language_help'] = 'Set the language of the new user. Selecting this when creating a user ensures the login page or an email greets the user in the given language.';
$string['languagesettings'] = 'Language settings';
$string['lastcron'] = 'Last cron timestamp';
$string['latinexcelexport'] = 'Excel encoding';
$string['learnerroleid'] = 'Role for learner';
$string['learnerroleid_help'] = 'The role is used for learners.';
$string['legacyfilesaddallowed'] = 'Allow adding to legacy course files';
$string['legacyfilesaddallowed_help'] = 'If a course has legacy course files, allow new files and folders to be added to it.';
$string['legacyfilesinnewcourses'] = 'Legacy course files in new courses';
$string['legacyfilesinnewcourses_help'] = 'By default, legacy course files areas are available in upgraded courses only. Please note that some features such as activity backup and restore are not compatible with this setting.';
$string['libcurlwarning'] = 'It has been detected that libcurl doesn\'t have CURLOPT_PROTOCOL support. An up-to-date libcurl installation is recommended for security reasons.';
$string['licensesettings'] = 'Licence settings';
$string['linkadmincategories'] = 'Link admin categories';
$string['linkadmincategories_help'] = 'If enabled admin setting categories will be displayed as links in the navigation and will lead to the admin category pages.';
$string['linkcoursesections'] = 'Always link course sections';
$string['linkcoursesections_help'] = 'Always try to provide a link for course sections. Course sections are usually only shown as links if the course format displays a single section per page. If this setting is enabled a link will always be provided.';
$string['links'] = 'Links';
$string['loading'] = 'Loading';
$string['localetext'] = 'Sitewide locale';
$string['localisation'] = 'Localisation';
$string['localstringcustomization'] = 'Local string customization';
$string['location'] = 'Location';
$string['locationsettings'] = 'Location settings';
$string['locked'] = 'Locked';
$string['lockoutduration'] = 'Account lockout duration';
$string['lockoutduration_desc'] = 'Locked out account is automatically unlocked after this duration.';
$string['lockoutemailbody'] = 'Your account with username {$a->username} on server \'{$a->sitename}\'
was locked out after multiple invalid login attempts.

To unlock the account immediately go to the following address

{$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then copy and paste the address into the address
line at the top of your web browser window.

If you need help, please contact the site administrator,
{$a->admin}';
$string['lockoutemailsubject'] = 'Your account on {$a} was locked out';
$string['lockouterrorunlock'] = 'Invalid account unlock information supplied.';
$string['lockoutthreshold'] = 'Account lockout threshold';
$string['lockoutthreshold_desc'] = 'Select number of failed login attempts that result in account lockout. This feature may be abused in denial of service attacks.';
$string['lockoutwindow'] = 'Account lockout observation window';
$string['lockoutwindow_desc'] = 'Observation time for lockout threshold, if there are no failed attempts the threshold counter is reset after this time.';
$string['log'] = 'Logs';
$string['logguests'] = 'Log guest access';
$string['logguests_help'] = 'This setting enables logging of actions by guest account and not logged in users. High profile sites may want to disable this logging for performance reasons. It is recommended to keep this setting enabled on production sites.';
$string['loginfailures'] = 'Login failure settings';
$string['loginpageautofocus'] = 'Autofocus login page form';
$string['loginpageautofocus_help'] = 'Enabling this option improves usability of the login page, but automatically focusing fields may be considered an accessibility issue.';
$string['loglifetime'] = 'Keep logs for';
$string['logstorenotrequired'] = 'Log store not required';
$string['logstoressupported'] = 'Log stores that support this report';
$string['longtimewarning'] = '<b>Please note that this process can take a long time.</b>';
$string['mailnewline'] = 'Newline characters in mail';
$string['maintenancemode'] = 'In maintenance mode';
$string['maintenancemodeisscheduled'] = 'This site will be switched to maintenance mode in {$a->min} mins {$a->sec} secs';
$string['maintenancemodeisscheduledlong'] = 'This site will be switched to maintenance mode in {$a->hour} hours {$a->min} mins {$a->sec} secs';
$string['maintfileopenerror'] = 'Error opening maintenance files!';
$string['maintinprogress'] = 'Maintenance is in progress...';
$string['manageappearance'] = 'Manage appearance';
$string['managebi'] = 'Manage business intelligence';
$string['managecourses'] = 'Manage courses';
$string['manageformats'] = 'Manage course formats';
$string['manageformatsgotosettings'] = 'Default format can be changed in {$a}';
$string['managelang'] = 'Manage';
$string['managelicenses'] = 'Manage licences';
$string['manageprograms'] = 'Manage programs';
$string['manageqbehaviours'] = 'Manage question behaviours';
$string['manageqtypes'] = 'Manage question types';
$string['managerroleid'] = 'Role for manager';
$string['managerroleid_help'] = 'The role is used for staff managers.';
$string['manageusers'] = 'Manage users';
$string['maturity10'] = 'Dev';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Stable version';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Hint: You may want to run this script with --allow-unstable option';
$string['maturitycoreinfo'] = 'Your site is currently running unstable "{$a}" development code.';
$string['maturitycorewarning'] = 'The version of Totara that you are about to install or upgrade to contains
unstable "{$a}" development code that is not suitable for use on most production
sites. If this is not what you wanted then you should make sure you are updating
from a STABLE branch of the Totara code. See Totara Docs for more details.';
$string['maxbytes'] = 'Maximum uploaded file size';
$string['maxbytesextracted'] = 'Maximum size for extracted archive content';
$string['maxconsecutiveidentchars'] = 'Consecutive identical characters';
$string['maxeditingtime'] = 'Maximum time to edit posts';
$string['maxtimelimit'] = 'Maximum time limit';
$string['maxtimelimit_desc'] = 'To restrict the maximum PHP execution time that Totara will allow without any output being displayed, enter a value in seconds here. 0 means that Totara default restrictions are used. If you have a front-end server with its own time limit, set this value lower to receive PHP errors in logs. Does not apply to CLI scripts.';
$string['maxusersperpage'] = ' Maximum users per page';
$string['mbstringoverloadunsupported'] = 'Multibyte function overloading is not compatible with Totara, set "mbstring.func_overload = 0" in php.ini file.';
$string['mbstringrecommended'] = 'Installing the optional MBSTRING library is highly recommended in order to improve site performance, particularly if your site is supporting non-Latin languages.';
$string['mediapluginavi'] = 'Enable .avi filter';
$string['mediapluginflv'] = 'Enable .flv filter';
$string['mediapluginimg'] = 'Enable auto-embedding of linked images';
$string['mediapluginmov'] = 'Enable .mov filter';
$string['mediapluginmp3'] = 'Enable .mp3 filter';
$string['mediapluginmpg'] = 'Enable .mpg filter';
$string['mediapluginogg'] = 'Enable .ogg filter';
$string['mediapluginogv'] = 'Enable .ogv filter';
$string['mediapluginram'] = 'Enable .ram filter';
$string['mediapluginrm'] = 'Enable .rm filter';
$string['mediapluginrpm'] = 'Enable .rpm filter';
$string['mediapluginwmv'] = 'Enable .wmv filter';
$string['mediapluginyoutube'] = 'Enable YouTube links filter';
$string['messaging'] = 'Enable messaging system';
$string['messagingallowemailoverride'] = 'Notification email override';
$string['messagingdeletereadnotificationsdelay'] = 'Delete read notifications';
$string['messaginghidereadnotifications'] = 'Hide read notifications';
$string['minpassworddigits'] = 'Digits';
$string['minpasswordlength'] = 'Password length';
$string['minpasswordlower'] = 'Lowercase letters';
$string['minpasswordnonalphanum'] = 'Non-alphanumeric characters';
$string['minpasswordupper'] = 'Uppercase letters';
$string['misc'] = 'Miscellaneous';
$string['modchooserdefault'] = 'Activity chooser default';
$string['modeditdefaults'] = 'Default values for activity settings';
$string['modsettings'] = 'Manage activities';
$string['modulesecurity'] = 'Module security';
$string['moodlerelease'] = 'Moodle release identifier';
$string['mssqlinsufficientpermissions'] = 'MSSQL DB user required additional permissions: {$a}';
$string['multilangforceold'] = 'Force old multilang syntax: &lt;span&gt; without the class="multilang" and &lt;lang&gt;';
$string['mustenablestats'] = 'Statistics have not yet been enabled on this site.';
$string['mycoursesperpage'] = 'Number of courses';
$string['mydashboard'] = 'System default dashboard';
$string['mymoodle'] = 'My Learning';
$string['mymoodleredirect'] = 'Force users to use My Learning';
$string['mypage'] = 'Default My Learning page';
$string['mypagelocked'] = 'Lock default page';
$string['myprofile'] = 'Default profile page';
$string['navadduserpostslinks'] = 'Add links to view user posts';
$string['navadduserpostslinks_help'] = 'If enabled two links will be added to each user in the navigation to view discussions the user has started and posts the user has made in forums throughout the site or in specific courses.';
$string['navcourselimit'] = 'Course limit';
$string['navigationupgrade'] = 'This upgrade introduces two new navigation blocks that will replace these blocks: Administration, Courses, Activities and Participants.  If you had set any special permissions on those blocks you should check to make sure everything is behaving as you want it.';
$string['navshowallcourses'] = 'Show all courses';
$string['navshowcategories'] = 'Show course categories';
$string['navshowfrontpagemods'] = 'Show front page activities in the navigation';
$string['navshowfrontpagemods_help'] = 'If enabled, front page activities will be shown on the navigation under site pages.';
$string['navshowfullcoursenames'] = 'Show course full names';
$string['navshowfullcoursenames_help'] = 'If enabled, course full names will be used in the navigation rather than short names.';
$string['navshowmycoursecategories'] = 'Show my course categories';
$string['navshowmycoursecategories_help'] = 'If enabled courses in the users my courses branch will be shown in categories.';
$string['navsortmycoursessort'] = 'Sort my courses';
$string['navsortmycoursessort_help'] = 'This determines whether courses are listed under My courses according to the sort order (i.e. the order set in *Site administration > Courses > Courses and categories*) or alphabetically by course setting.';
$string['never'] = 'Never';
$string['neverdeleteruns'] = 'Never delete runs';
$string['newestdocindexed'] = 'Newest document indexed';
$string['newexperimental'] = 'New and experimental';
$string['nobookmarksforuser'] = 'You do not have any bookmarks.';
$string['nodatabase'] = 'No database';
$string['nohttpsformobilewarning'] = 'It is recommended to enable HTTPS with a valid certificate. The Totara app will always try to use a secured connection first.';
$string['nomissingstrings'] = 'No missing strings';
$string['none'] = 'None';
$string['nonewsettings'] = 'No new settings were added during this upgrade.';
$string['nonexistentbookmark'] = 'The bookmark you requested does not exist.';
$string['noreplyaddress'] = 'No-reply address';
$string['noreplydomain'] = 'No-reply and domain';
$string['noreplydomaindetail'] = 'Settings for No-reply and configured domains';
$string['noresults'] = 'No results found.';
$string['noroles'] = 'No roles';
$string['nosupportedlogstore'] = 'No supported logstore found';
$string['notifications'] = 'Notifications';
$string['notifyloginfailures'] = 'Email login failures to';
$string['notifyloginthreshold'] = 'Threshold for email notifications';
$string['notloggedinroleid'] = 'Role for visitors';
$string['numberofmissingstrings'] = 'Number of missing strings: {$a}';
$string['numberofstrings'] = 'Total number of strings: {$a->strings}<br />Missing: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['numberoftenants'] = 'Number of tenants';
$string['oauth2issuer'] = 'OAuth2 Service';
$string['oauth2issuer_connectionerror'] = 'The configured OAuth2 service could not connect to the service. Check service configuration and connected system account details.';
$string['oauth2issuer_desc'] = 'OAuth2 service to use for {$a}, using XOAUTH2 authentication. If the service does not exist yet, you will need to create it.';
$string['oauth2issuer_disabled'] = 'The configured OAuth2 Service is disabled. Mail processing cannot proceed.';
$string['oauth2services'] = 'OAuth 2';
$string['oauthrefreshtokenexpired'] = 'The refresh token for one of the OAuth services {$a->issuer} on your site {$a->siteurl} has expired. This will limit the functionality of any plugins that use this service. To fix this issue, visit the OAuth 2 Services configuration page and click on the "Connect system account" icon in the table row for this service. Be sure to login using the same service account for the OAuth system each time.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth refresh token expired for {$a->issuer} on your site {$a->siteurl}.';
$string['opcacherecommended'] = 'PHP opcode caching improves performance and lowers memory requirements, OPcache extension is recommended and fully supported.';
$string['opensslrecommended'] = 'Installing the optional OpenSSL library is highly recommended -- it enables Totara Networking functionality.';
$string['opensslrequired'] = 'The OpenSSL PHP extension is now required by Totara';
$string['opentogoogle'] = 'Open to Google';
$string['optionalmaintenancemessage'] = 'Optional maintenance message';
$string['order1'] = 'First';
$string['order2'] = 'Second';
$string['order3'] = 'Third';
$string['order4'] = 'Fourth';
$string['orgname'] = 'Organisation name';
$string['orgnamehelp'] = 'The name of your organisation.';
$string['outgoingmailconfig'] = 'Outgoing mail configuration';
$string['pageinfodebugsummary'] = 'This page is: {$a}';
$string['passwordchangelogout'] = 'Log out after password change';
$string['passwordchangelogout_desc'] = 'If enabled, when a password is changed, all browser sessions are terminated, apart from the one in which the new password is specified. (This setting does not affect password changes via bulk user upload.)';
$string['passwordchangetokendeletion'] = 'Remove web service access tokens after password change';
$string['passwordchangetokendeletion_desc'] = 'If enabled, when a password is changed, all the user web service access tokens are deleted.';
$string['passwordpolicy'] = 'Password policy';
$string['passwordresettime'] = 'Maximum time to validate password reset request';
$string['passwordreuselimit'] = 'Password rotation limit';
$string['passwordreuselimit_desc'] = 'Number of times a user must change their password before they are allowed to reuse a password. Hashes of previously used passwords are stored in local database table. This feature might not be compatible with some external authentication plugins.';
$string['pathtodot'] = 'Path to dot';
$string['pathtodot_help'] = 'Path to dot. On Linux it is something like /usr/bin/dot. On Windows it is something like C:\Program Files (x86)\Graphviz2.38\bin\dot.exe. On Mac it is something like /opt/local/bin/dot. To be able to generate graphics from DOT files, you must have installed the dot executable and point to it here.';
$string['pathtodu'] = 'Path to du';
$string['pathtogs'] = 'Path to ghostscript';
$string['pathtogs_help'] = 'On most Linux installs, this can be left as \'/usr/bin/gs\'. On Windows it will be something like \'c:\gs\bin\gswin32c.exe\' (make sure there are no spaces in the path - if necessary copy the files \'gswin32c.exe\' and \'gsdll32.dll\' to a new folder without a space in the path).';
$string['pathtopgdump'] = 'Path to pg_dump';
$string['pathtopgdumpdesc'] = 'This is only necessary to enter if you have more than one pg_dump on your system (for example if you have more than one version of postgresql installed)';
$string['pathtopgdumpinvalid'] = 'Invalid path to pg_dump - either wrong path or not executable';
$string['pathtopsql'] = 'Path to psql';
$string['pathtopsqldesc'] = 'This is only necessary to enter if you have more than one psql on your system (for example if you have more than one version of postgresql installed)';
$string['pathtopsqlinvalid'] = 'Invalid path to psql - either wrong path or not executable';
$string['pathtounoconv'] = 'Path to unoconv document converter';
$string['pathtounoconv_help'] = 'Path to unoconv document converter. This is an executable that is capable of converting between document formats supported by LibreOffice. This is optional, but if specified, Totara will use it to automatically convert between document formats. This is used to support a wider range of input files for the assignment annotate PDF feature.';
$string['pcreunicodewarning'] = 'It is strongly recommended to use PCRE PHP extension that is compatible with Unicode characters.';
$string['perfdebug'] = 'Performance info';
$string['performactivities'] = 'Performance activities';
$string['performance'] = 'Performance';
$string['performanceactivitycreatornewroleid'] = 'Performance activity creator\'s role in new performance activity';
$string['performanceactivitycreatornewroleid_help'] = 'If the user creating a performance activity does not already have the permissions to manage the new activity, they are automatically assigned this role in the performance activity\'s context.';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'PostgreSQL version/cluster parameter for command line operations. If you only have one postgresql on your system or you are not sure what this is, leave this blank.';
$string['phpfloatproblem'] = 'Detected unexpected problem in handling of PHP float numbers - {$a}';
$string['phpversion'] = 'PHP version';
$string['pleaserefreshregistration'] = 'Your site has been registered with Totaralms.com, please consider updating the registration if significant changes happened since your last update, on {$a}';
$string['pleaseregister'] = 'Please register your site to remove this button';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Plugin dependencies check';
$string['pluginscheckfailed'] = 'Dependencies check failed for {$a->pluginslist}';
$string['pluginschecktodo'] = 'You must solve all the plugin requirements before proceeding to install this Totara version!';
$string['pluginsoverview'] = 'Plugins overview';
$string['pluginsoverviewsee'] = 'See <a href="{$a->url}">plugins overview</a> page for more details.';
$string['preventmultiplelogins'] = 'Prevent multiple logins by the same user';
$string['preventmultiplelogins_help'] = 'If checked, a user can only login to their account from a single location. If a second account logs in, the first one will be automatically logged out.';
$string['privacypolicy'] = 'Privacy policy';
$string['privacypolicyhelp'] = 'The URL to the privacy policy.';
$string['profilecategory'] = 'Category';
$string['profilecategoryname'] = 'Category name (must be unique)';
$string['profilecategorynamenotunique'] = 'This category name is already in use';
$string['profilecommonsettings'] = 'Common settings';
$string['profileconfirmcategorydeletion'] = 'There is/are {$a} field/s in this category which will be moved into the category above (or below if in the top category).<br />Do you still wish to delete this category?';
$string['profileconfirmfielddeletion'] = 'There is/are {$a} user record/s for this field which will be deleted.<br />Do you still wish to delete this field?';
$string['profilecreatecategory'] = 'Create a new profile category';
$string['profilecreatefield'] = 'Create a new profile field:';
$string['profilecreatenewcategory'] = 'Creating a new category';
$string['profilecreatenewfield'] = 'Creating a new \'{$a}\' profile field';
$string['profiledefaultcategory'] = 'Other fields';
$string['profiledefaultchecked'] = 'Checked by default';
$string['profiledefaultdata'] = 'Default value';
$string['profiledeletecategory'] = 'Deleting a category';
$string['profiledeletefield'] = 'Deleting field \'{$a}\'';
$string['profiledescription'] = 'Description of the field';
$string['profiledscript'] = 'This script has been profiled';
$string['profiledscriptview'] = 'View profiling information for this script';
$string['profileeditcategory'] = 'Editing category: {$a}';
$string['profileeditfield'] = 'Editing profile field: {$a}';
$string['profilefield'] = 'Profile field';
$string['profilefieldcolumns'] = 'Columns';
$string['profilefieldduplication'] = '\'{$a}\' is already in use';
$string['profilefieldfieldfour'] = 'Field 4';
$string['profilefieldfieldone'] = 'Field 1';
$string['profilefieldfieldthree'] = 'Field 3';
$string['profilefieldfieldtwo'] = 'Field 2';
$string['profilefieldhidden'] = 'The profile field {$a} is set to hidden in setting';
$string['profilefieldispassword'] = 'Is this a password field?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'To transform the text into a link, enter a URL containing $$, where $$ will be replaced with the text. For example, to transform a Twitter ID to a link, enter http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Link target';
$string['profilefieldmaxlength'] = 'Maximum length';
$string['profilefieldrows'] = 'Rows';
$string['profilefields'] = 'User profile fields';
$string['profilefieldscannotempty'] = 'There must be at least one field set for user profile card';
$string['profilefieldsize'] = 'Display size';
$string['profilefielduserpicture'] = 'User picture';
$string['profileforceunique'] = 'Should the data be unique?';
$string['profileinvaliddata'] = 'Invalid value';
$string['profilelocked'] = 'Is this field locked?';
$string['profilemenudefaultnotinoptions'] = 'The default value is not one of the options';
$string['profilemenunooptions'] = 'No menu options supplied';
$string['profilemenuoptions'] = 'Menu options (one per line)';
$string['profilemenutoofewoptions'] = 'You must provide at least 2 options';
$string['profilename'] = 'Name';
$string['profilenofieldsdefined'] = 'No fields have been defined';
$string['profilerequired'] = 'Is this field required?';
$string['profilerequired_help'] = 'Enable if you want to force users to fill in required fields in their profile.

To prevent account lockouts these requirements are not enforced for primary admin and users that cannot update their profile.
Required fields are not required during account creation, instead if necessary users are asked to provide missing information after their first log in.';
$string['profileroles'] = 'Profile visible roles';
$string['profilesforenrolledusersonly'] = 'Profiles for enrolled users only';
$string['profileshortname'] = 'Short name (must be unique)';
$string['profileshortname_help'] = 'Custom field short name is the abbreviated name of the custom field and can be used for display purposes.

Custom fields will appear as options on the edit item screen for items.

NOTE: The custom field short name can only contain alphanumeric characters (letters and numbers).';
$string['profileshortnamenotunique'] = 'This short name is already in use';
$string['profilesignup'] = 'Display on signup page?';
$string['profilespecificsettings'] = 'Specific settings';
$string['profilevisible'] = 'Who is this field visible to?';
$string['profilevisible_help'] = 'The options are:

* **Not visible**: For private data only viewable by users with the **moodle/user:viewalldetails** capability in user context or the **moodle/course:viewhiddenuserfields** capability in course context.
* **Restricted visibility**: For private data only viewable by the user, and anyone with the **moodle/user:viewalldetails** capability or **moodle/course:viewhiddenuserfields** capability in course context.
* **Visible to everyone**: Viewable by all users.';
$string['profilevisibleall'] = 'Visible to everyone';
$string['profilevisiblenone'] = 'Not visible';
$string['profilevisibleprivate'] = 'Restricted visibility';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Continuous profiling';
$string['profilingallowall_help'] = 'If you enable this setting, then, at any moment, you can use the PROFILEALL parameter anywhere (PGC) to enable profiling for all the executed scripts along the Totara session life. Analogously, you can use the PROFILEALLSTOP parameter to stop it.';
$string['profilingallowme'] = 'Selective profiling';
$string['profilingallowme_help'] = 'If you enable this setting, then, selectively, you can use the PROFILEME parameter anywhere (PGC) and profiling for that script will happen. Analogously, you can use the DONTPROFILEME parameter to prevent profiling to happen.';
$string['profilingautofrec'] = 'Automatic profiling';
$string['profilingautofrec_help'] = 'By configuring this setting, some request (randomly, based on the frequency specified - 1 of N) will be picked and automatically profiled, storing results for further analysis. Note that this way of profiling observes the include/exclude settings. Set it to 0 to disable automatic profiling.';
$string['profilingenabled'] = 'Enable profiling';
$string['profilingenabled_help'] = 'If you enable this setting, then profiling will be available in this site and you will be able to define its behavior by configuring the next options.';
$string['profilingexcluded'] = 'Exclude profiling';
$string['profilingexcluded_help'] = 'List of (comma separated, absolute skipping wwwroot, callable) URLs that will be excluded from being profiled from the ones defined by **Profile these** setting.';
$string['profilingimportprefix'] = 'Profiling import prefix';
$string['profilingimportprefix_desc'] = 'For easier detection, all the imported profiling runs will be prefixed with the value specified here.';
$string['profilingincluded'] = 'Profile these';
$string['profilingincluded_help'] = 'List of (comma separated, absolute skipping wwwroot, callable) URLs that will be automatically profiled. Examples: /index.php, /course/view.php. Also accepts the * wildchar at any position. Examples: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Keep profiling runs';
$string['profilinglifetime_help'] = 'Specify the time you want to keep information about old profiling runs. Older ones will be pruned periodically. Note that this excludes any profiling run marked as \'reference run\'.';
$string['protectusernames'] = 'Protect usernames';
$string['proxybypass'] = 'Proxy bypass hosts';
$string['proxyhost'] = 'Proxy host';
$string['proxypassword'] = 'Proxy password';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Proxy type';
$string['proxyuser'] = 'Proxy username';
$string['pspellrecommended'] = 'Installing the optional PSpell extension is recommended. It will enable Totara to suggest alternative searches when spelling mistakes are detected.';
$string['publishername'] = 'Publisher\'s name';
$string['publishernamehelp'] = 'The website address of the publisher.';
$string['publisherwebsite'] = 'Publisher\'s website';
$string['publishgridcatalogimage'] = 'Allow public access to catalogue item images';
$string['publishgridcatalogimage_help'] = 'If enabled, the images that appear in the grid catalogue will be publicly accessible via direct URL. This allows these images to be included in catalogue content that is displayed in other systems.';
$string['purgecaches'] = 'Purge all caches';
$string['purgecachesconfirm'] = 'Totara can cache themes, javascript, language strings, filtered text, rss feeds and many other pieces of calculated data.  Purging these caches will delete that data from the server and force browsers to refetch data, so that you can be sure you are seeing the most up-to-date values produced by the current code.  There is no danger in purging caches, but your site may appear slower for a while until the server and clients calculate new information and cache it.';
$string['purgecachesfinished'] = 'All caches were purged.';
$string['query'] = 'Query';
$string['question'] = 'Question';
$string['questionbehaviours'] = 'Question behaviours';
$string['questioncwqpfscheck'] = 'One or more \'random\' questions in a quiz are set up to select questions from a mixture of shared and unshared question categories. There is a more detailed report <a href="{$a->reporturl}">here</a> and see Totara Docs page <a href="{$a->docsurl}">here</a>.';
$string['questioncwqpfsok'] = 'Good. There are no \'random\' questions in your quizzes that are set up to select questions from a mixture of shared and unshared question categories.';
$string['questiontype'] = 'Question type';
$string['questiontypes'] = 'Question types';
$string['quickaccessmenu_group-configuration'] = 'Configuration';
$string['quickaccessmenu_group-learn'] = 'Learning';
$string['quickaccessmenu_group-perform'] = 'Performance';
$string['quickaccessmenu_group-platform'] = 'Core platform';
$string['quizattemptsupgradedmessage'] = 'In Totara 2.2 there was a major upgrade to questions. It was possible to delay parts of the database upgrade to be run later. Before upgrading to Totara 2.7, this upgrade must be completed.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA secret key';
$string['recaptchapublickey'] = 'ReCAPTCHA site key';
$string['register'] = 'Register your site';
$string['registration'] = 'Registration';
$string['registrationdisabled'] = 'Disabled';
$string['registrationenabled'] = 'Enabled';
$string['registrationinformation'] = 'Registration information to be sent';
$string['registrationisdisabled'] = 'Totara registration is disabled.  Configuring your site to register basic information with Totara is recommended to assist in troubleshooting any future issues you may have.';
$string['registrationisenabled'] = 'The site has been successfully registered with Totara.';
$string['registrationoutofdate'] = 'Totara registration information has not been updated for an extended period of time. Registration information should be kept up-to-date to assist possible future troubleshooting. Ensure that your webserver has unrestricted access to make https requests to subscriptions.totara.community';
$string['registrationwarning'] = 'Your site is not yet registered.';
$string['registrationwarningcontactadmin'] = 'Your site is not yet registered. Please notify your administrator.';
$string['releasenoteslink'] = 'For information about this version of Totara, please see the online <a target="_blank" href="{$a}">Release Notes</a>';
$string['rememberusername'] = 'Remember username';
$string['rememberusername_desc'] = 'Enable if you want to store permanent cookies with usernames during user login. Permanent cookies may be considered a privacy issue if used without consent.';
$string['reportsmanage'] = 'Manage reports';
$string['repository'] = 'Repository';
$string['requestcategoryselection'] = 'Enable category selection';
$string['requiremodintro'] = 'Require activity description';
$string['requiremodintro_desc'] = 'If enabled, users will be forced to enter a description for each activity.';
$string['requires'] = 'Requires';
$string['resourcenotfound'] = 'Resource not found';
$string['restorecourse'] = 'Restore course';
$string['restorernewroleid'] = 'Restorers\' role in courses';
$string['restorernewroleid_help'] = 'If the user does not already have the permission to manage the newly restored course, the user is automatically assigned this role and enrolled if necessary. Select **None** if you do not want restorers to be able to manage every restored course.';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignore reverse proxies';
$string['riskallowxss'] = 'Users could add files and texts that allow cross-site scripting (XSS)';
$string['riskallowxssshort'] = 'XSS risk';
$string['riskconfig'] = 'Users could change site configuration and behaviour';
$string['riskconfigshort'] = 'Configuration risk';
$string['riskdataloss'] = 'Users could destroy large amounts of content or information';
$string['riskdatalossshort'] = 'Data loss risk';
$string['riskmanagetrust'] = 'Users could change trust settings of other users';
$string['riskmanagetrustshort'] = 'Manage trusts';
$string['riskpersonal'] = 'Users could gain access to private information of other users';
$string['riskpersonalshort'] = 'Privacy risk';
$string['riskspam'] = 'Users could send spam to site users or others';
$string['riskspamshort'] = 'Spam risk';
$string['riskxss'] = 'Users could add files and texts that allow cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS risk';
$string['roleswithexceptions'] = '{$a->roles}, with {$a->exceptions}';
$string['rssglobaldisabled'] = 'Disabled at site level';
$string['save'] = 'Save';
$string['savechanges'] = 'Save changes';
$string['scssinvalid'] = 'SCSS code is not valid, fails with: {$a}';
$string['search'] = 'Search';
$string['searchalldeleted'] = 'All indexed contents have been deleted';
$string['searchareadisabled'] = 'Search area disabled';
$string['searchareaenabled'] = 'Search area enabled';
$string['searchareas'] = 'Search areas';
$string['searchdeleteindex'] = 'Delete all indexed contents';
$string['searchengine'] = 'Search engine';
$string['searchindexactions'] = 'Index actions';
$string['searchindexdeleted'] = 'Index deleted';
$string['searchindextime'] = 'Indexing time limit';
$string['searchindextime_desc'] = 'When indexing large amounts of new content, the scheduled task will stop after this time limit is reached. It will continue the next time the task runs.';
$string['searchindexupdated'] = 'Search engine contents have been updated';
$string['searchindexwhendisabled'] = 'Index when disabled';
$string['searchindexwhendisabled_desc'] = 'Allows the scheduled task to build the search index even when search is disabled. This is useful if you want to build the index before the search facility appears to students.';
$string['searchinsettings'] = 'Search in settings';
$string['searchlastrun'] = 'Last run (time, # docs, # records, # ignores)';
$string['searchnotavailable'] = 'Search is not available';
$string['searchoptions'] = 'Search options';
$string['searchpartial'] = '(not yet fully indexed)';
$string['searchreindexed'] = 'All site contents have been reindexed.';
$string['searchreindexindex'] = 'Reindex all site contents';
$string['searchresults'] = 'Search results';
$string['searchsetupinfo'] = 'Search setup';
$string['searchupdateindex'] = 'Update indexed contents';
$string['sectionerror'] = 'Section error!';
$string['secureforms'] = 'Use additional form security';
$string['security'] = 'Security';
$string['selectdevice'] = 'Select device';
$string['selectoauth2issuer'] = 'Select OAuth2 Service...';
$string['selectsearchengine'] = 'Select search engine';
$string['selecttheme'] = 'Select theme for {$a} device';
$string['server'] = 'Server';
$string['serverchecks'] = 'Server checks';
$string['serverinformation'] = 'Server information';
$string['serverlimit'] = 'Server limit';
$string['servernot64bit'] = 'Server not 64-bit';
$string['sessionautostartwarning'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Totara requires that administrator changes PHP settings.</p><p><code>session.auto_start</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookie domain';
$string['sessioncookiepath'] = 'Cookie path';
$string['sessionhandling'] = 'Session handling';
$string['sessiontimeout'] = 'Timeout';
$string['settingalwayspopulaterawpostdata'] = 'The always_populate_raw_post_data setting is known to cause problems when using PHP 5.6 and when you have debugging turned on. We recommended that this setting be set to -1 to avoid any issues and confusion. If you are not running PHP 5.6 then you can ignore this warning.';
$string['settingdisabled'] = 'Disabled';
$string['settingenabled'] = 'Enabled';
$string['settingfileuploads'] = 'File uploading is required for normal operation, please enable it in PHP configuration.';
$string['settingmaxinputvars'] = 'PHP setting max_input_vars is recommended to be at least 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP setting max_input_vars must be at least 5000.';
$string['settingmemorylimit'] = 'Insufficient memory detected, please set higher memory limit in PHP settings.';
$string['settingsafemode'] = 'Totara is not fully compatible with safe mode, please ask server administrator to turn it off. Running Totara under safe mode is not supported, please expect various problems if you do so.';
$string['setupsearchengine'] = 'Setup search engine';
$string['showcommentscount'] = 'Show comments count';
$string['showdetails'] = 'Show details';
$string['showuseridentity'] = 'Show user identity';
$string['showuseridentity_desc_v2'] = 'These fields may be shown when displaying lists of users or searching for them, however, this is not consistently used throughout the site. Fields are only visible to trainers and managers who have the moodle/site:viewuseridentity capability. (Ideally, this option is best if you choose at least one or two fields that your institution requires.)';
$string['simplexmlrequired'] = 'The SimpleXML PHP extension is now required by Totara.';
$string['sitefullname'] = 'Site Fullname';
$string['sitehasntregistered'] = 'This site has not yet successfully registered with Totara. Registering basic information with Totara is recommended to assist in troubleshooting any future issues you may have.  Ensure your webserver is able to make https requests to subscriptions.totara.community and that the Totara cron is configured properly.';
$string['siteidentifier'] = 'Site Identifier';
$string['sitemailcharset'] = 'Character set';
$string['sitemaintenance'] = 'The site is undergoing maintenance and is currently not available';
$string['sitemaintenancemode'] = 'Maintenance mode';
$string['sitemaintenanceoff'] = 'Maintenance mode has been disabled and the site is running normally again';
$string['sitemaintenanceon'] = 'Your site is currently in maintenance mode (only admins can log in or use the site).';
$string['sitemaintenanceoncli'] = 'Your site is currently in CLI maintenance mode, no web access is allowed.';
$string['sitemaintenancewarning'] = 'Your site is currently in maintenance mode (only admins can log in).  To return this site to normal operation, <a href="maintenance.php">disable maintenance mode</a>.';
$string['sitemaintenancewarning2'] = 'Your site is currently in maintenance mode (only admins can log in).  To return this site to normal operation, <a href="{$a}">disable maintenance mode</a>.';
$string['sitenothttps'] = 'Site not https';
$string['sitepolicies'] = 'Site policies';
$string['sitepolicy'] = 'Site policy URL';
$string['sitepolicy_help'] = 'If you have a site policy that all registered users must see and agree to before accessing the site, then specify the URL to it here, otherwise leave this field blank. This setting can contain any public URL.';
$string['sitepolicyguest'] = 'Site policy URL for guests';
$string['sitepolicyguest_help'] = 'If you have a site policy that all guests must see and agree to before using this site, then specify the URL to it here, otherwise leave this field blank. This setting can contain any public URL. Note that access of not-logged-in users may be prevented with **force login** setting.';
$string['sitesectionhelp'] = 'If selected, a topic section will be displayed on the site\'s front page.';
$string['siteshortname'] = 'Site Shortname';
$string['smartpix'] = 'Smart pix search';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) settings for sending email.';
$string['smtphosts'] = 'SMTP hosts';
$string['smtpmaxbulk'] = 'SMTP session limit';
$string['smtppass'] = 'SMTP password';
$string['smtpsecure'] = 'SMTP security';
$string['smtpuser'] = 'SMTP username';
$string['soaprecommended'] = 'Installing the optional SOAP extension is useful for web services and some plugins.';
$string['sodiumrecommended'] = 'Installing the optional Sodium extension is highly recommended for the External API and some plugins';
$string['sodiumrequired'] = 'The Sodium PHP extension is now required by Totara';
$string['sort_fullname'] = 'Course full name';
$string['sort_idnumber'] = 'Course ID number';
$string['sort_shortname'] = 'Course short name';
$string['sort_sortorder'] = 'Sort order';
$string['spellengine'] = 'Spell engine';
$string['spelllanguagelist'] = 'Spell language list';
$string['splrequired'] = 'The SPL PHP extension is now required by Totara.';
$string['stats'] = 'Statistics';
$string['statsfirstrun'] = 'Maximum processing interval';
$string['statsmaxruntime'] = 'Maximum runtime';
$string['statsmoodleorg'] = 'statistics';
$string['statsruntimedays'] = 'Days to process';
$string['statsruntimestart'] = 'Run at';
$string['statsuserthreshold'] = 'User threshold';
$string['stickyblocks'] = 'Sticky blocks';
$string['stickyblockscourseview'] = 'Course page';
$string['stickyblocksduplicatenotice'] = 'If any block you add here is already present in a particular page, it will result in a duplicate.<br />Only the pinned block will be non-editable, the duplicate will still be editable.';
$string['stickyblocksmymoodle'] = 'My Learning';
$string['stickyblockspagetype'] = 'Page type to configure';
$string['strictformsrequired'] = 'Strict validation of required fields';
$string['stripalltitletags'] = 'Remove HTML tags from all activity names';
$string['successupdateprofilecard'] = 'Successfully updated the user profile card'; // todo ux to fix the string
$string['supportcontact'] = 'Support contact';
$string['supportemail'] = 'Support email';
$string['supportname'] = 'Support name';
$string['supportpage'] = 'Support page';
$string['suspenduser'] = 'Suspend user account';
$string['switchlang'] = 'Switch lang directory';
$string['systempaths'] = 'System paths';
$string['systemreports'] = 'System reports';
$string['tablenosave'] = 'Changes in table above are saved automatically.';
$string['tablesnosave'] = 'Changes in tables above are saved automatically.';
$string['tabselectedtofront'] = 'On tables with tabs, should the row with the currently selected tab be placed at the front';
$string['tabselectedtofronttext'] = 'Bring selected tab row to front';
$string['taskautomatedbackup'] = 'Automated backups';
$string['taskbackupcleanup'] = 'Clean backup tables and logs';
$string['taskbadgescron'] = 'Award badges';
$string['taskbadgesmessagecron'] = 'Background processing for sending badges notifications';
$string['taskblogcron'] = 'Sync external blogs';
$string['taskcachecleanup'] = 'Remove expired cache entries';
$string['taskcachecron'] = 'Background processing for caches';
$string['taskcalendarcron'] = 'Send calendar notifications';
$string['taskcompletiondaily'] = 'Completion mark as started';
$string['taskcompletionregular'] = 'Calculate regular completion data';
$string['taskcontextcleanup'] = 'Cleanup contexts';
$string['taskdeletecachetext'] = 'Delete old text cache records';
$string['taskdeleteincompleteusers'] = 'Delete incomplete users';
$string['taskdeleteunconfirmedusers'] = 'Delete unconfirmed users';
$string['taskeventscron'] = 'Background processing for events';
$string['taskfiletrashcleanup'] = 'Cleanup files in trash';
$string['taskglobalsearchindex'] = 'Global search indexing';
$string['taskglobalsearchoptimize'] = 'Global search index optimization';
$string['taskgradecron'] = 'Background processing for gradebook';
$string['tasklegacycron'] = 'Legacy cron processing for plugins';
$string['taskmessagingcleanup'] = 'Background processing for messaging';
$string['taskpasswordresetcleanup'] = 'Cleanup password reset attempts';
$string['taskplagiarismcron'] = 'Background processing for legacy cron in plagiarism plugins';
$string['taskportfoliocron'] = 'Background processing for portfolio plugins';
$string['taskquestioncron'] = 'Background processing for question engine';
$string['taskrefreshsystemtokens'] = 'Refresh OAuth tokens for service accounts';
$string['taskregistrationcron'] = 'Site registration';
$string['tasksendfailedloginnotifications'] = 'Send failed login notifications';
$string['tasksendnewuserpasswords'] = 'Send new user passwords';
$string['tasksessioncleanup'] = 'Cleanup old sessions';
$string['taskstatscron'] = 'Background processing for statistics';
$string['tasktagcron'] = 'Background processing for tags';
$string['tasktempfilecleanup'] = 'Delete stale temp files';
$string['techsupportemail'] = 'Tech support email';
$string['techsupportemailhelp'] = 'Email address of persons handling most technical issues related to site hosting';
$string['techsupportphone'] = 'Tech support phone number';
$string['techsupportphonehelp'] = 'Phone number of persons handling most technical issues related to site hosting. (Include country code)';
$string['tempdatafoldercleanup'] = 'Clean up temporary data files older than';
$string['tenantisolationmode'] = 'Tenant isolation mode';
$string['tenantmembers'] = 'Total number of tenant members';
$string['tenantparticipants'] = 'Total number of tenant participants (Non-members)';
$string['tenantsenabled'] = 'Multitenancy support';
$string['termsofuse'] = 'Terms of use';
$string['termsofusehelp'] = 'The URL to the terms of use.';
$string['testsiteupgradewarning'] = 'You are currently using the {$a} test site, to upgrade it properly use the command line interface tool';
$string['themedesignermode'] = 'Theme designer mode';
$string['themedesignermodewarning'] = 'Theme designer mode is enabled. This should not be enabled on production sites as it can significantly reduce performance.';
$string['themelist'] = 'Theme list';
$string['themenoselected'] = 'No theme selected';
$string['themeresetcaches'] = 'Clear theme caches';
$string['themeselect'] = 'Change theme';
$string['themeselector'] = 'Theme selector';
$string['themesettings'] = 'Theme settings';
$string['therewereerrors'] = 'There were errors in your data';
$string['thirdpartylibrary'] = 'Library';
$string['thirdpartylibrary_client'] = 'Enterprise Extensions';
$string['thirdpartylibrary_server'] = 'Talent Experience Platform';
$string['thirdpartylibrarylocation'] = 'Location';
$string['thirdpartylibs'] = 'Third party libraries';
$string['timezone'] = 'Default timezone';
$string['timezoneforced'] = 'This is forced by the site administrator';
$string['timezoneinvalid'] = 'Invalid timezone "{$a}"';
$string['timezoneisforcedto'] = 'Force all users to use';
$string['timezonenotforced'] = 'Users can choose their own timezone';
$string['timezonephpdefault'] = 'Default PHP timezone ({$a})';
$string['timezoneserver'] = 'Server timezone ({$a})';
$string['tlswarning'] = 'No PHP/cURL extension with TLSv1.2 support has been detected. Some services may not work. It is strongly recommended to upgrade your TLS libraries.';
$string['tokenizerrecommended'] = 'Installing the optional PHP Tokenizer extension is recommended -- it improves Totara Networking functionality.';
$string['tools'] = 'Admin tools';
$string['toolsmanage'] = 'Manage admin tools';
$string['totaracatalogue'] = 'Totara catalogue';
$string['totaracataloguegrid'] = 'Totara grid catalogue';
$string['totaradashboard'] = 'Totara dashboard';
$string['unattendedoperation'] = 'Unattended operation';
$string['unbookmarkthispage'] = 'Unbookmark this page';
$string['unicoderequired'] = 'It is required that you store all your data in Unicode format (UTF-8). New installations must be performed into databases that have their default character set as Unicode.  If you are upgrading, you should perform the UTF-8 migration process (see the Admin page).';
$string['uninstallplugin'] = 'Uninstall';
$string['unlockaccount'] = 'Unlock user account';
$string['unoconvwarning'] = 'The version of unoconv you have installed is not supported. Totara\'s assignment grading feature requires version 0.7 or higher.';
$string['unsettheme'] = 'Unset theme';
$string['unsupported'] = 'Unsupported';
$string['unsupporteddbfileformat'] = 'Totara requires Barracuda file format in MySQL and MariaDB, you need to change the database settings to: innodb_file_format=Barracuda';
$string['unsupporteddbfilepertable'] = 'Totara requires one file per table in MySQL and MariaDB, you need to change the database settings to: innodb_file_per_table=1';
$string['unsupporteddblargeprefix'] = 'For full support of UTF-8 both MySQL and MariaDB require you to change the database settings to: innodb_large_prefix=1';
$string['unsupporteddbstorageengine'] = 'The database storage engine being used is no longer supported.';
$string['unsupporteddbstorageenginecheck'] = 'Unsupported database storage engine';
$string['unsupporteddbtablerowformat'] = 'Your database has tables using unsupported legacy row formats. It is strongly recommended to convert all tables to supported row formats using admin/cli/mysql_compressed_rows.php CLI script.';
$string['unsupporteddbtablerowformatcheck'] = 'Unsupported database table row format';
$string['unsupportedphpversion84'] = 'PHP version 8.4 and higher is not supported.';
$string['unsupportedssltlsconfiguration'] = 'SSL/TLS configuration not supported';
$string['unsupportedunoconvversion'] = 'unoconv version not supported';
$string['unsuspenduser'] = 'Activate user account';
$string['updateaccounts'] = 'Update existing accounts';
$string['updateautocheck'] = 'Automatically check for available updates';
$string['updateautocheck_desc'] = 'If enabled, your site will automatically check for available updates for both Totara code and all additional plugins. If there is a new update available, a notification will be sent to site admins.';
$string['updateavailable'] = 'There is a newer Totara version available!';
$string['updateavailable_moreinfo'] = 'More info...';
$string['updateavailable_release'] = 'Totara {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailabledetailslink'] = 'See {$a->url} for more details';
$string['updateavailableforplugin'] = 'There is a newer version for some of your plugins available!';
$string['updateavailableinstall'] = 'Install this update';
$string['updateavailableinstallall'] = 'Install available updates ({$a})';
$string['updateavailableinstallallhead'] = 'Installing available updates';
$string['updateavailablenot'] = 'Your Totara code is up-to-date!';
$string['updateavailablerecommendation'] = 'It is strongly recommended that you update your site to the latest version to obtain all recent security and bug fixes.';
$string['updatecomponent'] = 'Update component';
$string['updateminmaturity'] = 'Required code maturity';
$string['updateminmaturity_desc'] = 'Notify about available updates only if the available code has the selected maturity level at least. Updates for plugins that do not declare their code maturity level are always reported regardless this setting.';
$string['updatenotificationfooter'] = 'Your Totara site {$a->siteurl} is configured to automatically check for available updates. You are receiving this message as the administrator of the site. You can disable automatic checks for available updates in the Site administration section of the Administration block. You can customise the delivery of this message via your preferences page.';
$string['updatenotifications'] = 'Update notifications';
$string['updatenotificationsubject'] = 'Totara updates are available ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notify about new builds';
$string['updatenotifybuilds_desc'] = 'If enabled, the available update for Totara code is also reported when a new build for the current version is available. Builds are continuous improvements of a given Totara version. They are generally released every week. If disabled, the available update will be reported only when there is a higher version of Totara released. Checks for plugins are not affected by this setting.';
$string['upgradeerror'] = 'Unknown error upgrading {$a->plugin} to version {$a->version}, can not continue.';
$string['upgradeerrormainsavepoint'] = 'Illegal attempt to upgrade Totara version in plugin script {$a}, site upgrade has been halted immediately! You should roll back your database and re-run upgrade after fixing the script.';
$string['upgradekey'] = 'Upgrade key';
$string['upgradekeydesc'] = 'In order to commence the upgrade an administrator must provide the upgrade key for this site.';
$string['upgradekeyreq'] = 'Upgrade key required';
$string['upgradekeyset'] = 'Upgrade key (leave empty to not set it)';
$string['upgradelogs'] = 'For full functionality, your old logs need to be upgraded.  <a href="{$a}">More information</a>';
$string['upgradelogsinfo'] = 'Some changes have recently been made in the way logs are stored.  To be able to view all of your old logs on a per-activity basis, your old logs need to be upgraded.  Depending on your site this can take a long time (eg several hours) and can be quite taxing on the database for large sites.  Once you start this process you should let it finish (by keeping the browser window open).  Don\'t worry - your site will work fine for other people while the logs are being upgraded.<br /><br />Do you want to upgrade your logs now?';
$string['upgradepluginsfirst'] = 'It is recommended to install all available updates first';
$string['upgradepluginsinfo'] = 'Updating plugins';
$string['upgradepluginsinfo_help'] = 'There are available updates for some of your plugins. You should install them all prior to upgrading Totara database. If your site does not support automatic updates deployment, you have to download and install new plugin versions at your server manually.';
$string['upgradepluginsinfo_link'] = 'Manually Installing Plugins';
$string['upgradesettings'] = 'New settings';
$string['upgradesettingsintro'] = 'The settings shown below were added during your last Totara upgrade. Make any changes necessary to the defaults and then click the &quot;Save changes&quot; button at the bottom of this page.';
$string['upgradestalefiles'] = 'Mixed Totara versions detected, upgrade cannot continue';
$string['upgradestalefilesinfo'] = 'The Totara update process has been paused because PHP scripts from at least two major versions of Totara have been detected in the Totara directory.

This can cause significant problems later, so in order to continue you must ensure that the Totara directory contains only files for a single version of Totara.

The recommended way to clean your Totara directory is as follows:

* rename the current Totara directory to "totara_old"
* create a new Totara directory containing only files from a standard Totara package download
* move the original config.php file and any non-standard plugins from the "totara_old" directory to the new Totara directory

When you have a clean Totara directory, refresh this page to resume the Totara update process.

This warning is often caused by unzipping a standard Totara package over a previous version of Totara. While this is OK for minor upgrades, it is strongly discouraged for major Totara upgrades.

This warning can also be caused by an incomplete checkout or update operation from a GIT repository, in which case you may just have to wait for the operation complete, or perhaps run the appropriate clean up command and retry the operation.

You can find more information in upgrade documentation at <a href="{$a}">{$a}</a>.';
$string['upgradestalefilesinfonohelplink'] = 'The Totara update process has been paused because PHP scripts from at least two major versions of Totara have been detected in the Totara directory.

This can cause significant problems later, so in order to continue you must ensure that the Totara directory contains only files for a single version of Totara.

The recommended way to clean your Totara directory is as follows:

* rename the current Totara directory to "totara_old"
* create a new Totara directory containing only files from a standard Totara package download
* move the original config.php file and any non-standard plugins from the "totara_old" directory to the new Totara directory

When you have a clean Totara directory, refresh this page to resume the Totara update process.

This warning is often caused by unzipping a standard Totara package over a previous version of Totara. While this is OK for minor upgrades, it is strongly discouraged for major Totara upgrades.

This warning can also be caused by an incomplete checkout or update operation from a GIT repository, in which case you may just have to wait for the operation complete, or perhaps run the appropriate clean up command and retry the operation.';
$string['upgradestart'] = 'Upgrade Totara database now';
$string['upgradesure'] = '<p>Your Totara files have been changed, and you are about to automatically upgrade your server from this version:</p>
<p><strong>{$a->oldversion}</strong></p>
<p>to this version: </p>
<p><strong>{$a->newversion}</strong></p>
<p>Once you do this you can not go back again.</p>
<p>Please note that this process can take a long time.</p>
<p>Are you sure you want to upgrade this server to this version?</p>';
$string['upgradetimedout'] = 'Upgrade timed out, please restart the upgrade.';
$string['upgradingdata'] = 'Upgrading data';
$string['upgradinglogs'] = 'Upgrading logs';
$string['upgradingversion'] = 'Upgrading to new version';
$string['upwards'] = 'upwards';
$string['useblogassociations'] = 'Enable associations';
$string['useexternalyui'] = 'Use online YUI libraries';
$string['user'] = 'User';
$string['userbulk'] = 'Bulk user actions';
$string['userbulkdownload'] = 'Export users as';
$string['usercount'] = 'Number of site users';
$string['userdefaultpreferences'] = 'User default preferences';
$string['userimagesdisabled'] = 'Profile user images are disabled';
$string['userlist'] = 'Browse list of users';
$string['userpolicies'] = 'User policies';
$string['userpreference'] = 'User preference';
$string['userprofilesummarycard'] = 'User profile summary card';
$string['userprofilesummarycardformhelp'] = 'Select the fields to populate the user profile summary card';
$string['userquota'] = 'User quota';
$string['users'] = 'Users';
$string['usersessionscount'] = 'Number of user sessions';
$string['usesitenameforsitepages'] = 'Use site name for site pages';
$string['usetags'] = 'Enable tags functionality';
$string['use_legacy_course_sortorder'] = 'Use legacy course sort order';
$string['use_legacy_course_sortorder_desc'] = 'If enabled legacy course sort order will apply via schedule task once a week';
$string['validateemptylineerror'] = 'Empty lines are not valid';
$string['validateerror'] = 'This value is not valid';
$string['validateerrorlist'] = 'These entries are invalid: {$a}';
$string['validateiperror'] = 'These IP addresses are invalid: {$a}';
$string['verifychangedemail'] = 'Restrict domains when changing email';
$string['warningcurrentsetting'] = 'Invalid current value: {$a}';
$string['warningiconvbuggy'] = 'Your version of the iconv library does not support the //IGNORE modifier. You should install the mbstring extension which can be used instead for cleaning strings containing invalid UTF-8 characters.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Fill in following options if your Totara server can not access internet directly. Internet access is required for download of environment data, language packs, RSS feeds, timezones, etc.<br /><em>PHP cURL extension is highly recommended.</em>';
$string['webserversoftware'] = 'Web server software identifier';
$string['wwwroot'] = 'Site www root';
$string['xmllibraryentitycheckerror'] = 'An XML library loaded an external entity by default. This represents a security risk. Consider upgrading versions of PHP and/or libxml to resolve this.';
$string['xmlstrictheaders'] = 'XML strict headers';
$string['yuicomboloading'] = 'YUI combo loading';
$string['ziprequired'] = 'The Zip PHP extension is now required by Totara, info-ZIP binaries or PclZip library are not used anymore.';

/**
 * Deprecated since Moodle 3.2.
 */
$string['mobile'] = 'Mobile';

/**
 * Deprecated since Totara 9.0
 */
$string['requiredentrieschanged'] = '<strong>IMPORTANT - PLEASE READ<br/>(This warning message will only be displayed during this upgrade)</strong><br/>Due to a bug fix, the behaviour of database activities using the \'Required entries\' and \'Required entries before viewing settings\' settings will change. A more detailed explanation of the changes can be read on <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">the database module forum</a>. The expected behavior of these settings can also be read on <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>.
<br/><br/>This change affects the following databases in your system: (Please save this list now, and after the upgrade, check that these activities still work the way that the trainer intends.)<br/><strong>{$a->text}</strong><br/>';

/**
 * @deprecated since Totara 12.0
 */
$string['loginpasswordautocomplete'] = 'Prevent password autocompletion on login form';
$string['loginpasswordautocomplete_help'] = 'If enabled, users are not allowed to save their account password in their browser.';

/**
 * @deprecated since Totara 13.0
 */
$string['taskcreatecontexts'] = 'Create missing contexts';

/**
 * @deprecated since Totara 17.0
 */
$string['maxinputvars'] = 'We recommend setting max_input_vars to a minimum of 2000 to ensure proper functionality of the site.';
$string['unsupportedphpversion7'] = 'PHP version 7.0 and higher is not supported.';
$string['unsupportedphpversion71'] = 'PHP version 7.1 and higher is not supported.';
$string['unsupportedphpversion74'] = 'PHP version 7.4 and higher is not supported.';
$string['unsupportedphpversion81'] = 'PHP version 8.1 and higher is not supported.';

/**
 * Deprecated since Totara 19.0
 */
$string['check_resourcesallowpdfembedding_details'] = '<p>Users may upload untrusted PDF files as File resources.</p><p>It is recommended to disable "Allow PDF embedding" settings.</p>';
$string['check_resourcesallowpdfembedding_name'] = 'Embedding of PDF files in course resources';
$string['check_resourcesallowpdfembedding_ok'] = 'Uploaded PDF file are not opened directly in browsers.';
$string['check_resourcesallowpdfembedding_warning'] = 'Uploaded PDF files may be opened directly in browsers.';
$string['unsupportedphpversion82'] = 'PHP version 8.2 and higher is not supported.';
$string['showuseridentity_desc'] = 'When selecting or searching for users, and when displaying lists of users, these fields may be shown in addition to their full name. The fields are only shown to users who have the moodle/site:viewuseridentity capability; by default, trainers and managers. (This option makes most sense if you choose one or two fields that are mandatory at your institution.)';
