<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'message', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @note Automatically cleaned: 2024-09-24
 * @package   core_message
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['a11y_message_count'] = 'Message count';
$string['a11y_notification_count'] = 'Notification count';
$string['addcontact'] = 'Add contact';
$string['addtoyourcontacts'] = 'Add to your contacts';
$string['ago'] = '{$a} ago';
$string['allusers'] = 'All messages from all users';
$string['backupmessageshelp'] = 'If enabled, then instant messages will be included in SITE automated backups';
$string['blockcontact'] = 'Block contact';
$string['blocknoncontacts'] = 'Prevent non-contacts from messaging me';
$string['canceledit'] = 'Cancel editing messages';
$string['contactblocked'] = 'Contact blocked';
$string['contacts'] = 'Contacts';
$string['defaultmessageoutputs'] = 'Default message outputs';
$string['defaults'] = 'Defaults';
$string['deleteallconfirm'] = "Are you sure you would like to delete this entire conversation?";
$string['deleteallmessages'] = "Delete all messages";
$string['deleteselectedmessages'] = 'Delete selected messages';
$string['disableall'] = 'Disable notifications';
$string['disabled'] = 'Messaging is disabled on this site';
$string['disallowed'] = 'Disallowed';
$string['editmessages'] = 'Edit messages';
$string['emailtagline'] = 'This is a copy of a message sent to you at "{$a->sitename}". Go to {$a->url} to reply.';
$string['enabled'] = 'Enabled';
$string['enablex'] = 'Enable {$a}';
$string['errorcallingprocessor'] = 'Error calling defined output';
$string['errormessagetoolong'] = 'The message is longer than the maximum allowed.';
$string['errortranslatingdefault'] = 'Error translating default setting provided by plugin, using system defaults instead.';
$string['eventmessagecontactadded'] = 'Message contact added';
$string['eventmessagecontactblocked'] = 'Message contact blocked';
$string['eventmessagecontactremoved'] = 'Message contact removed';
$string['eventmessagecontactunblocked'] = 'Message contact unblocked';
$string['eventmessagedeleted'] = 'Message deleted';
$string['eventmessagesent'] = 'Message sent';
$string['eventmessageviewed'] = 'Message viewed';
$string['eventnotificationsent'] = 'Notification sent';
$string['eventnotificationviewed'] = 'Notification viewed';
$string['forced'] = 'Locked';
$string['guestnoeditmessage'] = 'Guest user can not edit messaging options';
$string['guestnoeditmessageother'] = 'Guest user can not edit other user messaging options';
$string['hidemessagewindow'] = 'Hide message window';
$string['hidenotificationwindow'] = 'Hide notification window';
$string['loggedin'] = 'Online';
$string['loggedin_help'] = 'Configure how you would like to receive notifications when you are logged into Totara.';
$string['loggedindescription'] = 'When you are logged into Totara';
$string['loggedoff'] = 'Offline';
$string['loggedoff_help'] = 'Configure how you would like to receive notifications when you are not logged into Totara.';
$string['loggedoffdescription'] = 'When you are not logged into Totara';
$string['managemessageoutputs'] = 'Manage message outputs';
$string['message'] = 'Message';
$string['messageoutputs'] = 'Message outputs';
$string['messagepreferences'] = 'Message preferences';
$string['messages'] = 'Messages';
$string['messaging'] = 'Messaging';
$string['messagingdisabled'] = 'Messaging is disabled on this site, emails will be sent instead';
$string['newmessage'] = 'New message';
$string['newmessagesearch'] = 'Select or search for a contact to send a new message.';
$string['newonlymsg'] = 'Show only new';
$string['newsearch'] = 'New search';
$string['nocontacts'] = 'No contacts';
$string['noframesjs'] = 'Use more accessible interface';
$string['nomessages'] = 'No messages';
$string['nomessagesfound'] = 'No messages were found';
$string['noncontacts'] = 'Non-contacts';
$string['nonotifications'] = 'You have no notifications';
$string['noreply'] = 'Do not reply to this message';
$string['notificationimage'] = 'Notification image';
$string['notificationpreferences'] = 'Legacy notification preferences';
$string['notifications'] = 'Notifications';
$string['notificationwindow'] = 'Notification window';
$string['off'] = 'Off';
$string['offline'] = 'Offline';
$string['on'] = 'On';
$string['online'] = 'Online';
$string['outputdisabled'] = 'Output disabled';
$string['outputdoesnotexist'] = 'Message output does not exists';
$string['outputenabled'] = 'Output enabled';
$string['outputnotavailable'] = 'Not available';
$string['outputnotconfigured'] = 'Not configured';
$string['page-message-x'] = 'Any message pages';
$string['permitted'] = 'Permitted';
$string['processorsettings'] = 'Processor settings';
$string['provider'] = 'Provider'; // Totara string.
$string['removecontact'] = 'Remove contact';
$string['removecoursefilter'] = 'Remove filter for course {$a}';
$string['removefromyourcontacts'] = 'Remove from your contacts';
$string['requiresconfiguration'] = 'Requires configuration';
$string['searchcombined'] = 'Search people and messages';
$string['searchforuser'] = 'Search for a user';
$string['searchforuserorcourse'] = 'Search for a user or course';
$string['searchmessages'] = 'Search messages';
$string['seeall'] = 'See all';
$string['selectmessagestodelete'] = 'Select messages to delete';
$string['selectnotificationtoview'] = 'Select from the list of notifications on the side to view more details';
$string['send'] = 'Send';
$string['sendingvia'] = 'Sending "{$a->provider}" via "{$a->processor}"';
$string['sendingviawhen'] = 'Sending "{$a->provider}" via "{$a->processor}" when {$a->state}';
$string['sendmessage'] = 'Send message';
$string['sendmessageto'] = 'Send message to {$a}';
$string['sendmessagetopopup'] = 'Send message to {$a} - new window';
$string['sendnotallowed'] = 'You are not allowed to send messages to this user'; // Totara: displayed when user cannot for some reason send message to user
$string['settings'] = 'Settings';
$string['showmessagewindownonew'] = 'Show message window with no new messages';
$string['showmessagewindowwithcount'] = 'Show message window with {$a} new messages';
$string['shownotificationwindownonew'] = 'Show notification window with no new notifications';
$string['shownotificationwindowwithcount'] = 'Show notification window with {$a} new notifications';
$string['togglemessagemenu'] = 'Toggle messages menu';
$string['togglenotificationmenu'] = 'Toggle notifications menu';
$string['touserdoesntexist'] = 'You can not send a message to a user id ({$a}) that doesn\'t exist';
$string['unblockcontact'] = 'Unblock contact';
$string['unreadnewmessage'] = 'New message from {$a}';
$string['unreadnotification'] = 'Unread notification: {$a}';
$string['userdataitemcontacts'] = 'Contacts';
$string['userdataiteminstant_messages_received'] = 'Received messages';
$string['userdataiteminstant_messages_sent'] = 'Sent messages';
$string['userdataitemnotification_messages'] = 'Notifications';
$string['userisblockingyou'] = 'This user has blocked you from sending messages to them';
$string['userisblockingyounoncontact'] = '{$a} only accepts messages from their contacts.';
$string['viewfullnotification'] = 'View full notification';
$string['viewinganotherusersmessagearea'] = 'You are viewing another user\'s message area.';
$string['viewmessageswith'] = 'View messages with {$a}';
$string['viewnotificationresource'] = 'Go to: {$a}';
$string['viewunreadmessageswith'] = 'View unread messages with {$a}';
$string['writeamessage'] = 'Write a message...';
$string['you'] = 'You: {$a}';

/**
 * Deprecated since Moodle 3.2.
 */
$string['context'] = 'context';
$string['discussion'] = 'Discussion';
$string['emptysearchstring'] = 'You must search for something';
$string['formorethan'] = 'For more than';
$string['keywords'] = 'Keywords';
$string['messagehistory'] = 'Message history';
$string['newsearch'] = 'New search';
$string['nosearchresults'] = 'There were no results from your search';
$string['onlymycourses'] = 'Only in my courses';
$string['pagerefreshes'] = 'This page refreshes automatically every {$a} seconds';
$string['recent'] = 'Recent';
$string['savemysettings'] = 'Save my settings';
$string['search'] = 'Search';
$string['settingssaved'] = 'Your settings have been saved';
$string['strftimedaydatetime'] = '%A, %d %B %Y, %I:%M %p';
$string['timenosee'] = 'Minutes since I was last seen online';
$string['timesent'] = 'Time sent';
$string['userssearchresults'] = 'Users found: {$a}';
