<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Vernon Denny <vernon.denny@totaralearning.com>
 * @package ml_recommender
 */

namespace ml_recommender\local\import;

use coding_exception;
use Iterator;
use ml_recommender\local\unique_id;

/**
 *
 * Upload recommendations per user from csv generated by the python recommender system.
 *
 * @package ml_recommender
 * @deprecated since Totara 17.0 ml_recommender importer has been deprecated.
 */
abstract class import {

    /**
     * Name of csv upload file.
     *
     * @var string
     */
    public $filepath = '';

    /**
     * File handle of csv file.
     *
     * @var string
     */
    public $csvhandle = 0;

    /**
     * Get import name
     * Typically used for csv file naming
     * @return string
     */
    abstract public function get_name(): string;

    /**
     * Process the input csv file.
     * @param Iterator $reader
     * @param int       $time Time of import (current time is used by default)
     */
    abstract public function import(Iterator $reader, int $time = 0): void;

    /**
     * Remove old recommendations
     * @param int $timestamp
     */
    abstract public function clean(int $timestamp);

    /**
     * Convert concatenated unique id into component name and item id.
     *
     * @param string $unique_id
     * @return array
     *
     * @deprecated since Totara 13.3
     */
    protected function get_component_id(string $unique_id): array {
        debugging(
            'The function ml_recommender\\local\\import::get_component_id has been deprecated. ' .
            'Please use ml_recommender\\local\\unique_id::normalise_unique_id instead',
            DEBUG_DEVELOPER
        );

        return unique_id::normalise_unique_id($unique_id);
    }
}
