<?php
/*
 * This file is part of Totara Learn
 *
 * Copyright (C) 2018 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Oleg Demeshev <oleg.demeshev@totaralearning.com>
 * @package mod_facetoface
 */

namespace mod_facetoface\rb\traits;

defined('MOODLE_INTERNAL') || die();

trait post_config {

    /**
     * Add report audience visibility config operations.
     *
     * @param \reportbuilder $report
     * @throws \moodle_exception
     */
    protected function add_audiencevisibility_config(\reportbuilder &$report) {
        // Only apply these hardcoded visibility checks if it hasn't been disabled for this report
        $disabled_checks = \reportbuilder::get_setting($report->get_id(), 'disable_hardcoded_visibility', 'disable');
        if ($report->src->has_hardcoded_visibility && $disabled_checks) {
            return;
        }

        $userid = $report->reportfor;
        if (isset($report->embedobj->embeddedparams['userid'])) {
            $userid = $report->embedobj->embeddedparams['userid'];
        }
        $report->set_post_config_restrictions($report->post_config_visibility_where('course', 'course', $userid));
    }
}