<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Aaron Machin <aaron.machin@totara.com>
 * @package mod_facetoface
 */

namespace mod_facetoface\webapi\field_mapping;

/**
 * Defines field mapping for GraphQL fields to internal column name definitions.
 */
class event {

    /**
     * Defines the mapping between GraphQL field names and the internal column names
     *
     * @return array associative array of the GraphQL fields as keys and the internal column names as values
     */
    public static function get_graphql_to_internal_column_mapping(): array {
        return [
            'seminar_id' => 'facetoface',
            'seats_total' => 'capacity',
            'allow_cancellations' => 'allowcancellations',
            'cancellation_cutoff' => 'cancellationcutoff',
            'cost_normal' => 'normalcost',
            'cost_discount' => 'discountcost',
            'registration_time_start' => 'registrationtimestart',
            'registration_time_end' => 'registrationtimefinish',
        ];
    }
}
