<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Valerii Kuznetsov <valerii.kuznetsov@totaralms.com>
 * @package mod_facetoface
 */

defined('MOODLE_INTERNAL') || die();

global $CFG;

require_once($CFG->dirroot . '/mod/facetoface/rb_sources/rb_facetoface_base_source.php');
require_once($CFG->dirroot . '/totara/customfield/field/location/define.class.php');

/**
 * Seminar Room Assignments
 */
class rb_source_facetoface_room_assignments extends rb_facetoface_base_source {
    use \core_course\rb\source\report_trait;
    use \mod_facetoface\rb\traits\rooms;
    use \mod_facetoface\rb\traits\assets;
    use \mod_facetoface\rb\traits\facilitator;
    use \totara_reportbuilder\rb\source\report_trait;

    public function __construct($groupid, rb_global_restriction_set $globalrestrictionset = null) {
        if ($groupid instanceof rb_global_restriction_set) {
            throw new coding_exception('Wrong parameter orders detected during report source instantiation.');
        }
        // Remember the active global restriction set.
        $this->globalrestrictionset = $globalrestrictionset;

        // Global report restrictions are applied in define_joinlist() method.

        $this->base = '{facetoface_room_dates}';
        $this->sourcetitle = get_string('sourcetitle', 'rb_source_facetoface_room_assignments');
        $this->sourcesummary = get_string('sourcesummary', 'rb_source_facetoface_room_assignments');
        $this->sourcelabel = get_string('sourcelabel', 'rb_source_facetoface_room_assignments');
        $this->joinlist = $this->define_joinlist();
        $this->columnoptions = $this->define_columnoptions();
        $this->filteroptions = $this->define_filteroptions();
        $this->contentoptions = $this->define_contentoptions();
        $this->defaultcolumns = $this->define_defaultcolumns();
        $this->requiredcolumns = $this->define_requiredcolumns();
        $this->paramoptions = $this->define_paramoptions();
        $this->defaultfilters = $this->define_defaultfilters();
        $this->usedcomponents[] = 'totara_cohort';
        $this->add_customfields();

        parent::__construct();
    }

    protected function define_joinlist() {

        $joinlist = array();
        $joinlist[] = new rb_join(
            'sessiondate',
            'LEFT',
            '{facetoface_sessions_dates}',
            '(sessiondate.id = base.sessionsdateid)',
            REPORT_BUILDER_RELATION_ONE_TO_MANY
        );

        $joinlist[] = new rb_join(
            'room',
            'LEFT',
            '{facetoface_room}',
            '(room.id = base.roomid)',
            REPORT_BUILDER_RELATION_ONE_TO_MANY,
            'sessiondate'
        );

        $this->add_assets_to_join_list($joinlist, 'sessiondate');
        $this->add_facilitators_to_join_list($joinlist, 'sessiondate');

        $this->add_session_common_to_joinlist($joinlist, 'sessiondate');
        $this->add_session_status_to_joinlist($joinlist);
        $this->add_core_course_tables($joinlist, 'facetoface', 'course');
        $this->add_context_tables($joinlist, 'course', 'id', CONTEXT_COURSE, 'INNER');

        return $joinlist;
    }

    protected function define_columnoptions() {
        $columnoptions = array();

        $this->add_core_course_columns($columnoptions);
        $this->add_facetoface_common_to_columns($columnoptions);
        $this->add_assets_fields_to_columns($columnoptions, 'asset', false);
        $this->add_rooms_fields_to_columns($columnoptions, 'room', false, 'sessiondate');
        $this->add_facilitators_fields_to_columns($columnoptions, 'facilitator', false);
        $this->add_session_common_to_columns($columnoptions, 'sessiondate');
        $this->add_session_status_to_columns($columnoptions, 'sessiondate');

        return $columnoptions;
    }

    protected function define_filteroptions() {
        $filteroptions = array();

        $this->add_core_course_filters($filteroptions);

        $filteroptions[] = new rb_filter_option(
            'facetoface',
            'facetofaceid',
            get_string('ftfid', 'rb_source_facetoface_room_assignments'),
            'number'
        );

        $filteroptions[] = new rb_filter_option(
            'facetoface',
            'name',
            get_string('ftfname', 'rb_source_facetoface_sessions'),
            'text'
        );

        $this->add_rooms_fields_to_filters($filteroptions);
        $filteroptions[] = new rb_filter_option(
            'room',
            'roomavailable',
            get_string('roomavailable', 'rb_source_facetoface_rooms'),
            'f2f_roomavailable',
            array(),
            'room.id',
            array('room')
        );

        $filteroptions[] = new rb_filter_option(
            'date',
            'sessionstartdate',
            get_string('sessstartdatetime', 'rb_source_facetoface_room_assignments'),
            'date'
        );

        $filteroptions[] = new rb_filter_option(
            'date',
            'sessionfinishdate',
            get_string('sessfinishdatetime', 'rb_source_facetoface_room_assignments'),
            'date'
        );

        return $filteroptions;
    }

    protected function define_paramoptions() {
        $paramoptions = array(
            new rb_param_option(
                'roomid',
                'room.id',
                'room'
            )
        );

        return $paramoptions;
    }

    protected function define_contentoptions() {
        $contentoptions = array(
            new rb_content_option(
                'date',
                get_string('thedate', 'rb_source_facetoface_sessions'),
                'sessiondate.timestart'
            )
        );

        $contentoptions[] = new rb_content_option(
            'course_visibility',
            get_string('course_visibility', 'totara_reportbuilder'),
            'facetoface.course',
            ['ctx', 'course', 'facetoface']
        );

        return $contentoptions;
    }

    protected function define_defaultcolumns() {
        $defaultcolumns = array(
            array(
                'type' => 'course',
                'value' => 'courselink',
                'rowheader' => true,
            ),
            array(
                'type' => 'facetoface',
                'value' => 'namelink'
            ),
            array(
                'type' => 'room',
                'value' => 'name'
            ),
            array(
                'type' => 'room',
                'value' => 'capacity'
            ),
            array(
                'type' => 'date',
                'value' => 'sessionstartdate'
            )
        );

        return $defaultcolumns;
    }

    protected function define_defaultfilters() {
        $defaultfilters = array(
            array(
                'type' => 'course',
                'value' => 'name'
            ),
            array(
                'type' => 'facetoface',
                'value' => 'name'
            ),
            array(
                'type' => 'date',
                'value' => 'sessionstartdate'
            ),
            array(
                'type' => 'room',
                'value' => 'name'
            ),
        );

        return $defaultfilters;
    }

    protected function add_customfields() {
        $this->add_totara_customfield_component(
            'facetoface_room',
            'room',
            'facetofaceroomid',
            $this->joinlist,
            $this->columnoptions,
            $this->filteroptions
        );

        $this->add_totara_customfield_component(
            'facetoface_session',
            'sessions',
            'facetofacesessionid',
            $this->joinlist,
            $this->columnoptions,
            $this->filteroptions);
    }

    public function global_restrictions_supported() {
        return true;
    }
}
