<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

require_once(__DIR__ . '/../../../../lib/behat/behat_base.php');

/**
 * Step definition for report_log behat tests.
 *
 * @package    report_log
 * @category   test
 * @copyright  2025 Laurent David <laurent.david@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class behat_report_log extends behat_base {
    /**
     * Convert page names to URLs for steps like 'When I am on the "[identifier]" "[page type]" page'.
     *
     *  Recognised page names are:
     *  | pagetype     | name meaning | description                  |
     *  | logs         | Course name  | The course report logs page  |
     *
     * @When /^I am on the "(?P<coursefullname_string>(?:[^"]|\\")*)" "logs" page$/
     *
     * @param string $coursefullname identifies the particular page, e.g. 'Course 1'.
     * @throws behat_pending_js_exception
     */
    public function i_am_on_the_logs_page(string $coursefullname): void {
        global $DB;
        \behat_hooks::set_step_readonly(false);

        $courseid = $DB->get_field("course", 'id', array("fullname" => $coursefullname), MUST_EXIST);
        $url = new moodle_url('/report/log/index.php', ['id' => $courseid]);
        $this->getSession()->visit($this->locate_path($url->out_as_local_url(false)));
        $this->wait_for_pending_js();
        $this->execute('behat_general::i_ignore_exception_in_log', ['Access denied']);
    }
}
