<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Maria Torres <maria.torres@totaralms.com>
 * @package totara_core
 */

use totara_program\message\message_manager;
use totara_program\task\send_messages_task;

global $CFG;
require_once($CFG->dirroot . '/totara/reportbuilder/tests/reportcache_advanced_testcase.php');

/**
 * Class totara_core_messaging_testcase
 *
 * @deprecated Since Totara 18.0
 */
class totara_core_messaging_test extends \core_phpunit\testcase {

    /** @var \totara_plan\testing\generator $plangenerator */
    private $plangenerator = null;

    /** @var \totara_program\testing\generator $programgenerator */
    private $programgenerator = null;

    private $user1, $user2, $user3, $manager1, $manager2;

    protected function tearDown(): void {
        $this->plangenerator = null;
        $this->programgenerator = null;
        $this->user1 = $this->user2 = $this->user3 = null;
        $this->manager1 = $this->manager2 = null;

        parent::tearDown();
    }

    public function setUp(): void {
        parent::setup();

        $this->programgenerator = $this->getDataGenerator()->get_plugin_generator('totara_program');
        $this->plangenerator = $this->getDataGenerator()->get_plugin_generator('totara_plan');

        // Create some users to work with.
        $this->user1 = $this->getDataGenerator()->create_user(array('email' => 'user1@example.com'));
        $this->user2 = $this->getDataGenerator()->create_user(array('email' => 'user2@example.com'));
        $this->user3 = $this->getDataGenerator()->create_user(array('email' => 'user3@example.com'));

        $this->manager1 = $this->getDataGenerator()->create_user(array('email' => 'manager1@example.com'));
        $this->manager2 = $this->getDataGenerator()->create_user(array('email' => 'manager2@example.com'));

        // Assign managers to students.
        $manager1ja = \totara_job\job_assignment::create_default($this->manager1->id);
        $manager2ja = \totara_job\job_assignment::create_default($this->manager2->id);
        \totara_job\job_assignment::create_default($this->user1->id, array('managerjaid' => $manager1ja->id));
        \totara_job\job_assignment::create_default($this->user2->id, array('managerjaid' => $manager2ja->id));
        \totara_job\job_assignment::create_default($this->user3->id, array('managerjaid' => $manager1ja->id));
    }

    /**
     * Test from user is correctly set according to settings.
     */
    public function test_messages_from_no_reply() {
        global $USER, $CFG;
        require_once($CFG->dirroot . '/totara/program/program_message.class.php');
        $this->setAdminUser();

        $noreplyaddress = 'no-reply@example.com';

        // Set the no reply address.
        set_config('noreplyaddress', $noreplyaddress);

        $sink = $this->redirectEmails();

        // Add enrolment message in Programs.
        $program1 = $this->programgenerator->create_program();

        $program_message_manager = message_manager::get_program_messages_manager($program1->id);
        $program_message_manager->add_message(message_manager::MESSAGETYPE_ENROLMENT);
        $program_message_manager->save_messages();
        message_manager::reset_cache();

        $this->programgenerator->assign_program($program1->id, array($this->user1->id, $this->user2->id));

        $this->waitForSecond(); // Messages are only sent if they were created before "now", so we need to wait one second.

        // Attempt to send any program messages.
        $task = new send_messages_task();
        ob_start(); // Start a buffer to catch all the mtraces in the task.
        $task->execute();
        ob_end_clean();

        // Check user from.
        $fromuser = $USER;
        $expectedname = fullname($fromuser);
        $expectedemail = $noreplyaddress;
        $checkformat = '%s (%s)';
        $expected = sprintf($checkformat, $expectedname, $expectedemail);

        // Check that that one email was sent and the from adress corresponds to the noreply address.
        $emails = $sink->get_messages();
        $this->assertCount(2, $emails);
        foreach ($emails as $email) {
            $actual = sprintf($checkformat, $email->fromname, $email->from);
            $this->assertEquals($expected, $actual);
        }
        $sink->clear();

        // Messages in Learning plan.
        $sink = $this->redirectEmails();
        $plan = $this->plangenerator->create_learning_plan(array('userid' => $this->user1->id));
        $this->plangenerator->create_learning_plan_objective($plan->id, $this->user1->id, null);

        // Check emails.
        $emails = $sink->get_messages();
        $this->assertCount(1, $emails);
        foreach ($emails as $email) {
            $actual = sprintf($checkformat, $email->fromname, $email->from);
            $this->assertEquals($expected, $actual);
        }
        $sink->clear();
    }
}
