<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Valerii Kuznetsov <valerii.kuznetsov@totaralms.com>
 * @package totara_dashboard
 */

namespace totara_dashboard\totara\menu;

use totara_core\advanced_feature;

class dashboard extends \totara_core\totara\menu\item {

    protected function get_default_title() {
        return get_string('dashboard', 'totara_dashboard');
    }

    protected function get_default_url() {
        return '/totara/dashboard/index.php';
    }

    public function get_default_sortorder() {
        return 20000;
    }

    protected function check_visibility() {
        global $CFG, $USER;

        if (!isloggedin()) {
            return false;
        }

        static $cache = null;
        if (isset($cache) && !PHPUNIT_TEST) {
            return $cache;
        }

        require_once($CFG->dirroot . '/totara/dashboard/lib.php');
        if (count(\totara_dashboard::get_user_dashboards($USER->id))) {
            $cache = true;
        } else {
            $cache = false;
        }

        return $cache;
    }

    /**
     * Is this menu item completely disabled?
     *
     * @return bool
     */
    public function is_disabled() {
        return advanced_feature::is_disabled('totaradashboard');
    }

    protected function get_default_parent() {
        return '\totara_core\totara\menu\unused';
    }
}
