<?php
/*
 * This file is part of Totara Perform
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Simon Coggins <simon.coggins@totaralearning.com>
 * @package totara_evidence
 */

namespace totara_evidence;

use core\plugininfo\totara;
use totara_core\advanced_feature;
use totara_evidence\entity\evidence_item;
use totara_evidence\entity\evidence_type;

defined('MOODLE_INTERNAL') || die();

class plugininfo extends totara {
    public function get_usage_for_registration_data() {
        $data = array();
        $data['numitems'] = evidence_item::repository()->count();
        // Exclude system types.
        $data['numtypes'] = evidence_type::repository()->filter_by_standard_location()->count();
        $data['evidenceenabled'] = (int)advanced_feature::is_enabled('evidence');

        return $data;
    }
}
