<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Ning Zhou <ning.zhou@totara.com>
 * @package core
 */

namespace totara_form\form\validator;

use totara_form\element_validator;

class password_maxlength extends element_validator {

    /**
     * HTML5 'maxlength' attribute validator constructor.
     */
    public function __construct() {
        parent::__construct(null);
    }

    /**
     * Validate the element.
     *
     * @return void adds errors to element
     */
    public function validate() {
        if ($this->element->is_frozen()) {
            // There is no point in validating frozen elements because all they can do
            // is to return current data that user cannot change.
            return;
        }

        $name = $this->element->get_name();
        $data = $this->element->get_data();

        if (is_array($data[$name])) {
            // This is wrong!
            debugging('maxlength attribute cannot work for elements that return array data!', DEBUG_DEVELOPER);
            return;
        }

        $value = (string)$data[$name];
        if (\core_text::strlen($value) <= AUTH_PASSWORD_MAXLENGTH) {
            return;
        }

        // Note: this should be handled by poly-fill!
        $this->element->add_error(get_string('maximumchars', 'core', AUTH_PASSWORD_MAXLENGTH));
    }
}