<?php
/*
 * This file is part of Totara LMS
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Totara navigation edit page.
 *
 * @package    totara
 * @subpackage navigation
 * @author     Oleg Demeshev <oleg.demeshev@totaralms.com>
 */

namespace totara_hierarchy\totara\menu;

use moodle_url;
use totara_core\advanced_feature;
use perform_goal\settings_helper;

class mygoals extends \totara_core\totara\menu\item {

    protected const BASE_URL = '/totara/hierarchy/prefix/goal/mygoals.php';
    protected const PERSONAL_GOAL_BASE_URL = '/totara/hierarchy/prefix/goal/item/edit_personal.php';

    /**
     * @param array $params
     * @return moodle_url
     */
    public static function get_base_url(array $params = []): moodle_url {
        return new moodle_url(self::BASE_URL, $params);
    }

    /**
     * @param array $params
     * @return moodle_url
     */
    public static function get_add_personal_goal_base_url(array $params = []): moodle_url {
        return new moodle_url(self::PERSONAL_GOAL_BASE_URL, $params);
    }

    protected function get_default_title() {
        return settings_helper::is_perform_goals_transition_mode_enabled()
            ? get_string('legacy_goals', 'totara_hierarchy')
            : get_string('goals', 'totara_hierarchy');
    }

    protected function get_default_url() {
        return self::BASE_URL;
    }

    public function get_default_sortorder() {
        return 50020;
    }

    protected function check_visibility() {
        global $CFG, $USER;

        if (!isloggedin() or isguestuser()) {
            return false;
        }

        static $cache = null;

        if (isset($cache)) {
            return $cache;
        }

        require_once($CFG->dirroot . '/totara/hierarchy/prefix/goal/lib.php');
        if (\goal::can_view_goals($USER->id)) {
            $cache = true;
        } else {
            $cache = false;
        }
        return $cache;
    }

    /**
     * Is this menu item completely disabled?
     *
     * @return bool
     */
    public function is_disabled() {
        return advanced_feature::is_disabled('goals');
    }

    protected function get_default_parent() {
        return '\totara_core\totara\menu\perform';
    }

    public function get_incompatible_preset_rules(): array {
        return ['can_view_my_goals'];
    }
}
