<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Johannes Cilliers <johannes.cilliers@totaralearning.com>
 * @package totara_hierarchy
 */

namespace totara_hierarchy\webapi\resolver\query;

use core\entity\tenant;
use core\webapi\execution_context;
use core\webapi\middleware\require_advanced_feature;
use core\webapi\query_resolver;
use core\webapi\middleware\require_login;

class organisation_frameworks extends query_resolver {

    /**
     * {@inheritdoc}
     */
    public static function resolve(array $args, execution_context $ec) {
        global $CFG, $USER;

        $context = \context_user::instance($USER->id);
        if ($context->tenantid) {
            $tenant = new tenant($context->tenantid);
            $context = \context_coursecat::instance($tenant->categoryid);
        }
        require_capability('totara/hierarchy:vieworganisationframeworks', $context);

        $ec->set_relevant_context($context);

        require_once($CFG->dirroot . '/totara/hierarchy/lib.php');

        $hierarchy = new \hierarchy();
        $hierarchy->shortprefix = 'org';
        return $hierarchy->get_frameworks();
    }

    /**
     * {@inheritdoc}
     */
    public static function get_middleware(): array {
        return [
            new require_login(),
            new require_advanced_feature('organisations'),
        ];
    }
}