<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @author Jonathan Newman <jonathan.newman@catalyst.net.nz>
 * @package totara
 * @subpackage totara_core
 */

$string['achieved'] = 'Achieved';
$string['addassignedcompetencies'] = 'Assign competencies';
$string['addassignedcompetencytemplates'] = 'Assign competency templates';
$string['addassignedgoals'] = 'Assign goals';
$string['addassignedgoaltemplates'] = 'Assign goal templates';
$string['addaudience'] = 'Add audience';
$string['addcohorts'] = 'Add audience(s)';
$string['addcompanygoaltype'] = 'Add a new company goal type';
$string['addcompetency'] = 'Add Competency';
$string['addcourseevidencetocompetencies'] = 'Add course evidence to competencies';
$string['addcourseevidencetocompetency'] = 'Add course evidence to competency';
$string['addcourseevidencetogoal'] = 'Add course evidence to goal';
$string['addcourseevidencetogoals'] = 'Add course evidence to goals';
$string['adddepthlevel'] = 'Add a new depth level';
$string['addedcompetency'] = 'The competency "{$a}" has been added';
$string['addedgoal'] = 'The goal "{$a}" has been added';
$string['addedorganisation'] = 'The organisation "{$a}" has been added';
$string['addedposition'] = 'The position "{$a}" has been added';
$string['addgoal'] = 'Add Goal';
$string['addgoalcompany'] = 'Add company goal';
$string['addgoalpersonal'] = 'Add personal goal';
$string['addgoals'] = 'Add Goal(s)';
$string['additionaloptions'] = 'Additional Options';
$string['addmultiplenewcompetency'] = 'Add multiple competencies';
$string['addmultiplenewgoal'] = 'Add multiple goals';
$string['addmultipleneworganisation'] = 'Add multiple organisations';
$string['addmultiplenewposition'] = 'Add multiple positions';
$string['addnewcompetency'] = 'Add new competency';
$string['addnewgoal'] = 'Add new goal';
$string['addneworganisation'] = 'Add new organisation';
$string['addnewposition'] = 'Add new position';
$string['addnewscalevalue'] = 'Add new scale value';
$string['addnewtemplate'] = 'Add new competency template';
$string['addorganisation'] = 'Add Organisation';
$string['addorganisations'] = 'Add organisation(s)';
$string['addpersonalgoaltype'] = 'Add a new personal goal type';
$string['addposition'] = 'Add Position';
$string['addpositions'] = 'Add position(s)';
$string['addscalevalue'] = 'Add scale value';
$string['addtype'] = 'Add a new type';
$string['aggregationmethod'] = 'Aggregation method';
$string['aggregationmethod1'] = 'All';
$string['aggregationmethod2'] = 'Any';
$string['aggregationmethod3'] = 'Off';
$string['aggregationmethod4'] = 'Unit';
$string['aggregationmethod5'] = 'Fraction';
$string['aggregationmethod6'] = 'Sum of weighted';
$string['aggregationmethod7'] = 'Average of weighted';
$string['aggregationmethodview'] = '{$a} aggregation method';
$string['allcompetencyscales'] = 'All competency scales';
$string['allframeworks'] = 'All frameworks';
$string['allgoalscales'] = 'All goal scales';
$string['alltypes'] = 'All types';
$string['andchildren'] = ' (and children)';
$string['appraiser'] = 'Appraiser';
$string['assign'] = 'Assign';
$string['assigncohort'] = 'Audience';
$string['assigncompetencies'] = 'Assign competencies';
$string['assigncompetency'] = 'Assign competency';
$string['assigncompetencytemplate'] = 'Assign competency template';
$string['assigncompetencytemplates'] = 'Assign competency templates';
$string['assigncoursecompletion'] = 'Assign course completion';
$string['assigncoursecompletions'] = 'Assign course completions';
$string['assigncoursecompletiontocompetencies'] = 'Assign course completion to competencies';
$string['assigncoursecompletiontocompetency'] = 'Assign course completion to competency';
$string['assigncoursecompletiontogoal'] = 'Assign course completion to goal';
$string['assigncoursecompletiontogoals'] = 'Assign course completion to goals';
$string['assigned_company_goal_adder_filter_framework'] = 'Framework';
$string['assigned_company_goal_adder_filter_name'] = 'Search';
$string['assigned_company_goal_adder_filter_title'] = 'Filter goals';
$string['assigned_company_goal_adder_filter_type'] = 'Type';
$string['assigned_company_goal_adder_label_name'] = 'Goal';
$string['assigned_company_goal_adder_label_target_date'] = 'Target date';
$string['assigned_company_goal_adder_no_items'] = 'No items to display';
$string['assigned_company_goal_adder_title'] = 'Select company goals';
$string['assigned_company_goal_adder_type'] = 'Type';
$string['assignedcompetenciesandtemplates'] = 'Assigned Competencies and Competency Templates';
$string['assignedcompetencytemplates'] = 'Assigned competency templates';
$string['assignedgoals'] = 'Assigned Goals';
$string['assignedgoalsandtemplates'] = 'Assigned Goals and Goal Templates';
$string['assignedgoaltemplates'] = 'Assigned goal templates';
$string['assignedonly'] = 'Assigned but not used';
$string['assigngoal'] = 'Assign goal';
$string['assigngoals'] = 'Assign goals';
$string['assigngoaltemplate'] = 'Assign goal template';
$string['assigngoaltemplates'] = 'Assign goal templates';
$string['assigngroup'] = 'Assign group of users';
$string['assignnewcompetency'] = 'Assign new competency';
$string['assignnewevidenceitem'] = 'Assign new evidence item';
$string['assignnewgoal'] = 'Assign new goal';
$string['assignorganisation'] = 'Organisation';
$string['assignposition'] = 'Position';
$string['assignrelatedcompetencies'] = 'Assign related competencies';
$string['assignrelatedgoals'] = 'Assign related goals';
$string['availablex'] = 'Available {$a}';
$string['bulkactions'] = 'Bulk actions';
$string['bulkaddgoalnames'] = 'Bulk Add Items';

/**
 * Same as bulkadditemnames_help except it's for the goals and without the last string: "... If you wish to have more ..."
 */
$string['bulkaddfailed'] = '<p>There was a problem adding those items to the hierarchy:</p>
<p>{$a}</p>';
$string['bulkaddgoalnames_help'] = 'Provide a list of names (one per line) to create multiple items at the same time. You can use spaces before the item names to indicate the parent-child relationships - every two spaces you include before the name indicates one level in the hierarchy.

You must ensure that the structure you create is valid, which means every item must either be at the top level (no indentation) or be below an existing item at the level above. For example, you cannot create a level 3 item unless there is already a level 2 item above it.

Note that this bulk add functionality is for use if you want to create simple items, in the same framework, with the same type, and with no additional information such as ID Numbers and Shortnames.';
$string['bulkadditemnames'] = 'Bulk Add Items';
$string['bulkadditemnames_help'] = 'Provide a list of names (one per line) to create multiple items at the same time. You can use spaces before the item names to indicate the parent-child relationships - every two spaces you include before the name indicates one level in the hierarchy.

You must ensure that the structure you create is valid, which means every item must either be at the top level (no indentation) or be below an existing item at the level above. For example, you cannot create a level 3 item unless there is already a level 2 item above it.

Note that this bulk add functionality is for use if you want to create simple items, in the same framework, with the same type, and with no additional information such as ID Numbers and Shortnames.

If you wish to have more control over defining the value of fields such as shortname or idnumber, set individual item types etc. you should use the HR Import tool instead.';
$string['bulkaddnoitems'] = 'No items found';
$string['bulkaddparenterror'] = 'Could not locate parent for item \'{$a}\'. Please check the number of spaces before your item names and ensure the structure is correct - click the help icon for more details on the format.';
$string['bulkaddsuccess'] = '{$a} items were successfully added to the hierarchy';
$string['bulkdeletecompetency'] = 'Bulk delete competencies';
$string['bulkdeletegoal'] = 'Bulk delete goals';
$string['bulkdeleteorganisation'] = 'Bulk delete organisations';
$string['bulkdeleteposition'] = 'Bulk delete positions';
$string['bulkmovecompetency'] = 'Bulk move competencies';
$string['bulkmovegoal'] = 'Bulk move goals';
$string['bulkmoveorganisation'] = 'Bulk move organisations';
$string['bulkmoveposition'] = 'Bulk move positions';
$string['bulktypechanges'] = 'Bulk re-classification';
$string['bulktypechangesdesc'] = 'Reclassify of all items from the type: ';
$string['cancelwithoutassigning'] = 'Cancel without assigning';
$string['cannotupdatedisplaysettings'] = 'Could not update display settings';
$string['changeto'] = 'Change to';
$string['changetype'] = 'Change type';
$string['child'] = 'child';
$string['children'] = 'children';
$string['choosecohort'] = 'Choose audience';
$string['chooseevidencetype'] = 'Choose an evidence type';
$string['choosemanager'] = 'Choose manager';
$string['chooseorganisation'] = 'Choose organisation';
$string['chooseposition'] = 'Choose position';
$string['choosewhattodowithdata'] = 'Existing custom field data may be either deleted or migrated to other custom fields. Migrated data is not validated, you may need to verify and manually fix affected items.

Choose what you would like to do with the custom field data:';
$string['clearsearch'] = 'Clear search';
$string['clearselection'] = 'Clear selection';
$string['clickfornonjsform'] = 'Click here for a non-javascript version of this form';
$string['clicktoassign'] = 'Click the assign button to select a competency.';
$string['clicktoassigngoal'] = 'Click the assign button to select a goal.';
$string['clicktoassigntemplate'] = 'Click the assign button to select a competency template.';
$string['clicktoviewchildren'] = 'Click competency name to view child competencies (if present).';
$string['clicktoviewchildrengoal'] = 'Click goal name to view child goals (if present).';
$string['cohortmembercount'] = 'Number of learners';
$string['cohortname'] = 'Audience name';
$string['cohortnotfound'] = 'Audience does not exist';
$string['cohortnotselected'] = 'No audiences selected';
$string['cohorttypedynamic'] = 'Dynamic';
$string['cohorttypeset'] = 'Set';
$string['companygoal'] = 'Company goal';
$string['companygoal_generic_display_name'] = 'goal';
$string['companygoal_legacy'] = 'Legacy company goal';
$string['companygoaldetails'] = 'View Goal Frameworks';
$string['companygoals'] = 'Company goals';
$string['competencies'] = 'Competencies';
$string['competenciesdisabled'] = 'Competencies are not enabled on this site';
$string['competenciesusedincourse'] = 'Competencies used in course';
$string['competenctscaleoutoforderexist'] = 'There are scales with non-proficient values that are set higher than proficient ones. Scale values should be ordered from most proficient to least proficient – please adjust the proficiency setting on affected scale values to reflect this.';
$string['competenctscaleoutoforderthis'] = 'This scale has non-proficient values that are set higher than proficient ones. Scale values should be ordered from most proficient to least proficient – please adjust the proficiency setting on affected scale values to reflect this.';
$string['competency'] = 'Competency';
$string['competency_back_to_competency_page'] = '« Back to Competency page';
$string['competency_title'] = '{$a->framework} - {$a->fullname}';
$string['competencyaddedframework'] = 'The competency framework "{$a}" has been added';
$string['competencyaddnew'] = 'Add a new competency';
$string['competencyaddnewframework'] = 'Add new competency framework';
$string['competencyaggregationmethod'] = 'Aggregation Method';
$string['competencyaggregationmethod_help'] = 'The aggregation method sets how the system will calculate the competency achievement.

If the aggregation method is set to **All** then all the child competencies will have to be achieved for the parent competency to be declared achieved.

If the aggregation method is set to **Any** then only one of the child competencies needs to be met to successfully achieve the parent competency.

If the aggregation method is set to **Off** then automatic achievement will be deactivated for this competency. (It may still be marked achieved manually.)';
$string['competencyassignavailability'] = 'Non-admin assignment availability';
$string['competencyassignavailability_help'] = 'By default, this competency may only be assigned via the admin interface. However, if non-admin user types are selected here, it will be available for direct assignment to a user via their competency profile (by either a user with permission to assign to themselves, or another user who has permission to assign to them).';
$string['competencyassignavailabilityother'] = 'Users who may assign to others';
$string['competencyassignavailabilityothersimple'] = 'Other users';
$string['competencyassignavailabilityself'] = 'Users who may self-assign';
$string['competencyassignavailabilityselfsimple'] = 'Self';
$string['competencyassigndeletecheck'] = 'Are you sure you would like to remove this competency assignment?';
$string['competencybacktoallframeworks'] = 'Back to all competency frameworks';
$string['competencycreatetype'] = 'The competency type "{$a}" has been created';
$string['competencycustomfields'] = 'Custom fields';
$string['competencydeletedframework'] = 'The competency framework "{$a}" and its data have been completely deleted.';
$string['competencydeletedtype'] = 'The competency type "{$a}" has been completely deleted.';
$string['competencydepthcustomfields'] = 'Competency depth custom fields';
$string['competencydepthlevelview'] = 'Competency depth level view';
$string['competencydescription'] = 'Description';
$string['competencydescription_help'] = 'A free-text field for providing more details about this competency. This data is displayed when viewing the hierarchy listing, on the individual competency page, on competencies when assigning them, and on users’ competency profiles.';
$string['competencydetails'] = 'Competency Details';
$string['competencydetails_competencyname'] = 'Competency Details - {$a}';
$string['competencyeditframework'] = 'Edit competency framework';
$string['competencyerror:createtype'] = 'Error creating competency type "{$a}"';
$string['competencyerror:deletedframework'] = 'Error deleting competency framework "{$a}" and its data.';
$string['competencyerror:deletedtype'] = 'Error deleting competency type "{$a}".';
$string['competencyerror:dialognotreeitems'] = 'No competencies in this framework';
$string['competencyerror:updatetype'] = 'Error updating competency type "{$a}"';
$string['competencyevidence'] = 'Competency evidence';
$string['competencyevidenceassessmenttype'] = 'Assessment Type';
$string['competencyevidenceassessmenttype_help'] = 'The assessment type field is a free text field for any additional information about the assessment of this competency. Contents may vary and the field is optional.';
$string['competencyevidenceassessor'] = 'Evidence Assessor';
$string['competencyevidenceassessor_help'] = 'You can select an assessor, which is a user who assessed that the current user proficient in the current competency. Assessor is an optional field so leave the pulldown on the **Select an assessor...** option if you do not want to assign an assessor.

The pulldown lists all Totara users who are in the assessor role. If the user you wish to add is missing or no options are shown then you will need to ask an administrator to add that user to the assessor role.';
$string['competencyevidenceassessorname'] = 'Evidence Assessor Name';
$string['competencyevidenceassessorname_help'] = 'The Assessor Name field refers to the name of the organisation that did the assessment of the user for this competency. It is an optional field so can be left blank.';
$string['competencyevidencecompetency'] = 'Evidence Competency';
$string['competencyevidencecompetency_help'] = 'The competency to be assigned to the user. If you are editing an existing item of competency evidence, this cannot be changed. You can however create a new item of competency evidence (if you have permission to do so) by visiting the user\'s My Records page and clicking the **Add competency evidence** button.

When creating a new competency evidence item you can choose between adding evidence for an existing competency or creating a new competency. If you choose **Select a competency** a popup will allow you to pick from the existing competencies. If you choose **Create a new competency** a form will appear where you can choose a framework and define the new competency.

Note that you cannot create two competency evidence items that refer to the same user and competency. If you try to do this you will be provided with a link to edit the original record or choose a different competency.';
$string['competencyevidencecount'] = 'Linked courses';
$string['competencyevidenceorganisation'] = 'Evidence Organisation';
$string['competencyevidenceorganisation_help'] = 'This option records the organisation the user was in at the time they completed the item of competency evidence. In most cases this will be the same as the user\'s current organisation. As users change organisation over time this allows a record to be kept of where they were in at time of completion. This is an optional field.';
$string['competencyevidenceposition'] = 'Evidence Position';
$string['competencyevidenceposition_help'] = 'This option records the position the user was in at the time they completed the item of competency evidence. In most cases this will be the same as the user\'s current role. As users change roles over time this allows a record to be kept of the role they were in at time of completion. This is an optional field.';
$string['competencyevidenceproficiency_help'] = 'This field records whether or not the user is deemed to be proficient at the assigned competency. The options that appear in the pulldown depend on the competency scale assigned to the chosen competency, so the competency must be selected before this field can be modified. A proficiency must be set to add or update a competency evidence record.';
$string['competencyevidenceuser'] = 'Competency Evidence User';
$string['competencyevidenceuser_help'] = 'The user whom this item of competency evidence is assigned. It is not possible to reassign an item of competency evidence to a different user. If you have sufficient permissions you can create a new item of competency evidence for a user by clicking the button on the user\'s My Records page. You can also edit evidence for that user by finding the record in the report and clicking the edit icon.';
$string['competencyfeatureplural'] = 'Competencies';
$string['competencyframework'] = 'Competency framework';
$string['competencyframework_help'] = 'Competencies are grouped or categorised and stored in a **Competency framework**. Once a competency framework is set up, competencies can be set up within it.';
$string['competencyframeworkdescription'] = 'Description';
$string['competencyframeworkdescription_help'] = 'The framework description is a text field for storing additional information about the framework. It is displayed on the manage competencies page, just above the table of competencies.';
$string['competencyframeworkfullname'] = 'Full Name';
$string['competencyframeworkfullname_help'] = 'The framework full name is the complete title of the framework.';
$string['competencyframeworkgeneral'] = 'Competency Framework';
$string['competencyframeworkgeneral_help'] = '**Competency Frameworks** are set up to hold the skills, knowledge and behavioural competencies you expect staff to achieve.

Competencies may be grouped under different kinds of framework. For example, one framework could hold all industry national competency standards (taken from an industry body), while another framework could hold specific competencies set up in-house.

Before you set up a competency framework you must have a **Competency Scale** set up.';
$string['competencyframeworkidnumber'] = 'ID Number';
$string['competencyframeworkidnumber_help'] = 'The framework ID number is a unique number that can be used to represent the framework.';
$string['competencyframeworkmanage'] = 'Manage frameworks';
$string['competencyframeworks'] = 'Competency frameworks';
$string['competencyframeworks_help'] = '**Competency Frameworks** are set up to hold the skills, knowledge and behavioural competencies you expect staff to achieve.

Competencies may be grouped under different kinds of framework. For example, one framework could hold all industry national competency standards (taken from an industry body), while another framework could hold specific competencies set up in-house.

Before you set up a competency framework you must have a **Competency Scale** set up.';
$string['competencyframeworkscale'] = 'Competency Framework Scale';
$string['competencyframeworkscale_help'] = 'Competency scales enable you to define the criteria by which a competency can be measured. For example, a scale might have three values; competent, competent with supervision, not competent.The first step is to use the **Competency scales** option to add a new scale, then to add the scale values which are used to define a learner\'s progress for a competency. You can add as many values as you wish. Note also the Default and Proficient value settings.';
$string['competencyframeworkshortname'] = 'Competency Framework shortname';
$string['competencyframeworkshortname_help'] = 'The framework short name is a quick reference to the framework\'s full name and can be used for display purposes.';
$string['competencyframeworkview'] = 'View framework';
$string['competencyfullname'] = 'Competency full name';
$string['competencyfullname_help'] = 'Competency full name is the complete title of the competency.';
$string['competencyidnumber'] = 'Competency ID number';
$string['competencyidnumber_help'] = 'Competency ID number is a unique number used to represent the competency.';
$string['competencymanage'] = 'Manage competencies';
$string['competencymissingname'] = 'Missing competency name';
$string['competencymissingnameframework'] = 'Missing competency framework name';
$string['competencymissingnametype'] = 'Missing competency type name';
$string['competencymissingshortname'] = 'Missing competency short name';
$string['competencynoframeworks'] = 'No competency frameworks defined';
$string['competencynoframeworkssetup'] = 'There are no competency frameworks setup for this site.';
$string['competencynotypes'] = 'No competency types';
$string['competencyparent'] = 'Parent';
$string['competencyparent_help'] = '**Parent competency** allows you to manage parent/child relationships between competencies.

Select the **Parent competency** from the dropdown menu. Select **Top** if you want the competency to sit at the top level of the hierarchy.

If you change the parent competency of an item it will move to sit below its new parent, and all of its children will move with it.

Note that to set up parent/child relationships you need to have at least one other item in the framework. Otherwise the option will not appear.';
$string['competencyplural'] = 'Competencies';
$string['competencyreturntoframework'] = 'Return to competency framework';
$string['competencyscale'] = 'Competency scale';
$string['competencyscale_help'] = '**Scale** is the name of the Competency Scale that is used in the competency framework.

The competency scale is set in the competency framework. Only one competency scale can be used in each framework.

A new competency scale can be set up under *Hierarchies > Competencies > Manage Frameworks* in the **Site Administration** menu.';
$string['competencyscaleassign'] = 'Competency scale';
$string['competencyscaleassign_help'] = 'A Competency scales defines the criteria by which a competency can be measured. This is the name of scale the value is being added to.';
$string['competencyscalechangeapplied'] = 'Changes to scale value settings have been applied';
$string['competencyscaledefault'] = 'Default value';
$string['competencyscaledefault_help'] = 'The **Default Value** is automatically assigned to a user when they have not yet demonstrated the proficiency required by the competency\'s specified evidence item(s) (course/activity completion, or passing course/activity grade).';
$string['competencyscaledescription'] = 'Description';
$string['competencyscaleinuse'] = 'This scale is in use (i.e. users have competencies marked with values from this scale). Scale values cannot be created, re-ordered or deleted to preserve data integrity. You can still rename scale values but this may confuse users when their proficiency changes without warning.';
$string['competencyscaleinusemayaffectchange'] = 'You can change the minimum required proficiency value but this may impact the proficiency status of assigned users and/or any proficiency value override set by assignment.';
$string['competencyscaleinusemayaffectconfusion'] = 'You can rename scale values but this may confuse users.';
$string['competencyscaleinusemayaffectlocked'] = 'Scale values cannot be deleted, re-ordered, or added, as this scale is in use.';
$string['competencyscaleminprofvalue'] = 'Minimum required proficiency value';
$string['competencyscaleminprofvalue_help'] = 'The lowest value a user has to achieve to be considered proficient in a competency using this scale. All higher scale values are automatically classified as proficient values (i.e. values at which the user will be considered proficient).';
$string['competencyscaleminprofvaluewithassignments'] = 'Minimum required proficiency value';
$string['competencyscaleminprofvaluewithassignments_help'] = 'The Minimum required proficiency value is the lowest value a user has to achieve to become proficient using this scale. All higher scale values are automatically classified as proficient values. This value will be the default, however assignment-specific proficiency values can be set to override the default.';
$string['competencyscaleprofcolumn'] = 'Proficient value';
$string['competencyscaleprofcolumn_help'] = 'Proficient values provide a way for the system to track that a user is \'competent\' in a particular competency. A user is considered \'competent\' if the scale value has \'proficient\' checked. This is used to show progress in learning plans and only show overdue notices for incomplete competencies.

Within Learning Plans, the lowest scale value that is marked as proficient is automatically given to any user who has demonstrated the proficiency required by the competency\'s specified evidence item(s) (e.g., course/activity completion, passing course/activity grade).';
$string['competencyscaleproficient'] = 'Proficient value';
$string['competencyscaleproficient_help'] = 'Proficient values provide a way for the system to track if a user is \'competent\' in a particular competency. This is used to show progress in learning plans and only show overdue notices for incomplete competencies.
A user is considered \'competent\' if the scale value set has \'proficient\' checked. You can have multiple scale values set to proficient, but you must have at least one scale value marked as proficient. The proficient value is edited by editing the scale value.

The lowest scale value that is marked as proficient is automatically given to any user who has demonstrated the proficiency required by the competency\'s specified evidence item(s) (e.g., course/activity completion, passing course/activity grade).';
$string['competencyscales'] = 'Competency scales';
$string['competencyscalesave'] = 'Save';
$string['competencyscalesaveapply'] = 'Save and apply changes';
$string['competencyscalescalename'] = 'Name';
$string['competencyscalescalename_help'] = 'The name of the Competency Scale that will be used by Competency frameworks.';
$string['competencyscalescalevalues'] = 'Values';
$string['competencyscalescalevalues_help'] = 'Enter values for the competency scale (one per line), in order from most competent to least competent. For example:

* Competent
* Competent with Supervision
* Not Competent';
$string['competencyscalesgeneral'] = 'Competency Scale';
$string['competencyscalesgeneral_help'] = '**Competency scales** enable you to define the criteria by which a competency can be measured. For example, a scale might have three values; \'competent, competent with supervision, not competent\'.

You must have a competency scale set up before you set up a competency framework, or any competencies.';
$string['competencyscaleupgradeorder'] = 'There are competency scales on this site with values in an invalid order, i.e. where non-proficient values are set higher on the scale than proficient ones. You must fix this before upgrading.

Please revert to Totara versions 9.33, 10.22, 11.16, 12.7 or above, and review and update the affected competency scales.';
$string['competencyscalevalueconfirmproficient'] = 'The proficiency status of users currently assigned to competencies using this scale may be affected.

Do you want to proceed with applying these changes?';
$string['competencyscalevalueconfirmtitle'] = 'Confirm updates to scale values';
$string['competencyscalevaluedescription'] = 'Description';
$string['competencyscalevaluedescription_help'] = 'A longer description of the competency scale value.';
$string['competencyscalevalueidnumber'] = 'Scale value ID number';
$string['competencyscalevalueidnumber_help'] = 'Scale ID number is a unique number used to represent the scale value.';
$string['competencyscalevaluename'] = 'Scale value name';
$string['competencyscalevaluename_help'] = '**Scale value name** is the name of the competency scale value you are adding or editing.A scale value is used to define a learner\'s progress for a competency. You can add as many scale values as required.
Remember to set the Default and Proficient value settings.';
$string['competencyscalevaluenumeric'] = 'Competency Scale Numeric Value';
$string['competencyscalevaluenumericalvalue'] = 'Scale value numerical value';
$string['competencyscalevaluenumericalvalue_help'] = 'Scale value numerical value is the numerical value associated with the scale value. The scale value must be within the range -99999.99999 to 99999.99999 with no more than 5 decimal places.';
$string['competencyshortname'] = 'Competency short name';
$string['competencyshortname_help'] = 'Competency short name is the quick reference name of the competency and can be used for display purposes.';
$string['competencytabachievementpaths'] = 'Achievement paths';
$string['competencytabgeneral'] = 'General';
$string['competencytablinkedcourses'] = 'Linked courses';
$string['competencytemplatefullname_help'] = 'Template full name is the complete title of the competency template being set up.';
$string['competencytemplategeneral_help'] = 'A **Competency Template** is a way of grouping competencies from one competency framework together.

When setting up a training event, for example an induction course, this could be linked to a competency template called \'new employee competencies\'; drawing automatically on a number of competencies, instead of repeatedly selecting the competencies one by one.';
$string['competencytemplatemanage'] = 'Manage templates';
$string['competencytemplates'] = 'Competency templates';
$string['competencytemplateshortname_help'] = 'Template short name is a quick reference name for the competency template and can be used for display purposes.';
$string['competencytype'] = 'Type';
$string['competencytype_help'] = 'A type defines a set of custom fields intended to capture metadata that is relevant only to a subset of competencies on the site, i.e. those classified as that type. Administrators must first create the types in order for them to appear as options here. Once classified as a type, a competency can be reclassified, but any data captured in the fields of the original type will need to be mapped to the new ones to avoid being deleted.';
$string['competencytypecustomfields'] = 'Competency type custom fields';
$string['competencytypedescription'] = 'Competency type description';
$string['competencytypedescription_help'] = 'A longer text description of the competency type.';
$string['competencytypeidnumber'] = 'Competency type ID number';
$string['competencytypes'] = 'Competency types';
$string['competencytypeview'] = 'Competency type view';
$string['competencyupdatedframework'] = 'The competency framework "{$a}" has been updated';
$string['competencyupdatetype'] = 'The competency type "{$a}" has been updated';
$string['competent'] = 'Competent';
$string['competentwithsupervision'] = 'Competent with supervision';
$string['configenablegoals'] = 'When enabled this will allow users to set goals. All links, menus, tabs, and options related to goals will be accessible.';
$string['configshowhierarchyshortnames'] = 'When enabled, hierarchies will include a shortname field in the framework, item and type forms';
$string['confirmmoveitems'] = 'Are you sure you want to move {$a->num} {$a->items} into "{$a->parentname}"?<br /><br />Any children of the {$a->items} being moved will also be relocated at the same time.';
$string['confirmpersonaldelete'] = 'Are you sure you want to delete {$a->username}\'s personal goal {$a->goalname}';
$string['confirmproceed'] = 'Are you sure you want to proceed?';
$string['confirmtypechange'] = 'Reclassify items and transfer/delete data';
$string['confirmupdatescale_content'] = 'The proficiency status of users currently assigned to competencies using this scale may be affected.

Do you want to proceed with applying these changes?';
$string['confirmupdatescale_title'] = 'Confirm updates to scale values';
$string['couldnotdeletescalevalue'] = 'There was a problem deleting that scale value';
$string['createdon'] = 'Created on';
$string['createnewcompetency'] = 'Create a new competency';
$string['createnewgoal'] = 'Create a new goal';
$string['currentlyselected'] = 'Currently selected';
$string['currenttype'] = 'Current type';
$string['customfields'] = 'Custom fields';
$string['datainx'] = 'Data in {$a}:';
$string['delete_check_scale_value_confirmation'] = 'Confirm scale value deletion';
$string['delete_check_scale_value_overrides'] = 'Affect competency assignments which override the default minimum required proficiency value. {$a} assignment(s) will be reset to the default minimum required proficiency value.';
$string['delete_check_scale_value_pathways2'] = 'Affect competencies that have achievement pathways defined against it. {$a} achievement pathway(s) will be deleted.';
$string['delete_check_scale_value_start'] = 'Deleting the \'{$a}\' scale value will:';
$string['delete_competency_assignments'] = 'Competency assignments: <strong>{$a}</strong>';
$string['delete_competency_bulk_confirmation'] = 'Confirm bulk competency deletion';
$string['delete_competency_bulk_proceed'] = 'Do you want to proceed with the bulk competency deletion?';
$string['delete_competency_bulk_title'] = 'This will permanently delete <strong>{$a}</strong> competencies and the following data:';
$string['delete_competency_children'] = 'Competency descendants: <strong>{$a}</strong>';
$string['delete_competency_evidence_items'] = 'Related evidence: <strong>{$a}</strong>';
$string['delete_competency_framework_confirmation'] = 'Confirm competency framework deletion';
$string['delete_competency_in_framework'] = 'All competencies in framework: <strong>{$a}</strong>';
$string['delete_competency_item_confirmation'] = 'Confirm competency deletion';
$string['delete_competency_item_proceed'] = 'Do you want to proceed with deleting this competency?';
$string['delete_competency_item_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> competency and the following associated data:';
$string['delete_competency_perform_links'] = 'Links to performance activities: <strong>{$a}</strong>';
$string['delete_competency_related_links'] = 'Links to related competencies: <strong>{$a}</strong>';
$string['delete_competency_user_achievements'] = 'User status records: <strong>{$a}</strong>';
$string['delete_goal_bulk_confirmation'] = 'Confirm bulk goal deletion';
$string['delete_goal_bulk_proceed'] = 'Do you want to proceed with the bulk goal deletion?';
$string['delete_goal_bulk_title'] = 'This will permanently delete <strong>{$a}</strong> goals and the following data:';
$string['delete_goal_children'] = 'Goal descendants: <strong>{$a}</strong>';
$string['delete_goal_framework_confirmation'] = 'Confirm goal framework deletion';
$string['delete_goal_in_framework'] = 'All goals in framework: <strong>{$a}</strong>';
$string['delete_goal_item_confirmation'] = 'Confirm goal deletion';
$string['delete_goal_item_proceed'] = 'Do you want to proceed with deleting this goal?';
$string['delete_goal_item_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> goal and the following associated data:';
$string['delete_goal_user_assignments'] = 'User assignments: <strong>{$a}</strong>';
$string['delete_hierarchy_bulk_confirmation'] = 'Confirm bulk hierarchy item deletion';
$string['delete_hierarchy_bulk_proceed'] = 'Do you want to proceed with the bulk deletion?';
$string['delete_hierarchy_bulk_title'] = 'This will permanently delete <strong>{$a}</strong> hierarchy items and the following data:';
$string['delete_hierarchy_framework_confirmation'] = 'Confirm framework deletion';
$string['delete_hierarchy_framework_proceed'] = 'Do you want to proceed with deleting the framework?';
$string['delete_hierarchy_framework_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> framework and the following associated data:';
$string['delete_hierarchy_item_children'] = 'Item descendants: <strong>{$a}</strong>';
$string['delete_hierarchy_item_confirmation'] = 'Confirm hierarchy item deletion';
$string['delete_hierarchy_item_custom_field_records'] = 'Custom field records: <strong>{$a}</strong>';
$string['delete_hierarchy_item_proceed'] = 'Do you want to proceed with deleting this hierarchy item?';
$string['delete_hierarchy_item_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> item and the following associated data:';
$string['delete_hierarchy_item_x'] = 'Delete \'{$a}\'';
$string['delete_hierarchy_items_in_framework'] = 'All items in framework <strong>{$a}</strong>';
$string['delete_organisation_archive_assignments'] = 'Active competency assignments to this organisation (these assignments will be archived): <strong>{$a}</strong>';
$string['delete_organisation_bulk_confirmation'] = 'Confirm bulk organisation deletion';
$string['delete_organisation_bulk_proceed'] = 'Do you want to proceed with the bulk organisation deletion?';
$string['delete_organisation_bulk_title'] = 'This will permanently delete <strong>{$a}</strong> organisations and the following associated data:';
$string['delete_organisation_children'] = 'Organisation descendants: <strong>{$a}</strong>';
$string['delete_organisation_framework'] = 'Organisation framework deletion';
$string['delete_organisation_framework_confirmation'] = 'Confirm organisation framework deletion';
$string['delete_organisation_in_framework'] = 'All organisations in framework: <strong>{$a}</strong>';
$string['delete_organisation_item_confirmation'] = 'Confirm organisation deletion';
$string['delete_organisation_item_proceed'] = 'Do you want to proceed with deleting this organisation?';
$string['delete_organisation_item_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> organisation and the following associated data:';
$string['delete_organisation_linked_competencies'] = 'Links to competencies: <strong>{$a}</strong>';
$string['delete_organisation_linked_goals'] = 'Links to goals: <strong>{$a}</strong>';
$string['delete_organisation_related_job_assignments'] = 'User assignments: <strong>{$a}</strong>';
$string['delete_position_archive_assignments'] = 'Active competency assignments (these assignments will be archived): <strong>{$a}</strong>';
$string['delete_position_bulk_confirmation'] = 'Confirm bulk position deletion';
$string['delete_position_bulk_proceed'] = 'Do you want to proceed with the bulk position deletion?';
$string['delete_position_bulk_title'] = 'This will permanently delete <strong>{$a}</strong> positions and the following associated data:';
$string['delete_position_children'] = 'Position descendants: <strong>{$a}</strong>';
$string['delete_position_framework'] = 'Position framework deletion';
$string['delete_position_framework_confirmation'] = 'Confirm position framework deletion';
$string['delete_position_in_framework'] = 'All positions in framework: <strong>{$a}</strong>';
$string['delete_position_item_confirmation'] = 'Confirm position deletion';
$string['delete_position_item_proceed'] = 'Do you want to proceed with deleting this position?';
$string['delete_position_item_title'] = 'This will permanently delete the <strong>"{$a->fullname}"</strong> position and the following associated data:';
$string['delete_position_linked_competencies'] = 'Links to competencies: <strong>{$a}</strong>';
$string['delete_position_linked_goals'] = 'Links to goals: <strong>{$a}</strong>';
$string['delete_position_related_job_assignments'] = 'User assignments: <strong>{$a}</strong>';
$string['deletecheckdepth'] = 'Are you absolutely sure you want to completely delete this depth level?';
$string['deletecheckscale'] = 'Are you absolutely sure you want to completely delete this scale?';
$string['deletecheckscalevalue'] = 'Are you sure you would like to delete this scale value?';
$string['deletechecktemplate'] = 'Are you absolutely sure you want to delete this competency template?';
$string['deletechecktype'] = 'Are you absolutely sure you want to delete this type?';
$string['deletechecktypeassociated'] = 'This type has {$a} assigned items. Are you absolutely sure you want to delete this type?';
$string['deletecompetency'] = 'Delete competency';
$string['deletedataconfirmproceed'] = 'Since the new class has no custom fields, this will delete all the data related to the following custom fields:{$a}If you wish to transfer the data to the new type, create the appropriate custom fields in the new type before reclassifying. Are you sure you want to proceed?';
$string['deletedcompetency'] = 'The competency {$a} and its children have been completely deleted.';
$string['deletedcompetencyscale'] = 'The competency scale "{$a}" has been completely deleted.';
$string['deletedcompetencyscalevalue'] = 'The competency scale value "{$a}" has been deleted.';
$string['deleteddepth'] = 'The depth level {$a} has been deleted.';
$string['deletedepth'] = 'Delete {$a}';
$string['deletedepthhaschildren'] = 'This depth level cannot be deleted because there are items at this depth level.';
$string['deletedepthnosuchdepth'] = 'Bad depth level id. Please try again.';
$string['deletedepthnotdeepest'] = 'This depth level cannot be deleted because there are depth levels below it in this framework.';
$string['deletedgoal'] = 'The goal {$a} and its children have been completely deleted.';
$string['deletedgoalscale'] = 'The goal scale "{$a}" has been completely deleted.';
$string['deletedgoalscalevalue'] = 'The goal scale value "{$a}" has been deleted.';
$string['deletedorganisation'] = 'The organisation "{$a}" and its children have been completely deleted';
$string['deletedpersonalgoal'] = 'Successfully deleted personal goal {$a}';
$string['deletedposition'] = 'The position {$a} and its children have been completely deleted';
$string['deletedtemplate'] = 'The competency template {$a} and its data have been completely deleted.';
$string['deletedtype'] = 'The type "{$a}" has been deleted.';
$string['deleteframework'] = 'Delete "{$a}"';
$string['deleteframeworkorganisation'] = 'Delete organisation framework';
$string['deleteframeworkposition'] = 'Delete position framework';
$string['deletegoal'] = 'Delete goal';
$string['deleteorganisation'] = 'Delete organisation';
$string['deleteposition'] = 'Delete position';
$string['deletepreventedframework'] = 'Looks like you can\'t delete this framework.';
$string['deletepreventedorganisation'] = 'Looks like you can\'t delete this organisation.';
$string['deletepreventedposition'] = 'Looks like you can\'t delete this position.';
$string['deleteselectedx'] = 'Delete selected {$a}';
$string['deletethisdata'] = 'Delete this data';
$string['deletetype'] = 'Delete type "{$a}"';
$string['deletetypenosuchtype'] = 'Bad type id. Please try again.';
$string['depth'] = 'Depth {$a}';
$string['depthlevel'] = 'Depth level';
$string['depthlevels'] = 'Depth levels';
$string['depths'] = 'Depths';
$string['description'] = 'Description';
$string['descriptionview'] = 'Description';
$string['displayoptions'] = 'Display Options';
$string['edit_competency_title'] = '{$a->header} ({$a->tab})';
$string['editcompetency'] = 'Edit competency: {$a}';
$string['editdepthlevel'] = 'Edit depth level';
$string['editgeneric'] = 'Edit {$a}';
$string['editgoal'] = 'Edit goal';
$string['editorganisation'] = 'Edit organisation';
$string['editpersonalgoal'] = 'Edit personal goal: ';
$string['editposition'] = 'Edit position';
$string['editscalevalue'] = 'Edit scale value';
$string['edittype'] = 'Edit type';
$string['edittypelevel'] = 'Edit type';
$string['enablecompetencies'] = 'Enable Competencies';
$string['enablecompetencies_desc'] = 'When enabled, this will allow users to view competencies. All links, menus, tabs and options related to competencies will be accessible.';
$string['enablegoals'] = 'Enable Goals';
$string['enableorganisations'] = 'Enable organisation hierarchies';
$string['enableorganisations_desc'] = 'When enabled, all features related to organisation hierarchies will be visible and accessible.';
$string['enablepositions'] = 'Enable position hierarchies';
$string['enablepositions_desc'] = 'When enabled, all features related to position hierarchies will be visible and accessible.';
$string['enternamesoneperline'] = 'Enter {$a} names (one per line)';
$string['entervaliddate'] = 'Enter a valid date';
$string['error:addcompetency'] = 'There was a problem adding the competency "{$a}"';
$string['error:addgoal'] = 'There was a problem adding the goal "{$a}"';
$string['error:addgoals'] = 'You do not have permission to add goals';
$string['error:addorganisation'] = 'There was a problem adding the organisation "{$a}"';
$string['error:addposition'] = 'There was a problem adding the position "{$a}"';
$string['error:alreadyassigned'] = 'This goal has already been assigned via that method';
$string['error:appraiserdeleted'] = 'The appraiser "{$a->username}" has been deleted from the system, please select another appraiser.';
$string['error:badsortorder'] = 'Could not move that {$a}, there is something wrong with the sort orders.';
$string['error:cannotconvertfieldfromxtoy'] = '"{$a->from}" fields cannot be converted to "{$a->to}" fields.';
$string['error:cannotmoveparentintochild'] = 'You cannot move "{$a->item}" into its own child "{$a->newparent}"';
$string['error:checkvariable'] = 'The check variable was wrong - try again';
$string['error:compevidencealreadyexists'] = 'This user already has goal evidence for the chosen goal. You can <a href=\'edit.php?id={$a}\'>edit the existing goal</a>, or add a different one.';
$string['error:couldnotdeletescale'] = 'There was a problem deleting the goal scale "{$a}"';
$string['error:couldnotmoveitem'] = 'Could not move that {$a}. There was an error updating the database.';
$string['error:couldnotmoveitemnopeer'] = 'Could not move that {$a}, no adjacent item at same depth level to swap with.';
$string['error:couldnotreclassifybulk'] = 'There was a problem reclassifying items from "{$a->from}" to "{$a->to}"';
$string['error:couldnotreclassifyitem'] = 'There was a problem reclassifying that item from "{$a->from}" to "{$a->to}"';
$string['error:couldnotupgradehierarchyduetobaddata'] = 'Could not upgrade hierarchy due to bad data ({$a})';
$string['error:createpersonalgoal'] = 'You do not have permissions to create personal goals for this user';
$string['error:dateformat'] = 'Please enter a date in the format {$a}.';
$string['error:deletedepthcheckvariable'] = 'The check variable was wrong - try again';
$string['error:deletegoalassignment'] = 'You do not have permission to remove that assignment';
$string['error:deletepersonalgoal'] = 'Failed to delete personal goal {$a}';
$string['error:deletetypecheckvariable'] = 'The check variable was wrong - try again';
$string['error:deleteusergoals'] = 'You do not have permissions to delete this goal';
$string['error:deletingindiviualassignments'] = 'Error: Can not delete user assignments from individual';
$string['error:dialognolinkedcourseitems'] = 'There are no goals in this framework with linked courses assigned to them';
$string['error:editgoals'] = 'You do not have permission to edit this goal';
$string['error:evidencealreadyexists'] = 'Could not create new goal evidence because a record already exists for that user and goal';
$string['error:failedbulkmove'] = 'There was a problem moving those items';
$string['error:findgoals'] = 'You do not have permission to find goal(s)';
$string['error:goalnotfound'] = 'The goal could not be found';
$string['error:hierarchyprefixnotfound'] = 'Hierarchy prefix {$a} not found';
$string['error:hierarchytypenotfound'] = 'Hierarchy type {$a} not found';
$string['error:includechildrencohort'] = 'can not include children of a non hierarchy item, Audiences';
$string['error:invaliddateformat'] = 'Invalid date format, please enter the date using {$a}';
$string['error:invaliddatepast'] = 'Invalid date, the target date must be in the future';
$string['error:invaliditemid'] = 'Invalid item ID';
$string['error:invalidparentformove'] = 'The location you are moving the item(s) to doesn\'t exist';
$string['error:invalidscaleid'] = "Invalid scale ID";
$string['error:invalidscalevalueid'] = "Invalid scale value ID";
$string['error:nodeletecompetencyscaleassigned'] = 'You cannot delete that competency scale because it is already assigned to one or more frameworks';
$string['error:nodeletecompetencyscaleinuse'] = 'You cannot delete that competency scale because it is in use';
$string['error:nodeletecompetencyscalevaluedefault'] = 'You cannot delete that scale value because it is the default';
$string['error:nodeletecompetencyscalevalueonlyprof'] = 'You cannot delete that scale value because it is the only proficient value in this scale. Mark another value as proficient before deleting';
$string['error:nodeletegoalscaleassigned'] = 'You cannot delete that goal scale because it is already assigned to one or more frameworks';
$string['error:nodeletegoalscaleinuse'] = 'You cannot delete that goal scale because it is in use';
$string['error:nodeletegoalscalevaluedefault'] = 'You cannot delete that scale value because it is the default';
$string['error:nodeletegoalscalevalueonlyprof'] = 'You cannot delete that scale value because it is the only \'consider complete\' value in this scale. Mark another value as consider complete before deleting';
$string['error:nodeletescaleinuse'] = 'You cannot delete a scale that is in use. To delete this scale, it must not be assigned to any framework.';
$string['error:nodeletescalevalueinuse'] = 'You cannot delete a scale value from a scale that is in use. To delete this scale value, the scale must not be assigned to any framework.';
$string['error:noframeworksfound'] = 'No {$a} frameworks with one or more depth levels found.';
$string['error:noitemsselected'] = 'No items selected';
$string['error:nonedeleted'] = 'None of the selected {$a} could be deleted';
$string['error:nonefoundbulk'] = 'There are no items of that type to convert';
$string['error:nonefounditem'] = 'The item does not appear to belong to the specified type';
$string['error:noposenabled'] = 'No position types enabled';
$string['error:noreorderscaleinuse'] = 'You cannot reorder a scale that is in use. To reorder this scale, it must not be assigned to any framework.';
$string['error:norestorefiles'] = 'No files found to restore from. {$a}';
$string['error:onescalevaluemustbeproficient'] = 'At least one scale value must be marked as proficient at all times. Set another scale value to proficient before unchecking this value.';
$string['error:organisationsdisabled'] = 'Hierarchy Organisations are disabled on this site';
$string['error:positionnotset'] = 'A position has not been set for this user';
$string['error:positionsdisabled'] = 'Hierarchy Positions are disabled on this site';
$string['error:postypenotenabled'] = 'Position type not enabled';
$string['error:restoreerror'] = 'An error occurred during the restore process: {$a}';
$string['error:scaledetails'] = 'Error getting scale details.';
$string['error:somedeleted'] = 'Only {$a->actually_deleted} of a possible {$a->marked_for_deletion} {$a->items} could be deleted';
$string['error:tempmanagerdeleted'] = 'The temporary manager "{$a->username}" has been deleted from the system, please select another temporary manager.';
$string['error:transition_mode_on_for_goal'] = 'You can\'t create or edit legacy personal goals because the current goals feature does not support it.';
$string['error:transition_mode_on_for_goal_framework'] = 'You can\'t create or edit legacy personal goal frameworks because the current goals feature does not support it.';
$string['error:transition_mode_on_for_goal_type'] = 'You can\'t create or edit legacy personal goal types because the current goals feature does not support it.';
$string['error:typenotfound'] = 'The {$a} type could not be found';
$string['error:unknownaction'] = 'Unknown action';
$string['error:unknownbuttonclicked'] = 'Unknown button clicked';
$string['error:updatecompetency'] = 'There was a problem updating the competency "{$a}"';
$string['error:updategoal'] = 'There was a problem updating the goal "{$a}"';
$string['error:updateorganisation'] = 'There was a problem updating the organisation "{$a}"';
$string['error:updateposition'] = 'There was a problem updating the position "{$a}"';
$string['error:updatescalevalue'] = 'You do not have permission to update the scale for this assignment';
$string['error:updatingscalevalue'] = 'Error: could not update scale value';
$string['error:userownappraiser'] = 'A user cannot be assigned as their own appraiser';
$string['error:viewusergoals'] = 'You do not have permissions to view this users goals';
$string['eventexportedallframeworks'] = 'Exported all Hierarchy Frameworks';
$string['eventexportedframework'] = 'Exported Hierarchy Framework';
$string['eventpositionupdated'] = 'User position updated';
$string['eventpositionviewed'] = 'User position viewed';
$string['eventviewedframework'] = 'Viewed Hierarchy Framework List';
$string['eventviewedtype'] = 'Viewed Hierarchy Type List';
$string['evidence'] = 'Evidence';
$string['evidenceactivitycompletion'] = 'activity completion';
$string['evidencecoursecompletion'] = 'course completion';
$string['evidencecoursegrade'] = 'course grade';
$string['evidenceitemremovecheck'] = 'Are you absolutely sure you want to remove this evidence item from "{$a}"?';
$string['evidenceitems'] = 'Linked courses';
$string['export'] = 'Export';
$string['exportas'] = 'Export as';
$string['exportcsv'] = 'CSV format';
$string['exportexcel'] = 'Excel format';
$string['exportformat'] = 'Export format';
$string['exportframework'] = 'Export all items from framework';
$string['exportframework_help'] = 'The export will contain all items in the framework and their associated fields. The file content structure is suitable for use in HR Import.';
$string['exportframeworks'] = 'Export items from all frameworks';
$string['exportframeworks_help'] = 'The export will contain all items (grouped by framework) and their associated fields. The file content structure is suitable for use in HR Import.';
$string['exportitems'] = 'Export all items';
$string['exportods'] = 'ODS format';
$string['exporttext'] = 'Text format';
$string['exportxls'] = 'Excel format';
$string['filterframework'] = 'Filter by framework: ';
$string['findgoals'] = 'Find Goal(s)';
$string['finishdate'] = 'Finish date';
$string['finishdate_help'] = 'Click the calendar icon to select the date the user finished in that position.';
$string['format'] = 'Format';
$string['formrequiresjs'] = 'This form requires Javascript to be enabled.';
$string['framework'] = 'Framework';
$string['frameworkdoesntexist'] = 'The {$a} framework doesn\'t exist';
$string['fullname'] = 'Full Name';
$string['fullnamedepth'] = 'Depth level full name';
$string['fullnameframework'] = 'Fullname';
$string['fullnametemplate'] = 'Template full name';
$string['fullnametype'] = 'Type full name';
$string['fullnametype_help'] = 'Type full name.';
$string['fullnameview'] = 'Full name';
$string['globalsettings'] = 'Global settings';
$string['goal'] = 'Goal';
$string['goal_assignment_type_adm'] = 'Admin';
$string['goal_assignment_type_aud'] = 'Audience';
$string['goal_assignment_type_ind'] = 'Individual';
$string['goal_assignment_type_mgr'] = 'Manager';
$string['goal_assignment_type_org'] = 'Organisation';
$string['goal_assignment_type_pos'] = 'Position';
$string['goal_assignment_type_self'] = 'Self';
$string['goaladdedframework'] = 'The goal framework "{$a}" has been added';
$string['goaladdnew'] = 'Add a new goal';
$string['goaladdnewframework'] = 'Add new goal framework';
$string['goalaggregationmethod'] = 'Aggregation Method';
$string['goalaggregationmethod_help'] = 'The aggregation method sets how the system will calculate the goal achievement.

If the aggregation method is set to **All** then all the child goals will have to be achieved for the parent goal to be declared achieved.

If the aggregation method is set to **Any** then only one of the child goals needs to be met to successfully achieve the parent goal.

If the aggregation method is set to **Off** then automatic achievement will be deactivated for this goal. (It may still be marked achieved manually.)';
$string['goalallframeworks'] = 'All frameworks';
$string['goalassigmentselector'] = 'Assign group of users';
$string['goalassigndeletecheck'] = 'Are you sure you would like to remove this goal assignment?';
$string['goalassignlevelparent'] = 'Parent: {$a}';
$string['goalassignmentadmin'] = 'Administrator: {$a}';
$string['goalassignmentaudience'] = 'Audience: {$a}';
$string['goalassignmentindividual'] = 'Individually by: {$a}';
$string['goalassignmentmanager'] = 'Manager: {$a}';
$string['goalassignmentorganisation'] = 'Organisation: {$a}';
$string['goalassignmentposition'] = 'Position: {$a}';
$string['goalassignments'] = 'Goal Assignments';
$string['goalassignmentself'] = 'Self';
$string['goalassignthislevelbelow'] = 'This level and below';
$string['goalassignthislevelonly'] = 'This level';
$string['goalbacktoallframeworks'] = 'Back to all goal frameworks';
$string['goalcount'] = 'Number of goals';
$string['goalcreatetype'] = 'The goal type "{$a}" has been created';
$string['goalcustomfields'] = 'Custom fields';
$string['goaldeletedassignment'] = 'Successfully deleted goal assignment';
$string['goaldeletedframework'] = 'The goal framework "{$a}" and its data have been completely deleted.';
$string['goaldeletedtype'] = 'The goal type "{$a}" has been completely deleted.';
$string['goaldepthcustomfields'] = 'Goal depth custom fields';
$string['goaldepthlevelview'] = 'Goal depth level view';
$string['goaldescription'] = 'Description';
$string['goaldescription_help'] = 'A free-text field for providing more details about this goal. This data is displayed when viewing the hierarchy listing, and the individual goal page.';
$string['goaldetails'] = 'Goal Details';
$string['goaleditframework'] = 'Edit goal framework';
$string['goalembeddedreportcustomfields'] = 'Goal Custom Fields';
$string['goalerror:createtype'] = 'Error creating goal type "{$a}"';
$string['goalerror:deletedframework'] = 'Error deleting goal framework "{$a}" and its data.';
$string['goalerror:deletedtype'] = 'Error deleting goal type "{$a}".';
$string['goalerror:dialognotreeitems'] = 'No goals in this framework';
$string['goalerror:updatetype'] = 'Error updating goal type "{$a}"';
$string['goalevidence'] = 'Goal evidence';
$string['goalevidenceassessmenttype'] = 'Assessment Type';
$string['goalevidenceassessmenttype_help'] = 'The assessment type field is a free text field for any additional information about the assessment of this goal. Contents may vary and the field is optional.';
$string['goalevidenceassessor'] = 'Evidence Assessor';
$string['goalevidenceassessor_help'] = 'You can select an assessor, which is a user who assessed that the current user completed the current goal. Assessor is an optional field so leave the pulldown on the **Select an assessor...** option if you do not want to assign an assessor.

The pulldown lists all Totara users who are in the assessor role. If the user you wish to add is missing or no options are shown then you will need to ask an administrator to add that user to the assessor role.';
$string['goalevidenceassessorname'] = 'Evidence Assessor Name';
$string['goalevidenceassessorname_help'] = 'The Assessor Name field refers to the name of the organisation that did the assessment of the user for this goal. It is an optional field so can be left blank.';
$string['goalevidencegoal'] = 'Evidence Goal';
$string['goalevidencegoal_help'] = 'The goal to be assigned to the user. If you are editing an existing item of goal evidence, this cannot be changed. You can however create a new item of goal evidence (if you have permission to do so) by visiting the user\'s My Records page and clicking the **Add goal evidence** button.

When creating a new goal evidence item you can choose between adding evidence for an existing goal or creating a new goal. If you choose **Select a goal** a popup will allow you to pick from the existing goals. If you choose **Create a new goal** a form will appear where you can choose a framework and define the new goal.

Note that you cannot create two goal evidence items that refer to the same user and goal. If you try to do this you will be provided with a link to edit the original record or choose a different goal.';
$string['goalevidenceorganisation'] = 'Evidence Organisation';
$string['goalevidenceorganisation_help'] = 'This option records the organisation the user was in at the time they completed the item of goal evidence. In most cases this will be the same as the user\'s current organisation. As users change organisation over time this allows a record to be kept of where they were in at time of completion. This is an optional field.';
$string['goalevidenceposition'] = 'Evidence Position';
$string['goalevidenceposition_help'] = 'This option records the position the user was in at the time they completed the item of goal evidence. In most cases this will be the same as the user\'s current role. As users change roles over time this allows a record to be kept of the role they were in at time of completion. This is an optional field.';
$string['goalevidenceproficiency_help'] = 'This field records whether or not the user is deemed to have completed an assigned goal. The options that appear in the pulldown depend on the goal scale assigned to the chosen goal, so the goal must be selected before this field can be modified. A proficiency must be set to add or update a goal evidence record.';
$string['goalevidencetimecompleted'] = 'Time Evidence Completed';
$string['goalevidencetimecompleted_help'] = 'A record of when the goal evidence was completed.';
$string['goalevidenceuser'] = 'Goal Evidence User';
$string['goalevidenceuser_help'] = 'The user whom this item of goal evidence is assigned. It is not possible to reassign an item of goal evidence to a different user. If you have sufficient permissions you can create a new item of goal evidence for a user by clicking the button on the user\'s My Records page. You can also edit evidence for that user by finding the record in the report and clicking the edit icon.';
$string['goalfeatureplural'] = 'Goals';
$string['goalframework'] = 'Goal framework';
$string['goalframework_help'] = 'Goals are grouped or categorised and stored in a **Goal framework**. Once a goal framework is set up, goals can be set up within it.';
$string['goalframeworkdescription'] = 'Description';
$string['goalframeworkdescription_help'] = 'The framework description is a text field for storing additional information about the framework. It is displayed on the manage goals page, just above the table of goals.';
$string['goalframeworkfullname'] = 'Full Name';
$string['goalframeworkfullname_help'] = 'The framework full name is the complete title of the framework.';
$string['goalframeworkgeneral'] = 'Goal Framework';
$string['goalframeworkgeneral_help'] = '**Goal Frameworks** are set up to hold the skills, knowledge and behavioural goals you expect staff to achieve.

Goals may be grouped under different kinds of framework. For example, one framework could hold all industry national goal standards (taken from an industry body), while another framework could hold specific goals set up in-house.

Before you set up a goal framework you must have a **Goal Scale** set up.';
$string['goalframeworkidnumber'] = 'ID Number';
$string['goalframeworkidnumber_help'] = 'The framework ID number is a unique number that can be used to represent the framework.';
$string['goalframeworkmanage'] = 'Manage frameworks';
$string['goalframeworks'] = 'Goal frameworks';
$string['goalframeworks_help'] = '**Goal Frameworks** are set up to hold the skills, knowledge and behavioural goals you expect staff to achieve.

Goals may be grouped under different kinds of framework. For example, one framework could hold all industry national goal standards (taken from an industry body), while another framework could hold specific goals set up in-house.

Before you set up a goal framework you must have a **Goal Scale** set up.';
$string['goalframeworkscale'] = 'Goal Framework Scale';
$string['goalframeworkscale_help'] = 'Goal scales enable you to define the criteria by which a goal can be measured. For example, a scale might have three values; Complete, In Progress, Started. The first step is to use the Goal scales option to add a new scale, then to add the scale values which are used to define a learner\'s progress for a goal. You can add as many values as you wish. Note also the Default and **consider complete** value settings.';
$string['goalframeworkshortname'] = 'Goal Framework shortname';
$string['goalframeworkshortname_help'] = 'The framework short name is a quick reference to the framework\'s full name and can be used for display purposes.';
$string['goalframeworkview'] = 'View framework';
$string['goalfullname'] = 'Goal full name';
$string['goalfullname_help'] = 'Goal full name is the complete title of the goal.';
$string['goalidnumber'] = 'Goal ID number';
$string['goalidnumber_help'] = 'Goal ID number is a unique number used to represent the goal.';
$string['goalmissingname'] = 'Missing goal name';
$string['goalmissingnameframework'] = 'Missing goal framework name';
$string['goalmissingnametype'] = 'Missing goal type name';
$string['goalmissingshortname'] = 'Missing goal short name';
$string['goalnamehidden'] = '[Hidden]';
$string['goalnoframeworks'] = 'No goal frameworks defined';
$string['goalnoframeworkssetup'] = 'There are no goal frameworks setup for this site.';
$string['goalnotypes'] = 'No goal types';
$string['goalparent'] = 'Parent';
$string['goalparent_help'] = '**Parent goal** allows you to manage parent/child relationships between goals.

Select the **Parent goal** from the dropdown menu. Select **Top** if you want the goal to sit at the top level of the hierarchy.

If you change the parent goal of an item it will move to sit below its new parent, and all of its children will move with it.

Note that to set up parent/child relationships you need to have at least one other item in the framework. Otherwise the option will not appear.';
$string['goalpersonalavailableall'] = 'Available to all users';
$string['goalpersonalavailableaudience'] = 'Available only to certain audiences';
$string['goalplural'] = 'Goals';
$string['goalreports'] = 'Reports';
$string['goalreturntoframework'] = 'Return to goal framework';
$string['goals'] = 'Goals';
$string['goalsassigned'] = 'Assigned Goals';
$string['goalscale'] = 'Goal scale';
$string['goalscale_help'] = '**Scale** is the name of the Goal Scale that is used in the goal framework.

The goal scale is set in the goal framework. Only one goal scale can be used in each framework.

A new goal scale can be set up under *Hierarchies > Goals > Manage Frameworks* in the **Site Administration** menu.';
$string['goalscaleassign'] = 'Goal scale';
$string['goalscaleassign_help'] = 'A Goal scales defines the criteria by which a goal can be measured. This is the name of scale the value is being added to.';
$string['goalscaledefault'] = 'Default value';
$string['goalscaledefault_help'] = 'The **Default Value** is automatically assigned to a user when they have not yet demonstrated the proficiency required by the goal\'s specified evidence item(s) (course/activity completion, or passing course/activity grade).';
$string['goalscaledefaultassigned'] = 'Goal assigned';
$string['goalscaledefaultcompleted'] = 'Goal completed';
$string['goalscaledefaultstarted'] = 'Goal in progress';
$string['goalscaledescription'] = 'Description';
$string['goalscaleinuse'] = 'This scale is in use (i.e. users have goals marked with values from this scale). Scale values cannot be created, re-ordered or deleted to preserve data integrity. You can still rename scale values but this may confuse users when their proficiency changes without warning.';
$string['goalscaleproficient'] = 'Consider complete';
$string['goalscaleproficient_help'] = '*considered complete* values provide a way for the system to track if a user has completed a particular goal.
A user is considered complete if the scale value set has consider complete checked. You can have multiple scale values set to consider complete, but you must have at least one scale value marked as consider complete. The consider complete value is edited by editing the scale value.';
$string['goalscales'] = 'Goal scales';
$string['goalscalescalename'] = 'Name';
$string['goalscalescalename_help'] = 'The name of the Goal Scale that will be used by Goal frameworks.';
$string['goalscalescalevalues'] = 'Values';
$string['goalscalescalevalues_help'] = 'Enter values for the goal scale (one per line), in order from most complete to least complete. For example:

* Complete
* In progress
* Started';
$string['goalscalesetdefault'] = 'Set {$a} as the default value';
$string['goalscalesgeneral'] = 'Goal Scale';
$string['goalscalesgeneral_help'] = '**Goal scales** enable you to define the criteria by which a goal can be measured. For example, a scale might have three values \'Complete, In Progress, Started\'.

* You must have a goal scale set up before you set up a goal framework, or any goals.';
$string['goalscalevaluedescription'] = 'Description';
$string['goalscalevaluedescription_help'] = 'A longer description of the goal scale value.';
$string['goalscalevalueidnumber'] = 'Scale value ID number';
$string['goalscalevalueidnumber_help'] = 'Scale ID number is a unique number used to represent the scale value.';
$string['goalscalevaluename'] = 'Scale value name';
$string['goalscalevaluename_help'] = '**Scale value name** is the name of the goal scale value you are adding or editing.

A scale value is used to define a learner\'s progress for a goal. You can add as many scale values as required.

Remember to set the **Default** and **considered complete** settings.';
$string['goalscalevaluenumeric'] = 'Goal Scale Numeric Value';
$string['goalscalevaluenumericalvalue'] = 'Scale value numerical value';
$string['goalscalevaluenumericalvalue_help'] = 'Scale value numerical value is the numerical value associated with the scale value. The scale value must be within the range -99999.99999 to 99999.99999 with no more than 5 decimal places.';
$string['goalsdisabled'] = 'Goals are not enabled on this site';
$string['goalshortname'] = 'Goal short name';
$string['goalshortname_help'] = 'Goal short name is the quick reference name of the goal and can be used for display purposes.';
$string['goalstatushistoryreportfor'] = 'Goal status history report: ';
$string['goalstatusreport'] = 'Status report';
$string['goalstatusreportfor'] = 'Goal status report: ';
$string['goalsummaryreport'] = 'Summary report';
$string['goalsummaryreportforx'] = 'Goal summary report for {$a}: ';
$string['goalsusedincourse'] = 'Goals used in course';
$string['goaltable:assigned'] = 'Assigned via';
$string['goaltable:assignmentlevel'] = 'Assigned at';
$string['goaltable:delete'] = 'Delete';
$string['goaltable:due'] = 'Due';
$string['goaltable:name'] = 'Name';
$string['goaltable:numusers'] = 'Number of users';
$string['goaltable:scale'] = 'Scale';
$string['goaltable:scalevalue'] = 'Scale Value';
$string['goaltable:status'] = 'Status';
$string['goaltable:type'] = 'Type';
$string['goaltargetdate'] = 'Target date';
$string['goaltargetdate_help'] = 'Sets the date you plan to have completed the goal by.';
$string['goaltemplatefullname_help'] = 'Template full name is the complete title of the goal template being set up.';
$string['goaltemplategeneral_help'] = 'A **Goal Template** is a way of grouping goals from one goal framework together.

When setting up a training event, for example an induction course, this could be linked to a goal template called \'new employee goals\'; drawing automatically on a number of goals, instead of repeatedly selecting the goals one by one.';
$string['goaltemplatemanage'] = 'Manage templates';
$string['goaltemplates'] = 'Goal templates';
$string['goaltemplateshortname_help'] = 'Template short name is a quick reference name for the goal template and can be used for display purposes.';
$string['goaltype'] = 'Type';
$string['goaltype_help'] = 'Administrators can create and assign types of goals. If a goal is assigned a type it inherits any custom fields that have been assigned to that type. This allows you to organise meta-data relating to your goals and only show the fields that each sort of goal needs.';
$string['goaltypeavailability'] = 'Goal type availability';
$string['goaltypeavailability_help'] = 'Select goal type availability.';
$string['goaltypecustomfields'] = 'Goal type custom fields';
$string['goaltypedescription'] = 'Goal type description';
$string['goaltypedescription_help'] = 'A longer text description of the goal type.';
$string['goaltypeidnumber'] = 'Goal type ID number';
$string['goaltypes'] = 'Goal types';
$string['goaltypeview'] = 'Goal type view';
$string['goalupdatedframework'] = 'The goal framework "{$a}" has been updated';
$string['goalupdatetype'] = 'The goal type "{$a}" has been updated';
$string['hidden'] = 'Hidden';
$string['hidecustomfields'] = 'Hide Custom Fields';
$string['hidedetails'] = 'Hide details';
$string['hierarchies'] = 'Hierarchies';
$string['hierarchy:assignselfgoal'] = 'Assign goals to self';
$string['hierarchy:assignselfposition'] = 'Assign self position';
$string['hierarchy:assignusergoal'] = 'Assign goals to team';
$string['hierarchy:assignuserposition'] = 'Assign user position';
$string['hierarchy:competencymanagecustomfield'] = 'Manage a competency custom fields';
$string['hierarchy:createcompetency'] = 'Create a competency';
$string['hierarchy:createcompetencydepth'] = 'Create a competency depth';
$string['hierarchy:createcompetencyframeworks'] = 'Create a competency framework';
$string['hierarchy:createcompetencyscale'] = 'Create competency scales';
$string['hierarchy:createcompetencytemplate'] = 'Create a competency template';
$string['hierarchy:createcompetencytype'] = 'Create a competency type';
$string['hierarchy:createcoursecustomfield'] = 'Create a course custom field';
$string['hierarchy:creategoal'] = 'Create a goal';
$string['hierarchy:creategoalframeworks'] = 'Create goal frameworks';
$string['hierarchy:creategoalscale'] = 'Create goal scales';
$string['hierarchy:creategoaltemplate'] = 'Create goal templates';
$string['hierarchy:creategoaltype'] = 'Create goal types';
$string['hierarchy:createorganisation'] = 'Create an organisation';
$string['hierarchy:createorganisationdepth'] = 'Create an organisational depth';
$string['hierarchy:createorganisationframeworks'] = 'Create an organisational framework';
$string['hierarchy:createorganisationtype'] = 'Create an organisational type';
$string['hierarchy:createposition'] = 'Create a position';
$string['hierarchy:createpositiondepth'] = 'Create a position depth';
$string['hierarchy:createpositionframeworks'] = 'Create a position framework';
$string['hierarchy:createpositiontype'] = 'Create a position type';
$string['hierarchy:deletecompetency'] = 'Delete a competency';
$string['hierarchy:deletecompetencydepth'] = 'Delete a competency depth';
$string['hierarchy:deletecompetencyframeworks'] = 'Delete a competency framework';
$string['hierarchy:deletecompetencyscale'] = 'Delete competency scales';
$string['hierarchy:deletecompetencytemplate'] = 'Delete a competency template';
$string['hierarchy:deletecompetencytype'] = 'Delete a competency type';
$string['hierarchy:deletecoursecustomfield'] = 'Delete a course custom field';
$string['hierarchy:deletegoal'] = 'Delete a goal';
$string['hierarchy:deletegoalframeworks'] = 'Delete goal frameworks';
$string['hierarchy:deletegoalscale'] = 'Delete goal scales';
$string['hierarchy:deletegoaltemplate'] = 'Delete goal templates';
$string['hierarchy:deletegoaltype'] = 'Delete goal types';
$string['hierarchy:deleteorganisation'] = 'Delete an organisation';
$string['hierarchy:deleteorganisationdepth'] = 'Delete an organisational depth';
$string['hierarchy:deleteorganisationframeworks'] = 'Delete an organisational framework';
$string['hierarchy:deleteorganisationtype'] = 'Delete an organisational type';
$string['hierarchy:deleteposition'] = 'Delete a position';
$string['hierarchy:deletepositiondepth'] = 'Delete a position depth';
$string['hierarchy:deletepositionframeworks'] = 'Delete a position framework';
$string['hierarchy:deletepositiontype'] = 'Delete a position type';
$string['hierarchy:editgoalreport'] = 'Edit embedded goal reports';
$string['hierarchy:goalmanagecustomfield'] = 'Manage goal custom fields';
$string['hierarchy:managegoalassignments'] = 'Manage goal assignments';
$string['hierarchy:managemanagerassignedgoal'] = 'Manage manager assigned goals';
$string['hierarchy:manageowncompanygoal'] = 'Manage own company goals';
$string['hierarchy:manageownpersonalgoal'] = 'Manage own personal goals';
$string['hierarchy:managestaffcompanygoal'] = 'Manage team members company goals';
$string['hierarchy:managestaffpersonalgoal'] = 'Manage team members personal goals';
$string['hierarchy:organisationmanagecustomfield'] = 'Manage an organisation custom fields';
$string['hierarchy:positionmanagecustomfield'] = 'Manage a position custom field';
$string['hierarchy:updatecompetency'] = 'Update a competency';
$string['hierarchy:updatecompetencydepth'] = 'Update a competency depth';
$string['hierarchy:updatecompetencyframeworks'] = 'Update a competency framework';
$string['hierarchy:updatecompetencyscale'] = 'Update competency scales';
$string['hierarchy:updatecompetencytemplate'] = 'Update a competency template';
$string['hierarchy:updatecompetencytype'] = 'Update a competency type';
$string['hierarchy:updatecoursecustomfield'] = 'Update a course custom field';
$string['hierarchy:updategoal'] = 'Update a goal';
$string['hierarchy:updategoalframeworks'] = 'Update goal frameworks';
$string['hierarchy:updategoalscale'] = 'Update goal scales';
$string['hierarchy:updategoaltemplate'] = 'Update goal templates';
$string['hierarchy:updategoaltype'] = 'Update goal types';
$string['hierarchy:updateorganisation'] = 'Update an organisation';
$string['hierarchy:updateorganisationdepth'] = 'Update an organisational depth';
$string['hierarchy:updateorganisationframeworks'] = 'Update an organisational framework';
$string['hierarchy:updateorganisationtype'] = 'Update an organisational type';
$string['hierarchy:updateposition'] = 'Update a position';
$string['hierarchy:updatepositiondepth'] = 'Update a position depth';
$string['hierarchy:updatepositionframeworks'] = 'Update a position framework';
$string['hierarchy:updatepositiontype'] = 'Update a position type';
$string['hierarchy:viewallgoals'] = 'View all goals';
$string['hierarchy:viewcompetency'] = 'View a competency';
$string['hierarchy:viewcompetencyframeworks'] = 'View competency frameworks';
$string['hierarchy:viewcompetencyscale'] = 'View competency scales';
$string['hierarchy:viewgoal'] = 'View a goal';
$string['hierarchy:viewgoalframeworks'] = 'View goal frameworks';
$string['hierarchy:viewgoalreport'] = 'View embedded goal reports';
$string['hierarchy:viewgoalscale'] = 'View goal scales';
$string['hierarchy:vieworganisation'] = 'View an organisation';
$string['hierarchy:vieworganisationframeworks'] = 'View organisation frameworks';
$string['hierarchy:viewowncompanygoal'] = 'View own company goals';
$string['hierarchy:viewownpersonalgoal'] = 'View own personal goals';
$string['hierarchy:viewposition'] = 'View a position';
$string['hierarchy:viewpositionframeworks'] = 'View position frameworks';
$string['hierarchy:viewstaffcompanygoal'] = 'View team members company goals';
$string['hierarchy:viewstaffpersonalgoal'] = 'View team members personal goals';
$string['hierarchy_list:organisation:all'] = 'All organisations';
$string['hierarchy_list:organisation:all_in_framework'] = 'All organisations in framework';
$string['hierarchy_list:organisation:select'] = 'Select organisations';
$string['hierarchy_list:position:all'] = 'All positions';
$string['hierarchy_list:position:all_in_framework'] = 'All positions in framework';
$string['hierarchy_list:position:select'] = 'Select positions';
$string['hierarchybackup'] = 'Hierarchy Backup';
$string['hierarchyrestore'] = 'Hierarchy Restore';
$string['idnumberview'] = 'ID Number';
$string['includecompetencyevidence'] = 'Include competency evidence';
$string['includegoalevidence'] = 'Include goal evidence';
$string['individual'] = 'Individual';
$string['invalidassigntype'] = 'Unrecognised Assignment type for this {$a} goal';
$string['invalidevidencetype'] = 'Invalid evidence type';
$string['invalidgoalscale'] = 'The scale you are trying to assign does not exist';
$string['invalidgoaltype'] = 'Unrecognised goal type';
$string['invalidnumeric'] = 'Numerical value must be numerical (or not set)';
$string['invalidscalenumericalvalue'] = 'Numerical value is outside the allowed range';
$string['invalidtargetdate'] = 'The target date you have set is in the past';
$string['itemstoadd'] = 'Items to add';
$string['least_competent'] = '{$a} (least competent)';
$string['least_competent_scale_not_started'] = 'The least competent scale value is considered \'Not started\' on the performance overview page.';
$string['legacy_goals'] = 'Legacy goals';
$string['legacy_personal_goal'] = 'Legacy personal goal';
$string['legacy_personal_goals'] = 'Legacy personal goals';
$string['linkcompetencies'] = 'Link competencies';
$string['linkcourses'] = 'Link courses';
$string['linkedcompetencies'] = 'Linked Competencies';
$string['linktoscalevalues'] = 'View/edit the scale values for this competency scale.';
$string['linktoscalevaluesgoal'] = 'View/edit the scale values for this goal scale.';
$string['locatecompetency'] = 'Locate competency';
$string['locatecompetencytemplate'] = 'Locate competency template';
$string['locategoal'] = 'Locate goal';
$string['locategoaltemplate'] = 'Locate goal template';
$string['locateorganisation'] = 'Locate organisation';
$string['locateorganisationtemplate'] = 'Locate organisation template';
$string['locateposition'] = 'Locate position';
$string['locatepositiontemplate'] = 'Locate position template';
$string['manage_legacy_goals'] = 'Manage legacy goals';
$string['managecompanygoaltypes'] = 'Manage company goal types';
$string['managecompanygoaltypes_legacy'] = 'Manage legacy company goal types';
$string['managecompetencies'] = 'Manage competencies';
$string['managecompetency'] = 'Manage competencies';
$string['managecompetencytypes'] = 'Manage types';
$string['managegoaltypes'] = 'Manage goal types';
$string['manageorganisation'] = 'Manage organisations';
$string['manageorganisations'] = 'Manage organisations';
$string['manageorganisationtypes'] = 'Manage types';
$string['managepersonalgoaltypes'] = 'Manage personal goal types';
$string['managepersonalgoaltypes_legacy'] = 'Manage legacy personal goal types';
$string['manageposition'] = 'Manage positions';
$string['managepositions'] = 'Manage positions';
$string['managepositiontypes'] = 'Manage types';
$string['mandatory'] = 'Mandatory';
$string['missingfullnametemplate'] = 'Missing template full name';
$string['missingfullnametype'] = 'Missing type full name';
$string['missingnametemplate'] = 'Missing template name';
$string['missingscale'] = 'Missing scale';
$string['missingscalevaluename'] = 'Missing scale value name';
$string['missingshortnamedepth'] = 'Missing depth level short name';
$string['missingshortnameframework'] = 'Missing framework short name';
$string['missingshortnametemplate'] = 'Missing template short name';
$string['missingshortnametype'] = 'Missing type short name';
$string['missingtypename'] = 'Missing type name';
$string['moveselectedxto'] = 'Move selected {$a} to: ';
$string['mygoalsteam'] = '{$a}\'s Goals';
$string['name'] = 'Name';
$string['newpersonalgoal'] = 'Create new personal goal';
$string['newtype'] = 'New type';
$string['noassignedcompetencies'] = 'No competencies assigned';
$string['noassignedcompetenciestotemplate'] = 'No competencies assigned to this template';
$string['noassignedcompetencytemplates'] = 'No competency templates assigned';
$string['noassignedgoals'] = 'No goals assigned';
$string['noassignedgoalstotemplate'] = 'No goals assigned to this template';
$string['noassignedgoaltemplates'] = 'No goal templates assigned';
$string['nochildcompetencies'] = 'No child competencies';
$string['nochildcompetenciesfound'] = 'No child competencies found';
$string['nochildgoals'] = 'No child goals';
$string['nochildgoalsfound'] = 'No child goals found';
$string['nochildorganisations'] = 'No child organisations defined';
$string['nocompetenciesassignedtoposition'] = 'No competencies assigned to position';
$string['nocompetenciesinframework'] = 'No competencies in this framework';
$string['nocompetency'] = 'No competencies defined';
$string['nocompetencyscales'] = 'You must define at least one competency scale with values before you can define a competency framework.';
$string['nocoursecompetencies'] = 'No course competencies';
$string['nocoursegoals'] = 'No course goals';
$string['nocoursesincat'] = 'No courses found in that category';
$string['nocustomfields'] = 'No custom fields';
$string['nodata'] = 'No custom field data';
$string['nodepthlevels'] = 'No depth levels in this framework';
$string['noevidenceitems'] = 'No linked courses set up for this competency';
$string['noevidencetypesavailable'] = 'No evidence types available in this course';
$string['nogoal'] = 'No goals defined';
$string['nogoalsassignedtoposition'] = 'No goals assigned to position';
$string['nogoalscales'] = 'You must define at least one goal scale with values before you can define a goal framework.';
$string['nogoalsinframework'] = 'No goals in this framework';
$string['nolinkedcompetencies'] = 'No Linked Competencies';
$string['nomanager'] = 'No managers defined';
$string['nonsensicalproficientvalues'] = 'Warning: You have proficient values below non-proficient values in this scale. Remember that your scale should be ordered from most proficient at the top, to least proficient at the bottom.';
$string['noorganisation'] = 'No organisations defined';
$string['noorganisationsinframework'] = 'No organisations in this framework';
$string['nopathfoundforid'] = 'No path found for {$a->prefix} id {$a->id}';
$string['nopermviewhiddenframeworks'] = 'You do not have permission to view hidden frameworks';
$string['noposition'] = 'No positions defined';
$string['nopositionsassigned'] = 'No positions currently assigned to this user';
$string['nopositionset'] = 'No position set';
$string['nopositionsinframework'] = 'No positions in this framework';
$string['norelatedcompetencies'] = 'No related competencies';
$string['norelatedgoals'] = 'No related goals';
$string['noresultsfor'] = 'No results found for "{$a->query}".';
$string['noresultsforinframework'] = 'No results found for "{$a->query}" in framework "{$a->framework}".';
$string['noresultsforsearchx'] = 'No results found for search "{$a}"';
$string['noscalesdefined'] = 'No scales defined';
$string['noscalevalues'] = 'There are no scale values defined for this scale.';
$string['notcompetent'] = 'Not competent';
$string['notemplateinframework'] = 'No competency templates defined in this framework';
$string['notescalevalueentry'] = 'One value per line - from most competent to least';
$string['notset'] = 'Not Set';
$string['notypelevels'] = 'No types in this framework';
$string['nounassignedcompetencies'] = 'No unassigned competencies';
$string['nounassignedcompetencytemplates'] = 'No unassigned competency templates';
$string['nounassignedgoals'] = 'No unassigned goals';
$string['nounassignedgoaltemplates'] = 'No unassigned goal templates';
$string['noxfound'] = 'No {$a} found';
$string['numericalvalue'] = 'Numerical value';
$string['oldgoalassignment'] = 'Old {$a->type}: {$a->name}';
$string['optional'] = 'Optional';
$string['options'] = 'Options';
$string['organisation'] = 'Organisation';
$string['organisation_deletion'] = 'Organisation deletion';
$string['organisationaddedframework'] = 'The organisation framework "{$a}" has been added';
$string['organisationaddnew'] = 'Add a new organisation';
$string['organisationaddnewframework'] = 'Add new organisation framework';
$string['organisationbacktoallframeworks'] = 'Back to all organisation frameworks';
$string['organisationcreatetype'] = 'The organisation type "{$a}" has been created';
$string['organisationcustomfields'] = 'Custom fields';
$string['organisationdeletedassignedcompetency'] = 'Competency successfully unassigned from this organisation';
$string['organisationdeletedassignedgoal'] = 'Goal successfully unassigned from this organisation';
$string['organisationdeletedframework'] = 'The organisation framework "{$a}" and its data have been completely deleted';
$string['organisationdeletedtype'] = 'The organisation type "{$a}" has been completely deleted';
$string['organisationdeleteincludexlinkedcompetencies'] = '- {$a} link(s) to competencies';
$string['organisationdeleteincludexlinkedgoals'] = '- {$a} link(s) to goals';
$string['organisationdepthcustomfields'] = 'Organisation depth custom fields';
$string['organisationdescription'] = 'Description';
$string['organisationdescription_help'] = 'A free-text field for providing more details about this organisation. This data is displayed when viewing the hierarchy listing, and the individual organisation page.';
$string['organisationdetails'] = 'Organisation Details';
$string['organisationeditframework'] = 'Edit organisation framework';
$string['organisationerror:createtype'] = 'Error creating organisation type "{$a}"';
$string['organisationerror:deleteassignedcompetency'] = 'Error unassigning competency from this organisation';
$string['organisationerror:deleteassignedgoal'] = 'Error unassigning goal from this organisation';
$string['organisationerror:deletedframework'] = 'Error deleting organisation framework "{$a}" and its data.';
$string['organisationerror:deletedtype'] = 'Error deleting organisation type "{$a}".';
$string['organisationerror:dialognotreeitems'] = 'No organisations in this framework';
$string['organisationerror:updatetype'] = 'Error updating organisation type "{$a}"';
$string['organisationfeatureplural'] = 'Organisations';
$string['organisationframework'] = 'Organisation framework';
$string['organisationframework_help'] = '**Organisation framework** is the name of the framework where you define your organisation.';
$string['organisationframeworkdescription'] = 'Description';
$string['organisationframeworkdescription_help'] = 'The framework description is a text field for storing additional information about the framework. It is displayed on the manage organisations page, just above the table of organisations.';
$string['organisationframeworkfullname_help'] = 'The framework full name is the complete title of the framework.';
$string['organisationframeworkidnumber'] = 'ID Number';
$string['organisationframeworkidnumber_help'] = 'The framework ID number is a unique number that can be used to represent the framework.';
$string['organisationframeworkmanage'] = 'Manage frameworks';
$string['organisationframeworks'] = 'Organisation Frameworks';
$string['organisationframeworks_help'] = 'An **Organisational Framework** is set up to hold the organisational structure of your organisation.

You can set up multiple organisational frameworks. For example, set up a framework for subdivisions or subsidiaries of a business.';
$string['organisationframeworkshortname'] = 'Organisation Framework short name';
$string['organisationframeworkshortname_help'] = 'The framework short name is a quick reference to the framework\'s full name and can be used for display purposes.';
$string['organisationfullname'] = 'Organisation full name';
$string['organisationfullname_help'] = 'Organisation full name is the complete title of the organisation.';
$string['organisationidnumber'] = 'Organisation ID number';
$string['organisationidnumber_help'] = 'Organisation ID number is a unique number used to represent the organisation.';
$string['organisationmanage'] = 'Manage organisations';
$string['organisationmissingname'] = 'Missing organisation name';
$string['organisationmissingnameframework'] = 'Missing organisation framework name';
$string['organisationmissingnametype'] = 'Missing organisation type name';
$string['organisationmissingshortname'] = 'Missing organisation short name';
$string['organisationnoframeworks'] = 'No organisation frameworks available';
$string['organisationnoframeworkssetup'] = 'There are no organisation frameworks setup for this site.';
$string['organisationnotfound'] = 'Organisation does not exist';
$string['organisationnotypes'] = 'No organisation types';
$string['organisationparent'] = 'Parent';
$string['organisationparent_help'] = '**Parent organisation** allows you to manage parent/child relationships between organisations.

Select the **Parent organisation** from the dropdown menu. Select **Top** if you want the organisation to sit at the top level of the hierarchy.

If you change the parent organisation of an item it will move to sit below its new parent, and all of its children will move with it.

Note that to set up parent/child relationships you need to have at least one other item in the framework. Otherwise the option will not appear.';
$string['organisationplural'] = 'Organisations';
$string['organisationreturntoframework'] = 'Return to organisation framework';
$string['organisations'] = 'Organisations';
$string['organisationshortname'] = 'Organisation short name';
$string['organisationshortname_help'] = 'Organisation short name is a quick reference name for the organisation and can be used for display purposes.';
$string['organisationtype'] = 'Type';
$string['organisationtype_help'] = 'Administrators can create and assign types of organisations. If an organisation is assigned a type it inherits any custom fields that have been assigned to that type. This allows you to organise meta-data relating to your organisations and only show the fields that each sort of organisation needs.';
$string['organisationtypecustomfields'] = 'Organisation type custom fields';
$string['organisationtypedescription'] = 'Organisation type description';
$string['organisationtypedescription_help'] = 'A longer text description of the organisation type.';
$string['organisationtypeidnumber'] = 'Organisation type ID number';
$string['organisationtypes'] = 'Organisation types';
$string['organisationupdatedframework'] = 'The organisation framework "{$a}" has been updated';
$string['organisationupdatetype'] = 'The organisation type "{$a}" has been updated';
$string['orgincludechildrenno'] = 'Ignore children';
$string['orgincludechildrenyes'] = 'Assign to child organisations';
$string['parent'] = 'Parent';
$string['parentchildselectedwarningdelete'] = 'Note: you have selected an item and also selected one of that item\'s children. Deleting an item will automatically delete all of its children. If you want to keep an item\'s children, move them before deleting the item.';
$string['parentchildselectedwarningmove'] = 'Warning: you have selected to move an item and also one or more of that item\'s children. When you move an item all its children will automatically be moved with it.';
$string['personal_goal_adder_filter_name'] = 'Search';
$string['personal_goal_adder_filter_title'] = 'Filter goals';
$string['personal_goal_adder_filter_type'] = 'Type';
$string['personal_goal_adder_label_name'] = 'Goal';
$string['personal_goal_adder_label_target_date'] = 'Target date';
$string['personal_goal_adder_no_items'] = 'No items to display';
$string['personal_goal_adder_title'] = 'Select personal goals';
$string['personal_goal_adder_type'] = 'Type';
$string['personalgoal'] = 'Personal goal';
$string['personalgoal_generic_display_name'] = 'goal';
$string['personalgoal_legacy'] = 'Legacy personal goal';
$string['personalgoals'] = 'Personal goals';
$string['personalgoaltype'] = 'Goal type';
$string['personalgoaltype_help'] = 'Select a goal type.';
$string['pickaframework'] = 'Pick a framework';
$string['pickfilehelp'] = 'If the file you want to restore is not available, make sure that the hierarchy backup .zip file is saved in {$a} and that permissions are correctly set.';
$string['pickfilemultiple'] = 'Pick a file to restore';
$string['pickfileone'] = 'One file found. Would you like to restore the file {$a}?';
$string['plandefaultvalue'] = 'Learning plan default value';
$string['plandefaultvalue_help'] = 'Within Learning Plans, this is the value that will automatically be awarded to a user when they have not yet demonstrated the proficiency required by the competency\'s evidence item(s) (course/activity completion, or passing course/activity grade), as specified in the learning plan.';
$string['pluginname'] = 'Hierarchies';
$string['posincludechildrenno'] = 'Ignore children';
$string['posincludechildrenyes'] = 'Assign to child positions';
$string['position'] = 'Position';
$string['position_deletion'] = 'Position deletion';
$string['positionaddedframework'] = 'The position framework "{$a}" has been added';
$string['positionaddnew'] = 'Add a new position';
$string['positionaddnewframework'] = 'Add new position framework';
$string['positionbacktoallframeworks'] = 'Back to all position frameworks';
$string['positionbulkaction'] = 'Bulk actions';
$string['positioncreatetype'] = 'The position type "{$a}" has been created';
$string['positioncustomfields'] = 'Custom fields';
$string['positiondeletedassignedcompetency'] = 'Competency unassigned successfully from this position';
$string['positiondeletedassignedgoal'] = 'Goal unassigned successfully from this position';
$string['positiondeletedframework'] = 'The position framework "{$a}" and its data have been completely deleted';
$string['positiondeletedtype'] = 'The position type "{$a}" has been completely deleted';
$string['positiondepthcustomfields'] = 'Position depth custom fields';
$string['positiondescription'] = 'Description';
$string['positiondescription_help'] = 'A free-text field for providing more details about this position. This data is displayed when viewing the hierarchy listing, and the individual position page.';
$string['positiondetails'] = 'Position Details';
$string['positioneditframework'] = 'Edit position framework';
$string['positionerror:createtype'] = 'Error creating position type "{$a}"';
$string['positionerror:deleteassignedcompetency'] = 'Error unassigning competency from this position';
$string['positionerror:deleteassignedgoal'] = 'Error unassigning goal from this position';
$string['positionerror:deletedframework'] = 'Error deleting position framework "{$a}" and its data.';
$string['positionerror:deletedtype'] = 'Error deleting position type "{$a}".';
$string['positionerror:dialognotreeitems'] = 'No positions in this framework';
$string['positionerror:updatetype'] = 'Error updating position type "{$a}"';
$string['positionfeatureplural'] = 'Positions';
$string['positionframework'] = 'Position framework';
$string['positionframework_help'] = '**Position Framework** is a specific framework for setting up a list of positions (job roles). You can have multiple position frameworks (lists).';
$string['positionframeworkdescription'] = 'Description';
$string['positionframeworkdescription_help'] = 'The framework description is a text field for storing additional information about the framework. It is displayed on the manage positions page, just above the table of positions.';
$string['positionframeworkfullname_help'] = 'The framework full name is the complete title of the framework.';
$string['positionframeworkidnumber'] = 'ID Number';
$string['positionframeworkidnumber_help'] = 'The Framework ID number is a unique number that can be used to represent the framework.';
$string['positionframeworkmanage'] = 'Manage frameworks';
$string['positionframeworks'] = 'Position frameworks';
$string['positionframeworks_help'] = 'A **Position framework** is used to set up and hold the different positions in the organisation.

You can set up multiple positions\' taxonomies (frameworks) within an organisation.';
$string['positionframeworkshortname'] = 'Position Framework shortname';
$string['positionframeworkshortname_help'] = 'The framework short name is a quick reference to the framework\'s full name and can be used for display purposes.';
$string['positionfullname'] = 'Position full name';
$string['positionfullname_help'] = '**Position full name** is the complete job title.';
$string['positionhistory'] = 'Position history';
$string['positionidnumber'] = 'Position ID number';
$string['positionidnumber_help'] = '**Position ID number** is a unique number used to represent the position. This is an optional field.';
$string['positionmanage'] = 'Manage positions';
$string['positionmissingname'] = 'Missing position name';
$string['positionmissingnameframework'] = 'Missing position framework name';
$string['positionmissingnametype'] = 'Missing position type name';
$string['positionmissingshortname'] = 'Missing position short name';
$string['positionnoframeworks'] = 'No position frameworks available';
$string['positionnoframeworkssetup'] = 'There are no position frameworks setup for this site.';
$string['positionnotfound'] = 'Position does not exist';
$string['positionnotypes'] = 'No position types';
$string['positionparent'] = 'Parent';
$string['positionparent_help'] = '**Parent position** allows you to manage parent/child relationships between positions.

Select the **Parent position** from the dropdown menu. Select **Top** if you want the position to sit at the top level of the hierarchy.

If you change the parent position of an item it will move to sit below its new parent, and all of its children will move with it.

Note that to set up parent/child relationships you need to have at least one other item in the framework. Otherwise the option will not appear.';
$string['positionplural'] = 'Positions';
$string['positionreturntoframework'] = 'Return to position framework';
$string['positions'] = 'Positions';
$string['positionsaved'] = 'Position saved.';
$string['positionshortname'] = 'Position short name';
$string['positionshortname_help'] = '**Position short name** is the quick reference name of the job title and can be used for display purposes.';
$string['positiontype'] = 'Type';
$string['positiontype_help'] = 'Administrators can create and assign types of positions. If a position is assigned a type it inherits any custom fields that have been assigned to that type. This allows you to organise meta-data relating to your positions and only show the fields that each sort of position needs.';
$string['positiontypecustomfields'] = 'Position type custom fields';
$string['positiontypedescription'] = 'Position type description';
$string['positiontypedescription_help'] = 'A longer text description of the position type.';
$string['positiontypeidnumber'] = 'Position type ID number';
$string['positiontypes'] = 'Position types';
$string['positionupdatedframework'] = 'The position framework "{$a}" has been updated';
$string['positionupdatetype'] = 'The position type "{$a}" has been updated';
$string['proficiency'] = 'Proficiency';
$string['proficientvaluefrozen'] = 'You cannot change this setting because the scale is in use';
$string['proficientvaluefrozenonlyprof'] = 'You cannot change this setting because the scale must have at least one proficient value at all times';
$string['queryerror'] = 'Query error. No results found.';
$string['reclassify1of2bulk'] = 'Reclassifying {$a->num} {$a->items} - step 1 of 2';
$string['reclassify1of2desc'] = 'Select the new type.';
$string['reclassify1of2item'] = 'Reclassifying "{$a->name}" - step 1 of 2';
$string['reclassifyingfromxtoybulk'] = 'Reclassifying {$a->num} {$a->items} from "{$a->from}" to "{$a->to}"';
$string['reclassifyingfromxtoyitem'] = 'Reclassifying "{$a->name}" from "{$a->from}" to "{$a->to}"';
$string['reclassifyitems'] = 'Reclassify items';
$string['reclassifyitemsanddelete'] = 'Reclassify items and delete data';
$string['reclassifyitemsandtransfer'] = 'Reclassify items and transfer/delete data';
$string['reclassifysuccessbulk'] = '{$a->num} {$a->items} reclassified from "{$a->from}" to "{$a->to}"';
$string['reclassifysuccessitem'] = '"{$a->name}" has been reclassified from "{$a->from}" to "{$a->to}"';
$string['reclassifytransferdata'] = 'You will have the opportunity to transfer custom field data in step 2.';
$string['relatedcompetencies'] = 'Related Competencies';
$string['relatedgoals'] = 'Related Goals';
$string['relateditemremovecheck'] = 'Are you absolutely sure you want to remove this goal relationship?';
$string['reloadpage'] = ' ~~~RELOAD PAGE~~~ ';
$string['removedcompetencyevidenceitem'] = 'The <em>{$a}</em> evidence item and its data have been removed';
$string['removedcompetencyrelateditem'] = 'The competency <em>{$a}</em> is no longer related to this competency';
$string['removedcompetencytemplatecompetency'] = 'The competency <em>{$a}</em> is no longer assigned to this template';
$string['removedgoalevidenceitem'] = 'The <em>{$a}</em> evidence item and its data have been removed';
$string['removedgoalrelateditem'] = 'The goal <em>{$a}</em> is no longer related to this goal';
$string['removedgoaltemplategoal'] = 'The goal <em>{$a}</em> is no longer assigned to this template';
$string['removegoal'] = 'Remove Goal';
$string['reportbuilderexportoptions_help'] = '**Positions enabled settings** allows a user with the appropriate permissions to specify the positions that are available in the system.

When no options are selected, the position functionality will be disabled completely.';
$string['restore'] = 'Restore';
$string['restorenousers'] = 'No Users found to restore.';
$string['restoreusers'] = '{$a} Users found to restore.';
$string['restoreusersanddata'] = 'Restore users and user data';
$string['saveandcontinueediting'] = 'Save and continue editing';
$string['scaleadded'] = 'Competency scale "{$a}" added';
$string['scaleaddedgoal'] = 'Goal scale "{$a}" added';
$string['scaledefaultupdated'] = 'The scale\'s default value has been updated';
$string['scales'] = 'Scales';
$string['scalescompcustomcreate'] = 'Add a new competency scale';
$string['scalesgoalcustomcreate'] = 'Add a new goal scale';
$string['scaleupdated'] = 'Competency scale "{$a}" updated';
$string['scaleupdatedgoal'] = 'Goal scale "{$a}" updated';
$string['scalevalueadded'] = 'Competency scale value "{$a}" has been added';
$string['scalevalueaddedgoal'] = 'Goal scale value "{$a}" has been added';
$string['scalevalues'] = 'Scale values';
$string['scalevalueupdated'] = 'Competency scale value "{$a}" has been updated';
$string['scalevalueupdatedgoal'] = 'Goal scale value "{$a}" has been updated';
$string['scalex'] = 'Scale "{$a}"';
$string['searchavailable'] = 'Search available items';
$string['selectacompetencyframework'] = 'Select a competency framework';
$string['selectagoalframework'] = 'Select a goal framework';
$string['selectcategoryandcourse'] = 'Select a course category then choose a course to pick evidence items from:';
$string['selectcompetency'] = 'Select competency';
$string['selected'] = 'Selected';
$string['selectedcompetencies'] = 'Selected competencies:';
$string['selectedcompetencytemplates'] = 'Selected competency templates:';
$string['selectedgoals'] = 'Selected goals:';
$string['selectedgoaltemplates'] = 'Selected goal templates:';
$string['selecteditems'] = 'Selected items';
$string['selectedx'] = 'Selected {$a}';
$string['selectframeworks'] = 'Select which frameworks to restore';
$string['selectgoal'] = 'Select goal';
$string['selectgoalframework'] = 'Select a goal framework';
$string['set'] = 'Set';
$string['settingsupdated'] = 'Settings updated';
$string['shortnamedepth'] = 'Depth level short name';
$string['shortnameframework'] = 'Shortname';
$string['shortnametemplate'] = 'Template short name';
$string['shortnametype'] = 'Type short name';
$string['shortnametype_help'] = 'The type short name is a quick reference to the type\'s full name and can be used for display purposes.';
$string['shortnameview'] = 'Short name';
$string['showdepthfullname'] = 'Show Depth Fullname';
$string['showdetails'] = 'Show details';
$string['showdisplayoptions'] = 'Show Display Options';
$string['showhierarchyshortnames'] = 'Display Hierarchy Shortnames';
$string['showingxofyforsearchz'] = 'Showing {$a->filteredcount} of {$a->allcount} for search "{$a->query}".';
$string['showitemfullname'] = 'Show Item Fullname';
$string['showtypefullname'] = 'Show Type Fullname';
$string['sortthreadview'] = 'Sort Thread';
$string['startdate'] = 'Start date';
$string['startdate_help'] = 'Click the calendar icon to select the date the user started in that position.';
$string['statusof'] = 'Status of {$a}';
$string['switchframework'] = 'Switch framework: ';
$string['template'] = 'Competency template';
$string['templatecompetencyremovecheck'] = 'Are you absolutely sure you want to unassign this competency from this template?';
$string['templategoalremovecheck'] = 'Are you absolutely sure you want to unassign this goal from this template?';
$string['titlefullname'] = 'Title (fullname)';
$string['titlefullname_help'] = 'This is the full name of the position (job role) title.';
$string['titleshortname'] = 'Title (shortname)';
$string['titleshortname_help'] = 'This is the short name of the position (job role) title and can be used for display purposes.';
$string['top'] = 'Top';
$string['transfertox'] = 'Transfer to {$a}';
$string['type'] = 'Type';
$string['typeprimary'] = 'Primary position';
$string['types'] = 'Types';
$string['typesecondary'] = 'Secondary position';
$string['unclassified'] = 'Unclassified';
$string['unknownbuttonclicked'] = 'Unknown button clicked';
$string['updatecompetenciestask'] = 'Update competency evidence';
$string['updatedcompetency'] = 'The competency "{$a}" has been updated';
$string['updatedgoal'] = 'The goal "{$a}" has been updated';
$string['updatedorganisation'] = 'The organisation "{$a}" has been updated';
$string['updatedposition'] = 'The position "{$a}" has been updated';
$string['updategoaltask'] = 'Update goal assignments';
$string['updateposition'] = 'Update position';
$string['updatescalevaluefailure'] = 'Scale value failed to update';
$string['updatescalevaluesuccess'] = 'Scale value updated';
$string['usedscale'] = 'Scale is already in use. New values may not be added.';
$string['useraspirationalposition'] = 'Aspirational position';
$string['useraspirationalposition_help'] = 'This is the target position the user will be progressing towards. Click **Choose position** to select the user\'s aspirational position from position framework(s) set up.';
$string['useresourcelevelevidence'] = 'Use resource-level evidence';
$string['weight'] = 'Weight';
$string['xandychild'] = '{$a->item} (and {$a->num} child)';
$string['xandychildren'] = '{$a->item} (and {$a->num} children)';
$string['xitemsdeleted'] = '{$a->num} {$a->items} and all children have been deleted';
$string['xitemsmoved'] = '{$a->num} {$a->items} and all children have been moved';

/**
 * Deprecated in 13
 */
$string['assignedcompetencies'] = 'Assigned Competencies';
$string['competencydeletecheck'] = 'Are you absolutely sure you want to completely delete this competency, all its children and the data they contain?';
$string['competencydeletecheck11'] = 'Are you sure you want to delete the competency "{$a}"?
<br /><br />
This will remove the following data:<br />
- The "{$a}" competency';
$string['competencydeletecheckwithchildren'] = 'Are you sure you want to delete the competency "{$a->itemname}" and its {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The "{$a->itemname}" competency and its {$a->childcount} {$a->children_string}';
$string['competencydeletemulticheckwithchildren'] = 'Are you sure you want to delete {$a->num} competency/competencies and {$a->childcount} {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The {$a->num} competency/competencies and {$a->childcount} {$a->children_string}';
$string['competencyscaleinusemayaffect'] = 'This scale is in use (i.e. users have competencies marked with values from this scale). Scale values cannot be created, re-ordered or deleted to preserve data integrity. You can still rename scale values but this may confuse users when their proficiency changes without warning. Changing the minimum required proficiency value may impact the proficiency status of users currently assigned to competencies using this scale.';
$string['competencyscalevalueconfirmproficient'] = 'The proficiency status of users currently assigned to competencies using this scale may be affected.

Do you want to proceed with applying these changes?';
$string['competencyscalevalueconfirmtitle'] = 'Confirm updates to scale values';
$string['confirmframeworkdeletion'] = 'Confirm framework deletion';
$string['delete_check_scale_value_pathways'] = 'Deleting the \'{$a->scale_value_name}\' scale value will affect competencies that have achievement pathways defined against it.
 A total of {$a->pathway_count} achievement pathway(s) will be deleted.';
$string['deletecheckframework'] = 'Are you sure you want to delete the framework "{$a}"?';
$string['deleteincludexcustomfields'] = '- {$a} custom field record(s)';
$string['deleteincludexevidence'] = '- {$a} item(s) of evidence';
$string['deleteincludexrelatedcompetencies'] = '- {$a} link(s) to related competencies';
$string['deleteincludexrelatedgoals'] = '- {$a} link(s) to related goals';
$string['deleteincludexuserassignments'] = '- {$a} user assignment(s)';
$string['deleteincludexuserstatusrecords'] = '- {$a} user status record(s)';
$string['goaldeletecheck'] = 'Are you absolutely sure you want to completely delete this goal, all its children and the data they contain?';
$string['goaldeletecheck11'] = 'Are you sure you want to delete the goal "{$a}"?
<br /><br />
This will remove the following data:<br />
- The "{$a}" goal';
$string['goaldeletecheckwithchildren'] = 'Are you sure you want to delete the goal "{$a->itemname}" and its {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The "{$a->itemname}" goal and its {$a->childcount} {$a->children_string}';
$string['goaldeletemulticheckwithchildren'] = 'Are you sure you want to delete {$a->num} goal(s) and {$a->childcount} {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The {$a->num} goal/goals and {$a->childcount} {$a->children_string}';
$string['goalmanage'] = 'Manage goals';
$string['managegoal'] = 'Manage goals';
$string['managegoals'] = 'Manage goals';
$string['organisationdeletecheck'] = 'Are you sure you want to delete this organisation, all its children and the data they contain?';
$string['organisationdeletecheck11'] = 'Are you sure you want to delete the organisation "{$a}"?
<br /><br />
This will remove the following data:<br />
- The "{$a}" organisation';
$string['organisationdeletecheckwithchildren'] = 'Are you sure you want to delete the organisation "{$a->itemname}" and its {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The "{$a->itemname}" organisation and its {$a->childcount} {$a->children_string}';
$string['organisationdeleteincludexjobassignments'] = '- {$a} assignment(s) to this organisation (users assigned to this organisation will be unassigned)';
$string['organisationdeletemulticheckwithchildren'] = 'Are you sure you want to delete {$a->num} organisation(s) and {$a->childcount} {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The {$a->num} organisation(s) and {$a->childcount} {$a->children_string}';
$string['positiondeletecheck'] = 'Are you sure you want to delete this position, all its children and the data they contain?';
$string['positiondeletecheck11'] = 'Are you sure you want to delete the position "{$a}"?
<br /><br />
This will remove the following data:<br />
- The "{$a}" position';
$string['positiondeletecheckwithchildren'] = 'Are you sure you want to delete the position "{$a->itemname}" and its {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The "{$a->itemname}" position and its {$a->childcount} {$a->children_string}';
$string['positiondeleteincludexjobassignments'] = '- {$a} assignment(s) to this position (users assigned to this position will be unassigned)';
$string['positiondeleteincludexlinkedcompetencies'] = '- {$a} links to competencies';
$string['positiondeleteincludexlinkedgoals'] = '- {$a} links to goals';
$string['positiondeletemulticheckwithchildren'] = 'Are you sure you want to delete {$a->num} position(s) and {$a->childcount} {$a->children_string}?
<br /><br />
This will remove the following data: <br />
- The {$a->num} position(s) and {$a->childcount} {$a->children_string}';
