<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2025 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Cody Finegan <cody.finegan@totara.com>
 * @package totara_job
 */

namespace totara_job\relationship;

use core\dml\sql;

/**
 * Helper class to determine how temporary managers work.
 */
final class temporary_managers {
    /**
     * @var bool|null
     */
    protected static ?bool $enabled = null;

    /**
     * Checks (once per request) whether temporary managers are used.
     *
     * @return bool
     */
    public static function has_temporary_managers(): bool {
        global $DB, $CFG;

        if (self::$enabled !== null) {
            return self::$enabled;
        }

        if (empty($CFG->enabletempmanagers)) {
            // Disabled at the setting level
            self::$enabled = false;
        } else {
            // Do we have any temporary managers assigned?
            // We only check the IDs for now, as expiry dates are unindex and wouldn't be performant enough.
            self::$enabled = $DB->record_exists_sql(new sql('SELECT 1 FROM {job_assignment} WHERE tempmanagerjaid IS NOT NULL'));
        }

        return self::$enabled;
    }
}