<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2022 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Gihan Hewaralalage <gihan.hewaralalage@totaralearning.com>
 * @package totara_notification
 */

namespace totara_notification\rb\display;

use html_writer;
use moodle_url;
use rb_column;
use reportbuilder;
use stdClass;
use totara_reportbuilder\rb\display\base;

class notification_delivery_log_link extends base {

    /**
     * @param int $notification_log_id
     * @param string $format
     * @param stdClass $row
     * @param rb_column $column
     * @param reportbuilder $report
     * @return string
     */
    public static function display($notification_log_id, $format, stdClass $row, rb_column $column, reportbuilder $report): string {
        if (empty($notification_log_id)) {
            return '';
        }

        $value = get_string('view_delivery_log', 'rb_source_notification_log');

        $params = ['notification_log_id' => $notification_log_id];
        foreach ($report->get_current_params() as $param) {
            $params[$param->name] = $param->value;
        }
        $url = new moodle_url('/totara/notification/notification_delivery_log.php', $params);

        return html_writer::link($url, $value);
    }
}