<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2020 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Qingyang Liu <qingyang.liu@totaralearning.com>
 * @package totara_playlist
 */

defined('MOODLE_INTERNAL') || die();

global $CFG;
require_once($CFG->dirroot.'/totara/playlist/db/upgradelib.php');

function xmldb_totara_playlist_upgrade($oldversion) {

    if ($oldversion < 2020100101) {
        totara_playlist_upgrade_fix_card_sort_order();

        // Playlist savepoint reached.
        upgrade_plugin_savepoint(true, 2020100101, 'totara', 'playlist');
    }

    if ($oldversion < 2024073101) {
        totara_playlist_remove_duplicate_resources();

        // Playlist savepoint reached.
        upgrade_plugin_savepoint(true, 2024073101, 'totara', 'playlist');
    }

    return true;
}
