<?php
/**
 * This file is part of Totara Learn
 *
 * Copyright (C) 2023 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Oleg Demeshev <oleg.demeshev@totara.com>
 * @package totara_reportbuilder
 */

namespace totara_reportbuilder\rb\display;

use core_user\profile\profilefield_decimal;
class userfield_decimal extends base {

    use userfield_trait;

    public static function display($value, $format, \stdClass $row, \rb_column $column, \reportbuilder $report) {
        global $CFG;
        require_once($CFG->dirroot.'/user/profile/field/decimal/field.class.php');

        if (!self::is_cell_visible($value, $format, $row, $column, $report)) {
            return get_string('hiddencellvalue', 'totara_reportbuilder');
        }

        if (is_null($value) || $value === '') {
            return '';
        }

        return format_float($value, $column->extracontext['param4'] ?? \profile_field_decimal::DECIMAL_POINTS);
    }
}
