<?php
/**
 * This file is part of Totara Core
 *
 * Copyright (C) 2010 onwards Totara Learning Solutions LTD
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @note Automatically cleaned: 2024-09-24
 * @package totara
 * @subpackage reportbuilder
 */

// lang string for totara/reportbuilder/rb_sources/rb_source_course_completion.php
$string['sourcelabel'] = 'Course';
$string['sourcesummary'] = 'Course completion status records including user details, course details and completion status.';
$string['sourcetitle'] = 'Course Completion';

/**
 * columns
 */
$string['completiondate'] = 'Completion Date';
$string['completionorgid'] = 'Completion Organisation ID';
$string['completionorgname'] = 'Completion Organisation Name';
$string['completionorgpath'] = 'Completion Organisation Path';
$string['completionposid'] = 'Completion Position ID';
$string['completionposname'] = 'Completion Position Name';
$string['completionpospath'] = 'Completion Position Path';
$string['completionstatus'] = 'Completion Status';
$string['dateenrolled'] = 'Date Enrolled';
$string['datestarted'] = 'Date Started';
$string['duedate'] = 'Due Date';
$string['grade'] = 'Grade';
$string['iscomplete'] = 'Is complete?';
$string['iscompleteany'] = 'Is complete? (any method)';
$string['iscompletenorpl'] = 'Is complete? (not via RPL)';
$string['iscompleterpl'] = 'Is complete? (via RPL)';
$string['isenrolled'] = 'Is enrolled';
$string['isinprogress'] = 'Is in progress?';
$string['isnotcomplete'] = 'Is not complete?';
$string['isnotyetstarted'] = 'Is not yet started?';
$string['passgrade'] = 'Pass Grade';
$string['progress'] = 'Progress';
$string['progressnumeric'] = 'Progress';
$string['progresspercent'] = 'Progress (%)';
$string['reqgrade'] = 'Required Grade';
$string['requiredgrade'] = 'Grade and required grade';
$string['rplnote'] = 'RPL note';
$string['timetocompletesinceenrol'] = 'Time taken to complete (since enrol date)';
$string['timetocompletesincestart'] = 'Time taken to complete (since start date)';

/**
 * filters
 */
$string['completionstatus'] = 'Completion Status';
$string['datecompleted'] = 'Date Completed';
$string['multiorgwhencompleted'] = 'Organisations when completed';
$string['multiposwhencompleted'] = 'Positions when completed';
$string['officewhencompletedbasic'] = 'Office when completed (basic)';
$string['orgwhencompleted'] = 'Organisation when completed';
$string['poswhencompleted'] = 'Position when completed';
$string['poswhencompletedbasic'] = 'Position when completed (basic)';

/**
 * content
 */
$string['completiondate'] = 'The completion date';
$string['currentorg'] = 'The user\'s current organisation';
$string['currentpos'] = 'The user\'s current position';
$string['orgwhencompleted'] = 'The organisation when completed';
$string['user'] = 'The user';

/**
 * column types for this source, as strings
 */
$string['type_course_completion'] = 'Course Completion';

/**
 * Templates.
 */
$string['template:leaner_course_completion:label'] = 'Learner';
$string['template:leaner_course_completion:numberofcourses'] = 'Number of Courses';
$string['template:leaner_course_completion:status'] = 'Status';
$string['template:leaner_course_completion:summary'] = 'This report gives the logged in user an overview of their own course completion status';
$string['template:leaner_course_completion:title'] = 'Learner course completion status overview';
$string['template:manager_course_completion:label'] = 'Manager';
$string['template:manager_course_completion:numberofcourses'] = 'Number of Courses';
$string['template:manager_course_completion:status'] = 'Status';
$string['template:manager_course_completion:summary'] = 'This report gives managers an overview of their own team course completion status.';
$string['template:manager_course_completion:title'] = 'Manager course completion status overview';
